/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.basicjaxb.lang.DefaultCopyStrategy;
import org.jvnet.basicjaxb.lang.StringUtils;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.locator.PropertyObjectLocator;
import org.jvnet.basicjaxb.locator.RootObjectLocator;
import org.jvnet.basicjaxb.locator.util.LocatorUtils;
import org.w3c.dom.Node;

public class JAXBCopyStrategy
extends DefaultCopyStrategy {
    private static final JAXBCopyStrategy INSTANCE = new JAXBCopyStrategy();

    public static JAXBCopyStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    protected <T> T observe(String label, ObjectLocator locator, T obj) {
        if (this.isTraceEnabled()) {
            this.trace(this.buildMessage(label, locator, StringUtils.valueToString(obj)));
        } else if (this.isDebugEnabled() && locator != null) {
            RootObjectLocator rootObjectLocator;
            PropertyObjectLocator parentPropertyLocator;
            if (locator instanceof RootObjectLocator) {
                this.debug(this.buildMessage(label, locator, StringUtils.valueToString(obj)));
            } else if (locator.getParentLocator() instanceof RootObjectLocator) {
                RootObjectLocator rootObjectLocator2 = (RootObjectLocator)locator.getParentLocator();
                if (rootObjectLocator2.getObject() instanceof JAXBElement) {
                    PropertyObjectLocator propertyLocator;
                    if (locator instanceof PropertyObjectLocator && "value".equals((propertyLocator = (PropertyObjectLocator)locator).getPropertyName())) {
                        this.debug(this.buildMessage(label, locator, StringUtils.valueToString(obj)));
                    }
                } else {
                    this.debug(this.buildMessage(label, locator, StringUtils.valueToString(obj)));
                }
            } else if (locator.getParentLocator() instanceof PropertyObjectLocator && "value".equals((parentPropertyLocator = (PropertyObjectLocator)locator.getParentLocator()).getPropertyName()) && locator.getParentLocator().getParentLocator() instanceof RootObjectLocator && (rootObjectLocator = (RootObjectLocator)locator.getParentLocator().getParentLocator()).getObject() instanceof JAXBElement) {
                this.debug(this.buildMessage(label, locator, StringUtils.valueToString(obj)));
            }
        }
        return obj;
    }

    @Override
    protected Object copyInternal(ObjectLocator locator, Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            return this.copyInternal(locator, node);
        }
        if (object instanceof JAXBElement) {
            JAXBElement jaxbElement = (JAXBElement)object;
            return this.copyInternal(locator, jaxbElement);
        }
        if (object instanceof List) {
            List list = (List)object;
            return this.copyInternal(locator, list);
        }
        return super.copyInternal(locator, object);
    }

    protected Object copyInternal(ObjectLocator locator, Node node) {
        return this.observe(locator, node.cloneNode(true));
    }

    protected Object copyInternal(ObjectLocator locator, JAXBElement jaxbElement) {
        Object sourceObject = jaxbElement.getValue();
        Object copyObject = this.copy((ObjectLocator)LocatorUtils.property(locator, "value", sourceObject), sourceObject);
        JAXBElement copyElement = new JAXBElement(jaxbElement.getName(), jaxbElement.getDeclaredType(), jaxbElement.getScope(), copyObject);
        return this.observe(locator, copyElement);
    }

    protected Object copyInternal(ObjectLocator locator, List list) {
        ArrayList<Object> copy = new ArrayList<Object>(list.size());
        for (int index = 0; index < list.size(); ++index) {
            Object element = list.get(index);
            Object copyElement = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
            copy.add(copyElement);
        }
        return this.observe(locator, copy);
    }
}

