/*
 * Decompiled with CFR 0.152.
 */
package org.patrodyne.jvnet.basicjaxb.explore;

import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import org.patrodyne.jvnet.basicjaxb.explore.ContextMenuListener;
import org.patrodyne.jvnet.basicjaxb.explore.SelectAllAction;

public class ConsoleWriter
extends Writer {
    private JTextArea textArea;

    public JTextArea getTextArea() {
        return this.textArea;
    }

    private void setTextArea(JTextArea textArea) {
        this.textArea = textArea;
    }

    public ConsoleWriter(int points) {
        this.setTextArea(new JTextArea());
        this.getTextArea().setEditable(false);
        this.getTextArea().setFont(new Font("monospaced", 0, points));
        this.getTextArea().setTabSize(4);
        this.getTextArea().addMouseListener(this.createContextMenuListener());
        this.getTextArea().addFocusListener(this.createFocusListener());
    }

    private FocusListener createFocusListener() {
        return new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ConsoleWriter.this.getTextArea().getCaret().setVisible(true);
            }
        };
    }

    private MouseListener createContextMenuListener() {
        JPopupMenu contextMenu = new JPopupMenu();
        contextMenu.add(new JMenuItem(new DefaultEditorKit.CopyAction()));
        contextMenu.add(new JMenuItem(new SelectAllAction()));
        return new ContextMenuListener(contextMenu);
    }

    public void largerText() {
        Font curFont = this.getTextArea().getFont();
        if (curFont.getSize() < 32) {
            this.getTextArea().setFont(curFont.deriveFont((float)curFont.getSize() + 1.0f));
        }
    }

    public void smallerText() {
        Font curFont = this.getTextArea().getFont();
        if (curFont.getSize() > 8) {
            this.getTextArea().setFont(curFont.deriveFont((float)curFont.getSize() - 1.0f));
        }
    }

    @Override
    public void write(char[] chars, int offset, int count) throws IOException {
        this.getTextArea().append(new String(chars, offset, count));
        this.getTextArea().setCaretPosition(this.getTextArea().getDocument().getLength());
    }

    public void clear() {
        try {
            this.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("cannot clear", ex);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            int length = this.getTextArea().getDocument().getLength();
            this.getTextArea().getDocument().remove(0, length);
        }
        catch (BadLocationException ex) {
            throw new IOException("cannot close", ex);
        }
    }

    @Override
    public void flush() throws IOException {
    }
}

