/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorInputFactory {
    private static Logger logger = LoggerFactory.getLogger(LocatorInputFactory.class);
    public static final String PROTOCOL_CLASSPATH = "classpath:";
    public static final String PROTOCOL_FILE = "file:";

    public static InputStream createInputStream(String locator) throws IOException {
        return LocatorInputFactory.createInputStream(locator, null);
    }

    public static InputStream createInputStream(String locator, Class<?> clazz) throws IOException {
        logger.debug("Locating: '" + locator + "' with " + String.valueOf(clazz));
        InputStream inputStream = null;
        if (locator != null) {
            if (locator.startsWith(PROTOCOL_CLASSPATH)) {
                String resourcePath = locator.substring(PROTOCOL_CLASSPATH.length());
                if (clazz != null) {
                    inputStream = clazz.getResourceAsStream(resourcePath);
                } else {
                    if (locator.startsWith("/")) {
                        locator = locator.substring(1);
                    }
                    inputStream = LocatorInputFactory.class.getClassLoader().getResourceAsStream(resourcePath);
                }
            } else {
                try {
                    URL url = new URL(locator);
                    inputStream = url.openStream();
                }
                catch (MalformedURLException ex) {
                    File file = new File(locator);
                    inputStream = new FileInputStream(file);
                }
            }
        }
        return inputStream;
    }

    public static Reader createReader(String locator) throws IOException {
        return LocatorInputFactory.createReader(locator, null);
    }

    public static Reader createReader(String locator, Class<?> clazz) throws IOException {
        InputStream inputStream = LocatorInputFactory.createInputStream(locator, clazz);
        if (inputStream != null) {
            return new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        }
        throw new FileNotFoundException(locator);
    }
}

