/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.valueconstructor;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.Customizations;
import org.jvnet.basicjaxb.plugin.CustomizedIgnoring;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.plugin.util.OutlineUtils;
import org.jvnet.basicjaxb.plugin.util.Selector;
import org.jvnet.basicjaxb.plugin.valueconstructor.ConstructorArgs;
import org.jvnet.basicjaxb.util.FieldAccessorUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;

public class ValueConstructorPlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "XvalueConstructor";
    private static final String OPTION_DESC = "enable generation of value constructor(s)";
    private Ignoring ignoring = new CustomizedIgnoring(org.jvnet.basicjaxb.plugin.valueconstructor.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    private boolean complete = true;
    private boolean required = true;
    private boolean selected = true;
    private boolean selectedKey = true;
    private boolean selectedKeyRef = false;
    private boolean selectedUnique = true;

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(org.jvnet.basicjaxb.plugin.valueconstructor.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelectedKey() {
        return this.selectedKey;
    }

    public void setSelectedKey(boolean selectedKey) {
        this.selectedKey = selectedKey;
    }

    public boolean isSelectedKeyRef() {
        return this.selectedKeyRef;
    }

    public void setSelectedKeyRef(boolean selectedKeyRef) {
        this.selectedKeyRef = selectedKeyRef;
    }

    public boolean isSelectedUnique() {
        return this.selectedUnique;
    }

    public void setSelectedUnique(boolean selectedUnique) {
        this.selectedUnique = selectedUnique;
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Complete.......: " + this.isComplete());
            sb.append("\n  Required.......: " + this.isRequired());
            sb.append("\n  Selected.......: " + this.isSelected());
            sb.append("\n  SelectedKey....: " + this.isSelectedKey());
            sb.append("\n  SelectedKeyRef.: " + this.isSelectedKeyRef());
            sb.append("\n  SelectedUnique.: " + this.isSelectedUnique());
            sb.append("\n  Verbose........: " + this.isVerbose());
            sb.append("\n  Debug..........: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        ClassOutline[] filteredClassOutlines = OutlineUtils.filter(outline, this.getIgnoring());
        ArrayList<Selector> selectors = new ArrayList();
        if (this.isSelected()) {
            selectors = this.processSelectors(outline, filteredClassOutlines);
        }
        for (ClassOutline classOutline : filteredClassOutlines) {
            this.processClassOutline(classOutline, selectors);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    protected void processClassOutline(ClassOutline theClassOutline, List<Selector> selectors) {
        String javadoc;
        ConstructorArgs constructorArgs4;
        JDefinedClass theDefinedClass = theClassOutline.implClass;
        FieldOutline[] superFields = this.getSuperClassFilteredFields(theClassOutline);
        FieldOutline[] localFields = OutlineUtils.filter(theClassOutline.getDeclaredFields(), this.getIgnoring());
        ArrayList<ConstructorArgs> constructorArgsList = new ArrayList<ConstructorArgs>();
        if (this.isComplete() && (superFields.length != 0 || localFields.length != 0) && !constructorArgsList.contains(constructorArgs4 = new ConstructorArgs(theDefinedClass, superFields, localFields, javadoc = "Complete field constructor"))) {
            constructorArgsList.add(constructorArgs4);
        }
        if (this.isRequired()) {
            String javadoc2;
            ConstructorArgs constructorArgs2;
            ArrayList<FieldOutline> reqSuperFields = new ArrayList<FieldOutline>();
            ArrayList<FieldOutline> reqLocalFields = new ArrayList<FieldOutline>();
            this.filterRequired(superFields, reqSuperFields);
            this.filterRequired(localFields, reqLocalFields);
            if (!(reqSuperFields.isEmpty() && reqLocalFields.isEmpty() || constructorArgsList.contains(constructorArgs2 = new ConstructorArgs(theDefinedClass, reqSuperFields, reqLocalFields, javadoc2 = "Required field constructor")))) {
                constructorArgsList.add(constructorArgs2);
            }
        }
        if (this.isSelected()) {
            for (Selector selector : selectors) {
                String javadoc3;
                ConstructorArgs constructorArgs3;
                ArrayList<FieldOutline> selSuperFields = new ArrayList<FieldOutline>();
                ArrayList<FieldOutline> selLocalFields = new ArrayList<FieldOutline>();
                List<JFieldVar> selFieldList = selector.getSelectedFieldMap().get(theDefinedClass);
                if (selFieldList == null) continue;
                for (FieldOutline superField : superFields) {
                    if (!selFieldList.contains(FieldAccessorUtils.field((FieldOutline)superField))) continue;
                    selSuperFields.add(superField);
                }
                for (FieldOutline localField : localFields) {
                    if (!selFieldList.contains(FieldAccessorUtils.field((FieldOutline)localField))) continue;
                    selLocalFields.add(localField);
                }
                if (selSuperFields.isEmpty() && selLocalFields.isEmpty() || constructorArgsList.contains(constructorArgs3 = new ConstructorArgs(theDefinedClass, selSuperFields, selLocalFields, javadoc3 = "Selector field constructor: " + selector.getIdentityConstraint().getName()))) continue;
                constructorArgsList.add(constructorArgs3);
            }
        }
        for (ConstructorArgs constructorArgs4 : constructorArgsList) {
            this.processFieldOutlines(constructorArgs4);
        }
        if (!constructorArgsList.isEmpty()) {
            this.processFieldOutlines(theDefinedClass, "Default constructor");
        }
    }

    private void filterRequired(FieldOutline[] theFields, List<FieldOutline> reqFields) {
        for (FieldOutline theField : theFields) {
            XSParticle particle;
            CPropertyInfo fieldInfo = theField.getPropertyInfo();
            if (fieldInfo.getSchemaComponent() instanceof XSAttributeUse) {
                XSAttributeUse attribute = (XSAttributeUse)fieldInfo.getSchemaComponent();
                if (!attribute.isRequired()) continue;
                reqFields.add(theField);
                continue;
            }
            if (!(fieldInfo.getSchemaComponent() instanceof XSParticle) || (particle = (XSParticle)fieldInfo.getSchemaComponent()).getMinOccurs() == null || particle.getMinOccurs().compareTo(BigInteger.ZERO) <= 0) continue;
            reqFields.add(theField);
        }
    }

    private void processFieldOutlines(JDefinedClass theDefinedClass, String javadoc) {
        JMethod defaultConstructor = theDefinedClass.constructor(1);
        defaultConstructor.javadoc().add((Object)javadoc);
        defaultConstructor.body().invoke("super");
        this.debug("{}, processFieldOutlines; Class={}, JavaDoc={}", new Object[]{LocatorUtils.toLocation((Object)theDefinedClass.metadata), theDefinedClass.name(), javadoc});
    }

    private void processFieldOutlines(ConstructorArgs args) {
        this.processFieldOutlines(args.getDefinedClass(), args.getSuperFieldList(), args.getLocalFieldList(), args.getJavaDoc());
    }

    private void processFieldOutlines(JDefinedClass theDefinedClass, List<FieldOutline> superFieldList, List<FieldOutline> localFieldList, String javadoc) {
        FieldOutline[] superFields = superFieldList.toArray(new FieldOutline[superFieldList.size()]);
        FieldOutline[] localFields = localFieldList.toArray(new FieldOutline[localFieldList.size()]);
        this.processFieldOutlines(theDefinedClass, superFields, localFields, javadoc);
    }

    private void processFieldOutlines(JDefinedClass theDefinedClass, FieldOutline[] superFields, FieldOutline[] localFields, String javadoc) {
        JMethod valueConstructor = theDefinedClass.constructor(1);
        valueConstructor.javadoc().add((Object)javadoc);
        if (theDefinedClass._extends() instanceof JDefinedClass) {
            this.generateSuperArgs(valueConstructor, theDefinedClass, superFields);
        }
        this.generateLocalArgs(valueConstructor, theDefinedClass, localFields);
        this.debug("{}, processFieldOutlines; Class={}, JavaDoc={}", new Object[]{LocatorUtils.toLocation((Object)theDefinedClass.metadata), theDefinedClass.name(), javadoc});
    }

    private List<Selector> processSelectors(Outline outline, ClassOutline[] filteredClassOutlines) {
        Model model = outline.getModel();
        XSSchemaSet modelSchemaSet = model.schemaComponent;
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        for (ClassOutline classOutline : filteredClassOutlines) {
            if (!(classOutline.getTarget() instanceof CClassInfo)) continue;
            CClassInfo ciTarget = (CClassInfo)classOutline.getTarget();
            if (ciTarget.getSchemaComponent() instanceof XSElementDecl) {
                XSElementDecl ciTargetED = (XSElementDecl)ciTarget.getSchemaComponent();
                for (XSIdentityConstraint ic : ciTargetED.getIdentityConstraints()) {
                    if (!this.isSelectedCategory(ic.getCategory())) continue;
                    selectors.add(new Selector(classOutline, ic));
                    this.trace("{}, processFieldOutlines; Class={}, Selector={}", new Object[]{LocatorUtils.toLocation((CClassInfo)ciTarget), ciTarget.getName(), ic.getName()});
                }
                continue;
            }
            XSComplexType ciTargetCT = (XSComplexType)ciTarget.getSchemaComponent();
            Iterator idConstraintsIter = modelSchemaSet.iterateIdentityConstraints();
            while (idConstraintsIter.hasNext()) {
                XSIdentityConstraint ic;
                ic = (XSIdentityConstraint)idConstraintsIter.next();
                XSElementDecl icParent = ic.getParent();
                XSType icParentType = icParent.getType();
                if (ciTargetCT != icParentType || !this.isSelectedCategory(ic.getCategory())) continue;
                selectors.add(new Selector(classOutline, ic));
                this.trace("{}, processFieldOutlines; Class={}, Selector={}", new Object[]{LocatorUtils.toLocation((CClassInfo)ciTarget), ciTarget.getName(), ic.getName()});
            }
        }
        return selectors;
    }

    private boolean isSelectedCategory(short category) {
        boolean isSelectedCategory = false;
        switch (category) {
            case 0: {
                isSelectedCategory = this.isSelectedKey();
                break;
            }
            case 1: {
                isSelectedCategory = this.isSelectedKeyRef();
                break;
            }
            case 2: {
                isSelectedCategory = this.isSelectedUnique();
            }
        }
        return isSelectedCategory;
    }

    private void generateSuperArgs(JMethod valueConstructor, JDefinedClass theDefinedClass, FieldOutline[] superClassFilteredFields) {
        JInvocation superInvocation = valueConstructor.body().invoke("super");
        for (FieldOutline superClassDeclaredField : superClassFilteredFields) {
            if (!this.generateConstructorParameter(superClassDeclaredField)) continue;
            CPropertyInfo propertyInfo = superClassDeclaredField.getPropertyInfo();
            String fieldName = propertyInfo.getName(false);
            JType fieldType = superClassDeclaredField.getRawType();
            JVar arg = valueConstructor.param(0, fieldType, fieldName);
            superInvocation.arg((JExpression)arg);
            this.trace("{}, generateSuperArgs; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((Locator)propertyInfo.getLocator()), theDefinedClass.name(), fieldName});
        }
    }

    private void generateLocalArgs(JMethod valueConstructor, JDefinedClass theDefinedClass, FieldOutline[] theClassFilteredFields) {
        for (FieldOutline theClassDeclaredField : theClassFilteredFields) {
            if (!this.generateConstructorParameter(theClassDeclaredField)) continue;
            CPropertyInfo propertyInfo = theClassDeclaredField.getPropertyInfo();
            String fieldName = propertyInfo.getName(false);
            JType fieldType = theClassDeclaredField.getRawType();
            JVar arg = valueConstructor.param(0, fieldType, fieldName);
            valueConstructor.body().assign((JAssignmentTarget)JExpr.refthis((String)fieldName), (JExpression)arg);
            this.trace("{}, generateLocalArgs; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((Locator)propertyInfo.getLocator()), theDefinedClass.name(), fieldName});
        }
    }

    protected boolean generateConstructorParameter(FieldOutline fieldOutline) {
        return true;
    }

    protected FieldOutline[] getSuperClassFilteredFields(ClassOutline classOutline) {
        LinkedList fieldOutlineList = new LinkedList();
        for (ClassOutline sco = classOutline.getSuperClass(); sco != null; sco = sco.getSuperClass()) {
            FieldOutline[] superFieldOutlines = OutlineUtils.filter(sco.getDeclaredFields(), this.getIgnoring());
            ArrayList<FieldOutline> superFieldOutlineList = new ArrayList<FieldOutline>();
            for (FieldOutline superFieldOutline : superFieldOutlines) {
                superFieldOutlineList.add(superFieldOutline);
            }
            fieldOutlineList.addAll(0, superFieldOutlineList);
        }
        return fieldOutlineList.toArray(new FieldOutline[fieldOutlineList.size()]);
    }
}

