/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.fixedvalue;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CBuiltinLeafInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CNonElement;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XmlString;
import com.sun.xml.xsom.impl.ParticleImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.glassfish.jaxb.core.api.impl.NameConverter;
import org.jvnet.basicjaxb.dom.DOMUtils;
import org.jvnet.basicjaxb.lang.ValueUtils;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.CustomizedIgnoring;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.plugin.fixedvalue.Customizations;
import org.jvnet.basicjaxb.plugin.util.OutlineUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.jvnet.basicjaxb.xml.namespace.util.QNameUtils;
import org.jvnet.basicjaxb.xmlschema.XmlSchemaConstants;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;

public class FixedValuePlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "XfixedValue";
    private static final String OPTION_DESC = "enable rewriting of classes to set fixed values as specified in XML schema";
    private static final JType[] NO_ARGS = new JType[0];
    private static final int CONSTANT_MODS = 25;
    private Ignoring ignoring = new CustomizedIgnoring(Customizations.IGNORED_ELEMENT_NAME, org.jvnet.basicjaxb.plugin.Customizations.IGNORED_ELEMENT_NAME, org.jvnet.basicjaxb.plugin.Customizations.GENERATED_ELEMENT_NAME);

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.IGNORED_ELEMENT_NAME, org.jvnet.basicjaxb.plugin.Customizations.IGNORED_ELEMENT_NAME, org.jvnet.basicjaxb.plugin.Customizations.GENERATED_ELEMENT_NAME);
    }

    protected void beforePostProcessModel(Model model) {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Verbose...: " + this.isVerbose());
            sb.append("\n  Debug.....: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterPostProcessModel(Model model, ErrorHandler errorHandler) {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError(errorHandler));
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void postProcessModel(Model model) {
        for (CClassInfo classInfo : model.beans().values()) {
            if (this.getIgnoring().isIgnored(classInfo)) continue;
            this.postProcessClassInfo(model, classInfo);
        }
    }

    private void postProcessClassInfo(Model model, CClassInfo classInfo) {
        for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
            if (this.getIgnoring().isIgnored(propertyInfo)) continue;
            this.postProcessPropertyInfo(model, classInfo, propertyInfo);
        }
    }

    private void postProcessPropertyInfo(Model model, CClassInfo classInfo, CPropertyInfo propertyInfo) {
        XSElementDecl xse;
        ParticleImpl xpi;
        XSComponent sc = propertyInfo.getSchemaComponent();
        if (sc instanceof ParticleImpl && (xpi = (ParticleImpl)sc).getTerm() instanceof XSElementDecl && (xse = (XSElementDecl)xpi.getTerm()).getFixedValue() != null) {
            String privateName = propertyInfo.getName(false);
            NameConverter nc = model.getNameConverter();
            String constantName = nc.toConstantName(privateName);
            propertyInfo.setName(false, constantName);
        }
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Verbose.: " + this.isVerbose());
            sb.append("\n  Debug...: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (ClassOutline classOutline : OutlineUtils.filter(outline, this.getIgnoring())) {
            this.processClassOutline(outline, classOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    protected void processClassOutline(Outline outline, ClassOutline classOutline) {
        FieldOutline[] declaredFilteredFields;
        for (FieldOutline fieldOutline : declaredFilteredFields = OutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring())) {
            XSElementDecl element;
            XSParticle particle;
            XSTerm term;
            JType fieldRawType = fieldOutline.getRawType();
            boolean fieldIsPrimitive = fieldRawType.isPrimitive();
            JType fieldType = fieldIsPrimitive ? fieldRawType.boxify() : fieldRawType;
            String typeFullName = fieldType.fullName();
            XmlString fixedValue = null;
            CPropertyInfo fieldInfo = fieldOutline.getPropertyInfo();
            QName schemaType = fieldInfo.getSchemaType();
            if (fieldInfo.getSchemaComponent() instanceof XSAttributeUse) {
                XSAttributeUse attribute = (XSAttributeUse)fieldInfo.getSchemaComponent();
                if (attribute.getFixedValue() != null) {
                    fixedValue = attribute.getFixedValue();
                    if (schemaType == null && fieldInfo instanceof CAttributePropertyInfo) {
                        CAttributePropertyInfo attrInfo = (CAttributePropertyInfo)fieldInfo;
                        CNonElement target = attrInfo.getTarget();
                        schemaType = target.getTypeName();
                    }
                }
            } else if (fieldInfo.getSchemaComponent() instanceof XSParticle && (term = (particle = (XSParticle)fieldInfo.getSchemaComponent()).getTerm()).isElementDecl() && (element = term.asElementDecl()).getFixedValue() != null) {
                XSType elementType;
                fixedValue = element.getFixedValue();
                if (schemaType == null && (elementType = element.getType()) != null && elementType.getName() != null) {
                    schemaType = new QName(elementType.getTargetNamespace(), elementType.getName());
                }
            }
            if (fixedValue == null) continue;
            this.processFixedValue(outline, classOutline, fieldOutline, fieldType, fieldIsPrimitive, typeFullName, fixedValue, schemaType);
        }
    }

    private void processFixedValue(Outline outline, ClassOutline classOutline, FieldOutline fieldOutline, JType fieldType, boolean fieldIsPrimitive, String typeFullName, XmlString fixedValue, QName schemaType) {
        JDefinedClass theClass = classOutline.implClass;
        CPropertyInfo fieldInfo = fieldOutline.getPropertyInfo();
        Map fields = theClass.fields();
        JFieldVar fieldVar = (JFieldVar)fields.get(fieldInfo.getName(false));
        String publicName = fieldInfo.getName(true);
        NameConverter nc = outline.getModel().getNameConverter();
        String constantName = nc.toConstantName(publicName);
        List<JMethod> propMethods = this.collectPropertyMethods(theClass, publicName, fieldOutline);
        JCodeModel theCodeModel = theClass.owner();
        JClass refValueUtils = theCodeModel.ref(ValueUtils.class);
        String fieldLoc = LocatorUtils.toLocation((Locator)fieldInfo.getLocator());
        String fieldName = fieldInfo.displayName();
        if (fieldType instanceof JDefinedClass && ((JDefinedClass)fieldType).getClassType() == ClassType.ENUM) {
            JEnumConstant literalValue = this.findEnumConstant(fieldType, fixedValue.value, outline);
            if (literalValue != null) {
                this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
                this.debug("{}, processFixedValue; {} = {} (Enum)", new Object[]{fieldLoc, fieldName, literalValue.getName()});
            }
        } else if (String.class.getName().equals(typeFullName)) {
            JExpression literalValue = CBuiltinLeafInfo.STRING.createConstant(outline, fixedValue);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, literalValue);
            this.debug("{}, processFixedValue; {} = \"{}\" (String)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if (Boolean.class.getName().equals(typeFullName)) {
            JExpression literalValue = CBuiltinLeafInfo.BOOLEAN.createConstant(outline, fixedValue);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, literalValue);
            this.debug("{}, processFixedValue; {} = {} (Boolean)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if (Byte.class.getName().equals(typeFullName)) {
            JExpression literalValue = CBuiltinLeafInfo.BYTE.createConstant(outline, fixedValue);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, literalValue);
            this.debug("{}, processFixedValue; {} = {} (Byte)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if (Short.class.getName().equals(typeFullName)) {
            JExpression literalValue = CBuiltinLeafInfo.SHORT.createConstant(outline, fixedValue);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, literalValue);
            this.debug("{}, processFixedValue; {} = {} (Short)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if (Integer.class.getName().equals(typeFullName)) {
            JExpression literalValue = CBuiltinLeafInfo.INT.createConstant(outline, fixedValue);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, literalValue);
            this.debug("{}, processFixedValue; {} = {} (Integer)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if (Long.class.getName().equals(typeFullName)) {
            JExpression literalValue = CBuiltinLeafInfo.LONG.createConstant(outline, fixedValue);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, literalValue);
            this.debug("{}, processFixedValue; {} = {} (Long)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if (Float.class.getName().equals(typeFullName)) {
            JExpression literalValue = CBuiltinLeafInfo.FLOAT.createConstant(outline, fixedValue);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, literalValue);
            this.debug("{}, processFixedValue; {} = {} (Float)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if (Double.class.getName().equals(typeFullName)) {
            JExpression literalValue = CBuiltinLeafInfo.DOUBLE.createConstant(outline, fixedValue);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, literalValue);
            this.debug("{}, processFixedValue; {} = {} (Double)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if (BigDecimal.class.getName().equals(typeFullName)) {
            JExpression literalValue = CBuiltinLeafInfo.BIG_DECIMAL.createConstant(outline, fixedValue);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, literalValue);
            this.debug("{}, processFixedValue; {} = {} (BigDecimal)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if (BigInteger.class.getName().equals(typeFullName)) {
            JExpression literalValue = CBuiltinLeafInfo.BIG_INTEGER.createConstant(outline, fixedValue);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, literalValue);
            this.debug("{}, processFixedValue; {} = {} (BigInteger)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if (byte[].class.getCanonicalName().equals(typeFullName) && schemaType == null || byte[].class.getCanonicalName().equals(typeFullName) && XmlSchemaConstants.BASE64BINARY.equals(schemaType)) {
            JExpression literalValue = CBuiltinLeafInfo.BASE64_BYTE_ARRAY.createConstant(outline, fixedValue);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, literalValue);
            this.debug("{}, processFixedValue; {} = {} (Base64Binary)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if (byte[].class.getCanonicalName().equals(typeFullName) && XmlSchemaConstants.HEXBINARY.equals(schemaType)) {
            JExpression literalValue = CBuiltinLeafInfo.HEXBIN_BYTE_ARRAY.createConstant(outline, fixedValue);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, literalValue);
            this.debug("{}, processFixedValue; {} = {} (HexBinary)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if (XMLGregorianCalendar.class.getName().equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toXMLGregorianCalendar").arg(fixedValue.value);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
            this.debug("{}, processFixedValue; {} = {} (XMLGregorianCalendar)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if (Duration.class.getName().equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toDuration").arg(fixedValue.value);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
            this.debug("{}, processFixedValue; {} = {} (Duration)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if (QName.class.getName().equals(typeFullName)) {
            JExpression literalValue = null;
            if (fieldInfo.defaultValue != null) {
                literalValue = fieldInfo.defaultValue.compute(classOutline.parent());
            } else {
                JFieldVar ofField = (JFieldVar)theClass.fields().get("OBJECT_FACTORY");
                if (ofField == null) {
                    ofField = this.installObjectFactory(theClass);
                }
                JClass refQNameUtils = theCodeModel.ref(QNameUtils.class);
                JInvocation jaxbElement = JExpr.invoke((JExpression)ofField, (String)("create" + publicName)).arg(JExpr._null());
                literalValue = refQNameUtils.staticInvoke("toName").arg((JExpression)jaxbElement).arg(fixedValue.value);
            }
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, literalValue);
            this.debug("{}, processFixedValue; {} = {} (QName)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if (Object.class.getName().equals(typeFullName) && XmlSchemaConstants.ANYSIMPLETYPE.equals(schemaType)) {
            JFieldVar ofField = (JFieldVar)theClass.fields().get("OBJECT_FACTORY");
            if (ofField == null) {
                ofField = this.installObjectFactory(theClass);
            }
            JClass refDOMUtils = theCodeModel.ref(DOMUtils.class);
            JInvocation jaxbElement = JExpr.invoke((JExpression)ofField, (String)("create" + publicName)).arg(fixedValue.value);
            JInvocation literalValue = refDOMUtils.staticInvoke("toNode").arg((JExpression)jaxbElement);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
            this.debug("{}, processFixedValue; {} = \"{}\" (Object)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if ((List.class.getName() + "<" + BigDecimal.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toBigDecimalList").arg(fixedValue.value);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
            this.debug("{}, processFixedValue; {} = {{}} (List<BigDecimal>)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if ((List.class.getName() + "<" + BigInteger.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toBigIntegerList").arg(fixedValue.value);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
            this.debug("{}, processFixedValue; {} = {{}} (List<BigInteger>)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if ((List.class.getName() + "<" + Boolean.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toBooleanList").arg(fixedValue.value);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
            this.debug("{}, processFixedValue; {} = {{}} (List<Boolean>)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if ((List.class.getName() + "<" + Byte.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toByteList").arg(fixedValue.value);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
            this.debug("{}, processFixedValue; {} = {{}} (List<Byte>)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if ((List.class.getName() + "<" + Double.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toDoubleList").arg(fixedValue.value);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
            this.debug("{}, processFixedValue; {} = {{}} (List<Double>)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if ((List.class.getName() + "<" + Duration.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toDurationList").arg(fixedValue.value);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
            this.debug("{}, processFixedValue; {} = {{}} (List<Duration>)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if ((List.class.getName() + "<" + Float.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toFloatList").arg(fixedValue.value);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
            this.debug("{}, processFixedValue; {} = {{}} (List<Float>)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if ((List.class.getName() + "<" + Integer.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toIntegerList").arg(fixedValue.value);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
            this.debug("{}, processFixedValue; {} = {{}} (List<Integer>)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if ((List.class.getName() + "<" + Long.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toLongList").arg(fixedValue.value);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
            this.debug("{}, processFixedValue; {} = {{}} (List<Long>)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if ((List.class.getName() + "<" + Short.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toShortList").arg(fixedValue.value);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
            this.debug("{}, processFixedValue; {} = {{}} (List<Short>)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if ((List.class.getName() + "<" + String.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toStringList").arg(fixedValue.value);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
            this.debug("{}, processFixedValue; {} = {{}} (List<String>)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else if ((List.class.getName() + "<" + XMLGregorianCalendar.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toXMLGregorianCalendarList").arg(fixedValue.value);
            this.initializer(theClass, fieldInfo, fieldVar, propMethods, constantName, (JExpression)literalValue);
            this.debug("{}, processFixedValue; {} = {{}} (List<XMLGregorianCalendar>)", new Object[]{fieldLoc, fieldName, fixedValue});
        } else {
            this.warn("{}, processFixedValue; Did not create fixed value for field {}. Don't know how to create fixed value expression for fields of type {} with schema type {}. Fixed value of \"{}\" specified in schema.", new Object[]{fieldLoc, fieldName, typeFullName, schemaType, fixedValue});
        }
    }

    private List<JMethod> collectPropertyMethods(JDefinedClass theClass, String publicName, FieldOutline fieldOutline) {
        JMethod reverter;
        JMethod detector;
        JMethod mutator;
        ArrayList<JMethod> propMethods = new ArrayList<JMethod>();
        JMethod accessor = theClass.getMethod("get" + publicName, NO_ARGS);
        if (accessor == null) {
            accessor = theClass.getMethod("is" + publicName, NO_ARGS);
        }
        if (accessor != null) {
            propMethods.add(accessor);
        }
        String mutatorName = "set" + publicName;
        JType mutatorType = fieldOutline.getRawType();
        JMethod boxifiedMutator = theClass.getMethod(mutatorName, new JType[]{mutatorType.boxify()});
        JMethod unboxifiedMutator = theClass.getMethod(mutatorName, new JType[]{mutatorType.unboxify()});
        JMethod jMethod = mutator = boxifiedMutator != null ? boxifiedMutator : unboxifiedMutator;
        if (mutator != null) {
            propMethods.add(mutator);
        }
        if ((detector = theClass.getMethod("isSet" + publicName, NO_ARGS)) != null) {
            propMethods.add(detector);
        }
        if ((reverter = theClass.getMethod("unset" + publicName, NO_ARGS)) != null) {
            propMethods.add(reverter);
        }
        return propMethods;
    }

    private void initializer(JDefinedClass theClass, CPropertyInfo fieldInfo, JFieldVar fieldVar, List<JMethod> propMethods, String constantName, JExpression literalValue) {
        theClass.removeField(fieldVar);
        JFieldVar constantField = theClass.field(25, fieldVar.type(), constantName, literalValue);
        if (!fieldVar.javadoc().isEmpty()) {
            constantField.javadoc().addAll((Collection)fieldVar.javadoc());
        }
        for (JAnnotationUse annotation : fieldVar.annotations()) {
            constantField.annotate(annotation);
        }
        theClass.methods().removeAll(propMethods);
        fieldInfo.setName(true, constantName);
    }

    private JEnumConstant findEnumConstant(JType enumType, String enumStringValue, Outline outline) {
        JEnumConstant ec = null;
        for (EnumOutline eo : outline.getEnums()) {
            if (eo.getImplClass() != enumType) continue;
            for (EnumConstantOutline eco : eo.constants) {
                if (!eco.target.getLexicalValue().equals(enumStringValue)) continue;
                ec = eco.constRef;
                break;
            }
            if (ec != null) continue;
            this.warn("{}, findEnumConstant; Could not find EnumConstant for value: \"{}\"", new Object[]{LocatorUtils.toLocation((Object)eo.getImplClass().metadata), enumStringValue});
            break;
        }
        if (ec == null) {
            this.warn("findEnumConstant; Could not find Enum class for type: " + enumType.fullName(), new Object[0]);
        }
        return ec;
    }

    private JFieldVar installObjectFactory(JDefinedClass theClass) {
        JClass ofClass = theClass.owner().ref(theClass.getPackage().name() + ".ObjectFactory");
        return theClass.field(28, (JType)ofClass, "OBJECT_FACTORY", JExpr.direct((String)"new ObjectFactory()"));
    }
}

