/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.wildcard;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.generator.annotation.spec.XmlAnyElementWriter;
import com.sun.tools.xjc.generator.annotation.spec.XmlElementRefWriter;
import com.sun.tools.xjc.generator.annotation.spec.XmlElementRefsWriter;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CElement;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.model.nav.NClass;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.annotation.W3CDomHandler;
import jakarta.xml.bind.annotation.XmlMixed;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.xml.namespace.QName;
import org.glassfish.jaxb.core.v2.TODO;
import org.glassfish.jaxb.core.v2.model.core.WildcardMode;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.wildcard.CReferencePropertyInfoPlus;
import org.jvnet.basicjaxb.plugin.wildcard.Customizations;
import org.jvnet.basicjaxb.plugin.wildcard.model.HandlerClass;
import org.jvnet.basicjaxb.util.CustomizationUtils;
import org.jvnet.basicjaxb.util.FieldAccessorUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;

public class WildcardPlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "Xwildcard";
    private static final String OPTION_DESC = "specify the wildcard mode and/or DomHandler";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.HANDLER_ELEMENT_NAME, Customizations.LAX_ELEMENT_NAME, Customizations.SKIP_ELEMENT_NAME, Customizations.STRICT_ELEMENT_NAME);
    }

    protected void beforePostProcessModel(Model model) {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Verbose.: " + this.isVerbose());
            sb.append("\n  Debug...: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterPostProcessModel(Model model, ErrorHandler errorHandler) {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError(errorHandler));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public void postProcessModel(Model model) throws ClassNotFoundException {
        HandlerClass handlerModel = this.toHandler(CustomizationUtils.findCustomization((Model)model, (QName)Customizations.HANDLER_ELEMENT_NAME));
        boolean laxModel = CustomizationUtils.containsCustomization((Model)model, (QName)Customizations.LAX_ELEMENT_NAME);
        boolean skipModel = CustomizationUtils.containsCustomization((Model)model, (QName)Customizations.SKIP_ELEMENT_NAME);
        boolean strictModel = CustomizationUtils.containsCustomization((Model)model, (QName)Customizations.STRICT_ELEMENT_NAME);
        for (CClassInfo classInfo : model.beans().values()) {
            CReferencePropertyInfo referencePropertyInfo;
            HandlerClass handlerClassInfo = this.toHandler(CustomizationUtils.findCustomization((CClassInfo)classInfo, (QName)Customizations.HANDLER_ELEMENT_NAME));
            boolean laxClassInfo = CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.LAX_ELEMENT_NAME);
            boolean skipClassInfo = CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.SKIP_ELEMENT_NAME);
            boolean strictClassInfo = CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.STRICT_ELEMENT_NAME);
            ArrayList<CPropertyInfo> propertInfoList = new ArrayList<CPropertyInfo>();
            for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
                if (propertyInfo instanceof CReferencePropertyInfo) {
                    referencePropertyInfo = (CReferencePropertyInfo)propertyInfo;
                    CReferencePropertyInfoPlus referencePropertyInfoPlus = new CReferencePropertyInfoPlus(referencePropertyInfo);
                    propertInfoList.add(referencePropertyInfoPlus);
                    continue;
                }
                propertInfoList.add(propertyInfo);
            }
            classInfo.getProperties().clear();
            classInfo.getProperties().addAll(propertInfoList);
            for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
                boolean strictPropertyInfo;
                boolean skipPropertyInfo;
                boolean laxPropertyInfo;
                HandlerClass handlerPropertyInfo;
                if (propertyInfo instanceof CReferencePropertyInfoPlus) {
                    CReferencePropertyInfoPlus referencePropertyInfoPlus = (CReferencePropertyInfoPlus)propertyInfo;
                    handlerPropertyInfo = this.toHandler(CustomizationUtils.findCustomization((CPropertyInfo)referencePropertyInfoPlus, (QName)Customizations.HANDLER_ELEMENT_NAME));
                    laxPropertyInfo = CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfoPlus, (QName)Customizations.LAX_ELEMENT_NAME);
                    skipPropertyInfo = CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfoPlus, (QName)Customizations.SKIP_ELEMENT_NAME);
                    strictPropertyInfo = CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfoPlus, (QName)Customizations.STRICT_ELEMENT_NAME);
                    if (handlerModel != null) {
                        referencePropertyInfoPlus.setDOMHandler(handlerModel.getValue());
                        if (handlerModel.isLax() != null) {
                            laxModel = handlerModel.isLax();
                        }
                    }
                    if (laxModel) {
                        referencePropertyInfoPlus.setWildcard(WildcardMode.LAX);
                    } else if (skipModel) {
                        referencePropertyInfoPlus.setWildcard(WildcardMode.SKIP);
                    } else if (strictModel) {
                        referencePropertyInfoPlus.setWildcard(WildcardMode.STRICT);
                    }
                    if (handlerClassInfo != null) {
                        referencePropertyInfoPlus.setDOMHandler(handlerClassInfo.getValue());
                        if (handlerClassInfo.isLax() != null) {
                            laxClassInfo = handlerClassInfo.isLax();
                        }
                    }
                    if (laxClassInfo) {
                        referencePropertyInfoPlus.setWildcard(WildcardMode.LAX);
                    } else if (skipClassInfo) {
                        referencePropertyInfoPlus.setWildcard(WildcardMode.SKIP);
                    } else if (strictClassInfo) {
                        referencePropertyInfoPlus.setWildcard(WildcardMode.STRICT);
                    }
                    if (handlerPropertyInfo != null) {
                        referencePropertyInfoPlus.setDOMHandler(handlerPropertyInfo.getValue());
                        if (handlerPropertyInfo.isLax() != null) {
                            laxPropertyInfo = handlerPropertyInfo.isLax();
                        }
                    }
                    if (laxPropertyInfo) {
                        referencePropertyInfoPlus.setWildcard(WildcardMode.LAX);
                    } else if (skipPropertyInfo) {
                        referencePropertyInfoPlus.setWildcard(WildcardMode.SKIP);
                    } else if (strictPropertyInfo) {
                        referencePropertyInfoPlus.setWildcard(WildcardMode.STRICT);
                    }
                    this.trace("{}, postProcessModel; Class={}, Property={}, Wildcard={}", new Object[]{LocatorUtils.toLocation((Locator)propertyInfo.getLocator()), classInfo.shortName, propertyInfo.getName(false), referencePropertyInfoPlus.getWildcard()});
                    continue;
                }
                if (!(propertyInfo instanceof CReferencePropertyInfo)) continue;
                referencePropertyInfo = (CReferencePropertyInfo)propertyInfo;
                handlerPropertyInfo = this.toHandler(CustomizationUtils.findCustomization((CPropertyInfo)referencePropertyInfo, (QName)Customizations.HANDLER_ELEMENT_NAME));
                laxPropertyInfo = CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, (QName)Customizations.LAX_ELEMENT_NAME);
                skipPropertyInfo = CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, (QName)Customizations.SKIP_ELEMENT_NAME);
                strictPropertyInfo = CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, (QName)Customizations.STRICT_ELEMENT_NAME);
                if (handlerModel != null && handlerModel.isLax() != null) {
                    laxModel = handlerModel.isLax();
                }
                if (laxModel) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                } else if (skipModel) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                } else if (strictModel) {
                    referencePropertyInfo.setWildcard(WildcardMode.STRICT);
                }
                if (handlerClassInfo != null && handlerClassInfo.isLax() != null) {
                    laxClassInfo = handlerClassInfo.isLax();
                }
                if (laxClassInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                } else if (skipClassInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                } else if (strictClassInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.STRICT);
                }
                if (handlerPropertyInfo != null && handlerPropertyInfo.isLax() != null) {
                    laxPropertyInfo = handlerPropertyInfo.isLax();
                }
                if (laxPropertyInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                } else if (skipPropertyInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                } else if (strictPropertyInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.STRICT);
                }
                this.trace("{}, postProcessModel; Class={}, Property={}, Wildcard={}", new Object[]{LocatorUtils.toLocation((Locator)propertyInfo.getLocator()), classInfo.shortName, propertyInfo.getName(false), referencePropertyInfo.getWildcard()});
            }
            this.debug("{}, postProcessModel; Class={}", new Object[]{LocatorUtils.toLocation((Locator)classInfo.getLocator()), classInfo.shortName});
        }
    }

    private HandlerClass toHandler(CPluginCustomization handlerCustomization) {
        HandlerClass handlerClass = null;
        if (handlerCustomization != null) {
            handlerClass = (HandlerClass)CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)handlerCustomization);
        }
        return handlerClass;
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Verbose.: " + this.isVerbose());
            sb.append("\n  Debug...: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClassOutline(outline, classOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    private void processClassOutline(Outline outline, ClassOutline classOutline) throws ClassNotFoundException {
        FieldOutline[] declaredFilteredFields;
        JDefinedClass theClass = classOutline.implClass;
        for (FieldOutline fieldOutline : declaredFilteredFields = classOutline.getDeclaredFields()) {
            CPropertyInfo fieldInfo = fieldOutline.getPropertyInfo();
            if (!(fieldInfo instanceof CReferencePropertyInfoPlus)) continue;
            CReferencePropertyInfoPlus refPropInfoPlus = (CReferencePropertyInfoPlus)fieldInfo;
            NClass domHandler = refPropInfoPlus.getDOMHandler();
            this.annotateReference(classOutline, (JAnnotatable)FieldAccessorUtils.field((FieldOutline)fieldOutline), refPropInfoPlus);
            this.trace("{}, processClassOutline; Class={}; Field={}; Handler={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name(), fieldInfo.getName(false), domHandler != null ? domHandler.fullName() : ""});
        }
        this.debug("{}, processClassOutline; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
    }

    private void annotateReference(ClassOutline classOutline, JAnnotatable field, CReferencePropertyInfoPlus refPropInfoPlus) {
        NClass dh;
        TODO.prototype();
        Set<CElement> elements = refPropInfoPlus.getElements();
        if (elements.size() == 1) {
            XmlElementRefWriter refw = (XmlElementRefWriter)field.annotate2(XmlElementRefWriter.class);
            CElement element = (CElement)elements.iterator().next();
            refw.name(element.getElementName().getLocalPart()).namespace(element.getElementName().getNamespaceURI()).type(((NType)element.getType()).toType(classOutline.parent(), Aspect.IMPLEMENTATION));
            refw.required(refPropInfoPlus.isRequired());
        } else if (elements.size() > 1) {
            XmlElementRefsWriter refsw = (XmlElementRefsWriter)field.annotate2(XmlElementRefsWriter.class);
            for (CElement element : elements) {
                XmlElementRefWriter refw = refsw.value();
                refw.name(element.getElementName().getLocalPart()).namespace(element.getElementName().getNamespaceURI()).type(((NType)element.getType()).toType(classOutline.parent(), Aspect.IMPLEMENTATION));
                refw.required(refPropInfoPlus.isRequired());
            }
        }
        if (refPropInfoPlus.isMixed()) {
            field.annotate(XmlMixed.class);
        }
        if ((dh = refPropInfoPlus.getDOMHandler()) != null) {
            XmlAnyElementWriter xaew = (XmlAnyElementWriter)field.annotate2(XmlAnyElementWriter.class);
            xaew.lax(refPropInfoPlus.getWildcard().allowTypedObject);
            JCodeModel codeModel = classOutline.parent().getCodeModel();
            JClass value = dh.toType(classOutline.parent(), Aspect.IMPLEMENTATION);
            if (!value.equals(codeModel.ref(W3CDomHandler.class))) {
                xaew.value((JType)value);
            }
        }
    }
}

