/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.propertylistener;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import jakarta.xml.bind.annotation.XmlTransient;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeSupport;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.lang.Bound;
import org.jvnet.basicjaxb.lang.Constrained;
import org.jvnet.basicjaxb.lang.DefaultVetoStrategy;
import org.jvnet.basicjaxb.lang.VetoStrategy;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.Customizations;
import org.jvnet.basicjaxb.plugin.CustomizedIgnoring;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.plugin.util.OutlineUtils;
import org.jvnet.basicjaxb.plugin.util.StrategyClassUtils;
import org.jvnet.basicjaxb.util.ClassUtils;
import org.jvnet.basicjaxb.util.CodeModelUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;

public class PropertyListenerPlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "XpropertyListener";
    private static final String OPTION_DESC = "generate bound and/or constrained properties";
    private Ignoring ignoring = new CustomizedIgnoring(org.jvnet.basicjaxb.plugin.propertylistener.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    private boolean bound = true;
    private boolean constrained = true;
    private String vetoStrategyClass = DefaultVetoStrategy.class.getName();

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(org.jvnet.basicjaxb.plugin.propertylistener.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bound) {
        this.bound = bound;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setConstrained(boolean constrained) {
        this.constrained = constrained;
    }

    public String getVetoStrategyClass() {
        return this.vetoStrategyClass;
    }

    public void setVetoStrategyClass(String vetoStrategy) {
        this.vetoStrategyClass = vetoStrategy;
    }

    public JExpression createVetoStrategy(JCodeModel codeModel) {
        return StrategyClassUtils.createStrategyInstanceExpression(codeModel, VetoStrategy.class, this.getVetoStrategyClass());
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Bound.............: " + this.isBound());
            sb.append("\n  Constrained.......: " + this.isConstrained());
            sb.append("\n  VetoStrategyClass.: " + this.getVetoStrategyClass());
            sb.append("\n  Verbose...........: " + this.isVerbose());
            sb.append("\n  Debug.............: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        JCodeModel codeModel = outline.getCodeModel();
        JExpression vetoStrategy = this.createVetoStrategy(codeModel);
        for (ClassOutline classOutline : OutlineUtils.filter(outline, this.getIgnoring())) {
            this.processClassOutline(classOutline, codeModel, vetoStrategy);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    protected void processClassOutline(ClassOutline classOutline, JCodeModel codeModel, JExpression vetoStrategy) {
        JDefinedClass theClass = classOutline.implClass;
        if (this.isBound() || this.isConstrained()) {
            int index = -1;
            if (this.isBound() && !StrategyClassUtils.superClassImplements(classOutline, this.getIgnoring(), Bound.class, false).booleanValue()) {
                ClassUtils._implements((JDefinedClass)theClass, (JClass)theClass.owner().ref(Bound.class));
                this.changeSupport(PropertyChangeSupport.class, theClass, codeModel, index++);
            }
            if (this.isConstrained() && !StrategyClassUtils.superClassImplements(classOutline, this.getIgnoring(), Constrained.class, false).booleanValue()) {
                ClassUtils._implements((JDefinedClass)theClass, (JClass)theClass.owner().ref(Constrained.class));
                this.changeSupport(VetoableChangeSupport.class, theClass, codeModel, index++);
            }
            for (FieldOutline fieldOutline : OutlineUtils.filter(classOutline, this.getIgnoring())) {
                this.processFieldOutline(fieldOutline, theClass, codeModel, vetoStrategy);
            }
        }
        this.debug("{}, processClassOutline; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
    }

    private void changeSupport(Class<?> clazz, JDefinedClass theClass, JCodeModel codeModel, int index) {
        JClass type = codeModel.ref(clazz);
        String pubName = clazz.getSimpleName();
        String name = Character.toLowerCase(pubName.charAt(0)) + pubName.substring(1);
        JFieldVar field = theClass.field(4, (JType)type, name, (JExpression)JExpr._new((JClass)type).arg(JExpr._this()));
        field.annotate(XmlTransient.class);
        JMethod getter = theClass.method(1, (JType)type, "get" + pubName);
        getter.body()._return((JExpression)field);
        getter.annotate(Override.class);
        CodeModelUtils.groupMethods((JDefinedClass)theClass, (int)index, (JMethod)getter);
    }

    private void processFieldOutline(FieldOutline fieldOutline, JDefinedClass theClass, JCodeModel codeModel, JExpression vetoStrategy) {
        JMethod setter;
        CPropertyInfo fieldInfo = fieldOutline.getPropertyInfo();
        JType setterType = fieldOutline.getRawType();
        String publicName = fieldInfo.getName(true);
        String setterName = "set" + publicName;
        JMethod boxifiedSetter = theClass.getMethod(setterName, new JType[]{setterType.boxify()});
        JMethod unboxifiedSetter = theClass.getMethod(setterName, new JType[]{setterType.unboxify()});
        JMethod jMethod = setter = boxifiedSetter != null ? boxifiedSetter : unboxifiedSetter;
        if (setter != null) {
            String fieldName = fieldInfo.getName(false);
            JFieldRef oldValue = JExpr._this().ref(fieldName);
            JVar newValue = setter.listParams()[0];
            JClass eventType = codeModel.ref(PropertyChangeEvent.class);
            JInvocation newEvent = JExpr._new((JClass)eventType).arg(JExpr._this()).arg(fieldName).arg((JExpression)oldValue).arg((JExpression)newValue);
            setter.body().pos(0);
            JVar event = setter.body().decl((JType)eventType, "event", (JExpression)newEvent);
            if (this.isConstrained()) {
                JConditional ifVetoPropertyChange = setter.body()._if((JExpression)JExpr._this().invoke("vetoPropertyChange").arg((JExpression)event).arg(vetoStrategy));
                ifVetoPropertyChange._then()._return();
            }
            setter.body().pos(setter.body().getContents().size());
            if (this.isBound()) {
                setter.body().invoke("firePropertyChange").arg((JExpression)event);
            }
            this.trace("{}, processFieldOutline; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((Locator)fieldInfo.getLocator()), theClass.name(), fieldName});
        }
    }
}

