/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.mergeable;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCast;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.lang.JAXBMergeStrategy;
import org.jvnet.basicjaxb.lang.MergeFrom;
import org.jvnet.basicjaxb.lang.MergeStrategy;
import org.jvnet.basicjaxb.locator.DefaultRootObjectLocator;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.CustomizedIgnoring;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.plugin.mergeable.Customizations;
import org.jvnet.basicjaxb.plugin.util.OutlineUtils;
import org.jvnet.basicjaxb.plugin.util.StrategyClassUtils;
import org.jvnet.basicjaxb.util.ClassUtils;
import org.jvnet.basicjaxb.util.FieldAccessorFactory;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.jvnet.basicjaxb.util.PropertyFieldAccessorFactory;
import org.jvnet.basicjaxb.xjc.outline.FieldAccessorEx;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;

public class MergeablePlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "Xmergeable";
    private static final String OPTION_DESC = "generate reflection-free methods to merge data from two objects into a target object";
    private FieldAccessorFactory fieldAccessorFactory = PropertyFieldAccessorFactory.INSTANCE;
    private String mergeStrategyClass = JAXBMergeStrategy.class.getName();
    private Ignoring ignoring = new CustomizedIgnoring(Customizations.IGNORED_ELEMENT_NAME, org.jvnet.basicjaxb.plugin.Customizations.IGNORED_ELEMENT_NAME, org.jvnet.basicjaxb.plugin.Customizations.GENERATED_ELEMENT_NAME);

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public FieldAccessorFactory getFieldAccessorFactory() {
        return this.fieldAccessorFactory;
    }

    public void setFieldAccessorFactory(FieldAccessorFactory fieldAccessorFactory) {
        this.fieldAccessorFactory = fieldAccessorFactory;
    }

    public String getMergeStrategyClass() {
        return this.mergeStrategyClass;
    }

    public void setMergeStrategyClass(String mergeStrategyClass) {
        this.mergeStrategyClass = mergeStrategyClass;
    }

    public JExpression createMergeStrategy(JCodeModel codeModel) {
        return StrategyClassUtils.createStrategyInstanceExpression(codeModel, MergeStrategy.class, this.getMergeStrategyClass());
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.IGNORED_ELEMENT_NAME, org.jvnet.basicjaxb.plugin.Customizations.IGNORED_ELEMENT_NAME, org.jvnet.basicjaxb.plugin.Customizations.GENERATED_ELEMENT_NAME);
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  MergeStrategyClass.: " + this.getMergeStrategyClass());
            sb.append("\n  Verbose............: " + this.isVerbose());
            sb.append("\n  Debug..............: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (ClassOutline classOutline : OutlineUtils.filter(outline, this.getIgnoring())) {
            this.processClassOutline(classOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    protected void processClassOutline(ClassOutline classOutline) {
        JDefinedClass theClass = classOutline.implClass;
        if (!classOutline.target.isAbstract()) {
            this.generateObject$createNewInstance(classOutline, theClass);
        }
        if (!StrategyClassUtils.superClassImplements(classOutline, this.getIgnoring(), MergeFrom.class, false).booleanValue()) {
            ClassUtils._implements((JDefinedClass)theClass, (JClass)theClass.owner().ref(MergeFrom.class));
            this.generateObject$mergeFrom(classOutline, theClass);
        }
        this.generateMergeFrom$mergeFrom(classOutline, theClass);
    }

    protected JMethod generateObject$createNewInstance(ClassOutline classOutline, JDefinedClass theClass) {
        JMethod existingMethod = theClass.getMethod("createNewInstance", new JType[0]);
        if (existingMethod == null) {
            JMethod newMethod = theClass.method(1, (JType)theClass.owner().ref(Object.class), "createNewInstance");
            newMethod.annotate(Override.class);
            JBlock body = newMethod.body();
            body._return((JExpression)JExpr._new((JClass)theClass));
            this.trace("{}, generateObject$createNewInstance; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
            return newMethod;
        }
        return existingMethod;
    }

    protected JMethod generateObject$mergeFrom(ClassOutline classOutline, JDefinedClass theClass) {
        JCodeModel codeModel = theClass.owner();
        JMethod mergeFrom$mergeFrom = theClass.method(1, (JType)codeModel.VOID, "mergeFrom");
        mergeFrom$mergeFrom.annotate(Override.class);
        JVar lhs = mergeFrom$mergeFrom.param(Object.class, "lhs");
        JVar rhs = mergeFrom$mergeFrom.param(Object.class, "rhs");
        JBlock body = mergeFrom$mergeFrom.body();
        JVar mergeStrategy = body.decl(8, (JType)codeModel.ref(MergeStrategy.class), "strategy", this.createMergeStrategy(codeModel));
        JInvocation lhsRootLocator = JExpr._new((JClass)codeModel.ref(DefaultRootObjectLocator.class)).arg((JExpression)lhs);
        JVar lhsLocator = body.decl(0, (JType)codeModel.ref(ObjectLocator.class), "lhsLocator", JExpr._null());
        JInvocation rhsRootLocator = JExpr._new((JClass)codeModel.ref(DefaultRootObjectLocator.class)).arg((JExpression)rhs);
        JVar rhsLocator = body.decl(0, (JType)codeModel.ref(ObjectLocator.class), "rhsLocator", JExpr._null());
        JConditional ifDebugEnabled = body._if((JExpression)mergeStrategy.invoke("isDebugEnabled"));
        ifDebugEnabled._then().assign((JAssignmentTarget)lhsLocator, (JExpression)lhsRootLocator);
        ifDebugEnabled._then().assign((JAssignmentTarget)rhsLocator, (JExpression)rhsRootLocator);
        body.invoke("mergeFrom").arg((JExpression)lhsLocator).arg((JExpression)rhsLocator).arg((JExpression)lhs).arg((JExpression)rhs).arg((JExpression)mergeStrategy);
        this.debug("{}, generateObject$mergeFrom; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
        return mergeFrom$mergeFrom;
    }

    protected JMethod generateMergeFrom$mergeFrom(ClassOutline classOutline, JDefinedClass theClass) {
        JCodeModel codeModel = theClass.owner();
        JMethod mergeFrom = theClass.method(1, (JType)codeModel.VOID, "mergeFrom");
        mergeFrom.annotate(Override.class);
        JVar lhsLocator = mergeFrom.param(ObjectLocator.class, "lhsLocator");
        JVar rhsLocator = mergeFrom.param(ObjectLocator.class, "rhsLocator");
        JVar lhs = mergeFrom.param(Object.class, "lhs");
        JVar rhs = mergeFrom.param(Object.class, "rhs");
        JVar mergeStrategy = mergeFrom.param(MergeStrategy.class, "strategy");
        JBlock methodBody = mergeFrom.body();
        Boolean superClassImplementsMergeFrom = StrategyClassUtils.superClassImplements(classOutline, this.getIgnoring(), MergeFrom.class);
        if (superClassImplementsMergeFrom != null && superClassImplementsMergeFrom.booleanValue()) {
            methodBody.invoke(JExpr._super(), "mergeFrom").arg((JExpression)lhsLocator).arg((JExpression)rhsLocator).arg((JExpression)lhs).arg((JExpression)rhs).arg((JExpression)mergeStrategy);
        }
        FieldOutline[] declaredFields = OutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring());
        HashMap<FieldOutline, FieldAccessorEx> lhsFieldAccessorMap = new HashMap<FieldOutline, FieldAccessorEx>();
        for (FieldOutline fieldOutline : declaredFields) {
            FieldAccessorEx lhsFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, (JExpression)lhs);
            if (lhsFieldAccessor.isConstant()) continue;
            lhsFieldAccessorMap.put(fieldOutline, lhsFieldAccessor);
        }
        if (lhsFieldAccessorMap.size() > 0) {
            JBlock body = methodBody._if(rhs._instanceof((JType)theClass))._then();
            JVar target = body.decl(8, (JType)theClass, "target", JExpr._this());
            JVar lhsObject = body.decl(8, (JType)theClass, "lhsObject", (JExpression)JExpr.cast((JType)theClass, (JExpression)lhs));
            JVar rhsObject = body.decl(8, (JType)theClass, "rhsObject", (JExpression)JExpr.cast((JType)theClass, (JExpression)rhs));
            for (FieldOutline fieldOutline : lhsFieldAccessorMap.keySet()) {
                FieldAccessorEx lhsFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, (JExpression)lhsObject);
                FieldAccessorEx rhsFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, (JExpression)rhsObject);
                if (lhsFieldAccessor.isConstant() || rhsFieldAccessor.isConstant()) continue;
                JBlock block = body.block();
                JExpression lhsFieldHasSetValueEx = lhsFieldAccessor.isAlwaysSet() || lhsFieldAccessor.hasSetValue() == null ? JExpr.TRUE : lhsFieldAccessor.hasSetValue();
                JExpression rhsFieldHasSetValueEx = rhsFieldAccessor.isAlwaysSet() || rhsFieldAccessor.hasSetValue() == null ? JExpr.TRUE : rhsFieldAccessor.hasSetValue();
                JVar lhsFieldIsSet = block.decl(codeModel.ref(Boolean.class).unboxify(), "lhsFieldIsSet", lhsFieldHasSetValueEx);
                JVar rhsFieldIsSet = block.decl(codeModel.ref(Boolean.class).unboxify(), "rhsFieldIsSet", rhsFieldHasSetValueEx);
                JVar shouldBeSet = block.decl((JType)codeModel.ref(Boolean.class), this.fieldName("both") + "ShouldBeMergedAndSet", (JExpression)mergeStrategy.invoke("shouldBeMergedAndSet").arg((JExpression)lhsLocator).arg((JExpression)rhsLocator).arg((JExpression)lhsFieldIsSet).arg((JExpression)rhsFieldIsSet));
                JConditional ifShouldBeSetConditional = block._if(JOp.eq((JExpression)shouldBeSet, (JExpression)codeModel.ref(Boolean.class).staticRef("TRUE")));
                JBlock ifShouldBeSetBlock = ifShouldBeSetConditional._then();
                JConditional ifShouldNotBeSetConditional = ifShouldBeSetConditional._elseif(JOp.eq((JExpression)shouldBeSet, (JExpression)codeModel.ref(Boolean.class).staticRef("FALSE")));
                JBlock ifShouldBeUnsetBlock = ifShouldNotBeSetConditional._then();
                JVar lhsField = ifShouldBeSetBlock.decl(lhsFieldAccessor.getType(), this.fieldName("lhs"));
                lhsFieldAccessor.toRawValue(ifShouldBeSetBlock, lhsField);
                JVar rhsField = ifShouldBeSetBlock.decl(rhsFieldAccessor.getType(), this.fieldName("rhs"));
                rhsFieldAccessor.toRawValue(ifShouldBeSetBlock, rhsField);
                String fieldName = this.fieldName(fieldOutline);
                JInvocation lhsFieldLocatorEx = codeModel.ref(org.jvnet.basicjaxb.locator.util.LocatorUtils.class).staticInvoke("property").arg((JExpression)lhsLocator).arg(fieldName).arg((JExpression)lhsField);
                JInvocation rhsFieldLocatorEx = codeModel.ref(org.jvnet.basicjaxb.locator.util.LocatorUtils.class).staticInvoke("property").arg((JExpression)rhsLocator).arg(fieldName).arg((JExpression)rhsField);
                JVar lhsFieldLocator = ifShouldBeSetBlock.decl(lhsLocator.type(), "lhsFieldLocator", (JExpression)lhsFieldLocatorEx);
                JVar rhsFieldLocator = ifShouldBeSetBlock.decl(lhsLocator.type(), "rhsFieldLocator", (JExpression)rhsFieldLocatorEx);
                FieldAccessorEx targetFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, (JExpression)target);
                JCast mergedValue = JExpr.cast((JType)targetFieldAccessor.getType(), (JExpression)mergeStrategy.invoke("merge").arg((JExpression)lhsFieldLocator).arg((JExpression)rhsFieldLocator).arg((JExpression)lhsField).arg((JExpression)rhsField).arg((JExpression)lhsFieldIsSet).arg((JExpression)rhsFieldIsSet));
                JVar mergedField = ifShouldBeSetBlock.decl(rhsFieldAccessor.getType(), this.fieldName("merged"), (JExpression)mergedValue);
                JType mergedFieldType = rhsFieldAccessor.getType();
                if (mergedFieldType instanceof JClass && ((JClass)mergedFieldType).isParameterized()) {
                    mergedField.annotate(SuppressWarnings.class).param("value", "unchecked");
                }
                targetFieldAccessor.fromRawValue(ifShouldBeSetBlock, this.fieldName("unique"), (JExpression)mergedField);
                targetFieldAccessor.unsetValues(ifShouldBeUnsetBlock);
                this.trace("{}, generateMergeFrom$mergeFrom; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((Locator)fieldOutline.getPropertyInfo().getLocator()), theClass.name(), fieldName});
            }
        }
        return mergeFrom;
    }

    private String fieldName(FieldOutline fieldOutline) {
        return fieldOutline.getPropertyInfo().getName(false);
    }

    private String fieldName(String prefix) {
        return prefix + "Field";
    }

    private String fieldName(String prefix, FieldOutline fieldOutline) {
        return this.fieldName(prefix) + fieldOutline.getPropertyInfo().getName(true);
    }
}

