/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.inheritance;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.model.CClass;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassRef;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.outline.PackageOutline;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIEnum;
import jakarta.xml.bind.JAXBContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.inheritance.Customizations;
import org.jvnet.basicjaxb.plugin.inheritance.model.AnnotatesMetaObject;
import org.jvnet.basicjaxb.plugin.inheritance.model.ExtendsClass;
import org.jvnet.basicjaxb.plugin.inheritance.model.ImplementsInterface;
import org.jvnet.basicjaxb.plugin.inheritance.model.ObjectFactoryCustomization;
import org.jvnet.basicjaxb.plugin.inheritance.util.JavaTypeParser;
import org.jvnet.basicjaxb.util.CustomizationUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.xml.sax.ErrorHandler;

public class InheritancePlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "Xinheritance";
    private static final String OPTION_DESC = "locally annotate, extend or implement schema-derived classes";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.ANNOTATES_ELEMENT_NAME, Customizations.ANNOTATES_ELEMENT_ELEMENT_NAME, Customizations.ANNOTATES_ELEMENTS_ELEMENT_NAME, Customizations.EXTENDS_ELEMENT_NAME, Customizations.IMPLEMENTS_ELEMENT_NAME, Customizations.OBJECT_FACTORY_ELEMENT_NAME);
    }

    private void ignoreCustomzationsOnProperties(ClassOutline classOutline) {
        for (CPropertyInfo propertyInfo : classOutline.target.getProperties()) {
            CustomizationUtils.findCustomization((CPropertyInfo)propertyInfo, (QName)Customizations.ANNOTATES_ELEMENT_NAME);
            CustomizationUtils.findCustomization((CPropertyInfo)propertyInfo, (QName)Customizations.ANNOTATES_ELEMENT_ELEMENT_NAME);
            CustomizationUtils.findCustomization((CPropertyInfo)propertyInfo, (QName)Customizations.ANNOTATES_ELEMENTS_ELEMENT_NAME);
            CustomizationUtils.findCustomization((CPropertyInfo)propertyInfo, (QName)Customizations.EXTENDS_ELEMENT_NAME);
            CustomizationUtils.findCustomization((CPropertyInfo)propertyInfo, (QName)Customizations.IMPLEMENTS_ELEMENT_NAME);
        }
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Verbose.: " + this.isVerbose());
            sb.append("\n  Debug...: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        HashMap<String, JClass> knownClasses = new HashMap<String, JClass>();
        IdentityHashMap<JClass, CClassInfo> knownClassInfos = new IdentityHashMap<JClass, CClassInfo>();
        for (ClassOutline classOutline : outline.getClasses()) {
            knownClasses.put(classOutline.implClass.fullName(), (JClass)classOutline.implClass);
            knownClassInfos.put((JClass)classOutline.implClass, classOutline.target);
        }
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClassOutline(classOutline, knownClasses, knownClassInfos);
        }
        for (EnumOutline enumOutline : outline.getEnums()) {
            this.processEnumOutline(enumOutline, knownClasses);
        }
        for (CElementInfo elementInfo : outline.getModel().getAllElements()) {
            ElementOutline elementOutline = outline.getElement(elementInfo);
            if (elementOutline == null) continue;
            this.processElementOutline(elementOutline, knownClasses);
        }
        this.processPackageOutlines(outline, knownClasses);
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    private void processClassOutline(ClassOutline classOutline, Map<String, JClass> knownClasses, Map<JClass, CClassInfo> knownClassInfos) {
        this.generateAnnotates(classOutline, knownClasses);
        this.generateExtends(classOutline, knownClasses, knownClassInfos);
        this.generateImplements(classOutline, knownClasses);
        this.ignoreCustomzationsOnProperties(classOutline);
    }

    private void processEnumOutline(EnumOutline enumOutline, Map<String, JClass> knownClasses) {
        this.generateAnnotates(enumOutline, knownClasses);
        this.generateExtends(enumOutline, knownClasses);
        this.generateImplements(enumOutline, knownClasses);
    }

    private void processElementOutline(ElementOutline elementOutline, Map<String, JClass> knownClasses) {
        this.generateAnnotates(elementOutline, knownClasses);
        this.generateExtends(elementOutline, knownClasses);
        this.generateImplements(elementOutline, knownClasses);
    }

    private void processPackageOutlines(Outline outline, Map<String, JClass> knownClasses) {
        List customizations = CustomizationUtils.findCustomizations((Outline)outline, (QName)Customizations.OBJECT_FACTORY_ELEMENT_NAME);
        for (CPluginCustomization customization : customizations) {
            ObjectFactoryCustomization objectFactoryCustomization = (ObjectFactoryCustomization)CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)customization);
            String packageName = objectFactoryCustomization.getPackageName();
            if (packageName == null) continue;
            for (PackageOutline packageOutline : outline.getAllPackageContexts()) {
                List<ImplementsInterface> implementsInterfaces;
                ExtendsClass extendsClass;
                JDefinedClass theObjectFactoryClass = packageOutline.objectFactory();
                if (!packageName.equals(packageOutline._package().name())) continue;
                List<AnnotatesMetaObject> annotatesMetaObjects = objectFactoryCustomization.getAnnotates();
                if (annotatesMetaObjects != null) {
                    for (AnnotatesMetaObject annotatesMetaObject : annotatesMetaObjects) {
                        if (annotatesMetaObject == null) continue;
                        this.generateAnnotates(theObjectFactoryClass, annotatesMetaObject, knownClasses);
                    }
                }
                if ((extendsClass = objectFactoryCustomization.getExtends()) != null) {
                    this.generateExtends(theObjectFactoryClass, extendsClass, knownClasses);
                }
                if ((implementsInterfaces = objectFactoryCustomization.getImplements()) == null) continue;
                for (ImplementsInterface implementsInterface : implementsInterfaces) {
                    if (implementsInterface == null) continue;
                    this.generateImplements(theObjectFactoryClass, implementsInterface, knownClasses);
                }
            }
        }
    }

    private List<JClass> generateAnnotates(ClassOutline classOutline, Map<String, JClass> knownClasses) {
        JDefinedClass theClass = classOutline.implClass;
        List annotatesMetaObjectCustomizations = CustomizationUtils.findCustomizations((ClassOutline)classOutline, (QName)Customizations.ANNOTATES_ELEMENT_NAME);
        return this.generateAnnotates(theClass, annotatesMetaObjectCustomizations, knownClasses);
    }

    private List<JClass> generateAnnotates(EnumOutline enumOutline, Map<String, JClass> knownClasses) {
        JDefinedClass theClass = enumOutline.clazz;
        List annotatesMetaObjectCustomizations = CustomizationUtils.findCustomizations((EnumOutline)enumOutline, (QName)Customizations.ANNOTATES_ELEMENT_NAME);
        return this.generateAnnotates(theClass, annotatesMetaObjectCustomizations, knownClasses);
    }

    private List<JClass> generateAnnotates(ElementOutline elementOutline, Map<String, JClass> knownClasses) {
        JDefinedClass theClass = elementOutline.implClass;
        List annotatesMetaObjectCustomizations = CustomizationUtils.findCustomizations((ElementOutline)elementOutline, (QName)Customizations.ANNOTATES_ELEMENT_NAME);
        return this.generateAnnotates(theClass, annotatesMetaObjectCustomizations, knownClasses);
    }

    private List<JClass> generateAnnotates(JDefinedClass theClass, List<CPluginCustomization> annotatesMetaObjectCustomizations, Map<String, JClass> knownClasses) throws AssertionError {
        ArrayList<JClass> annotatedMetaObjects = new ArrayList<JClass>(annotatesMetaObjectCustomizations.size());
        for (CPluginCustomization annotatesMetaObjectCustomization : annotatesMetaObjectCustomizations) {
            AnnotatesMetaObject annotatesMetaObject;
            JClass annotatedMetaObject;
            if (annotatesMetaObjectCustomization == null || (annotatedMetaObject = this.generateAnnotates(theClass, annotatesMetaObject = (AnnotatesMetaObject)CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)annotatesMetaObjectCustomization), knownClasses)) == null) continue;
            annotatedMetaObjects.add(annotatedMetaObject);
        }
        return annotatedMetaObjects;
    }

    private JClass generateAnnotates(JDefinedClass theClass, AnnotatesMetaObject annotatesMetaObject, Map<String, JClass> knownClasses) {
        String annotation = annotatesMetaObject.getAnnotation();
        if (annotation != null) {
            Object obj;
            String name;
            JClass targetClass = this.parseClass(annotation, theClass.owner(), knownClasses);
            JAnnotationUse use = theClass.annotate(targetClass);
            for (AnnotatesMetaObject.Element element : annotatesMetaObject.getElement()) {
                name = element.getName();
                obj = "all";
                if (element.getValue() == null) {
                    use.param(name, obj.toString());
                } else {
                    obj = this.parse(element.getValue(), element.getType());
                    this.useParameter(use, name, obj);
                }
                this.trace("{}, generateAnnotates; Class={}, Annotation={}, {}='{}'", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name(), targetClass.name(), name, obj});
            }
            for (AnnotatesMetaObject.Elements elements : annotatesMetaObject.getElements()) {
                name = elements.getName();
                obj = "all";
                int valueSize = elements.getValue().size();
                if (valueSize == 0) {
                    use.param(name, obj.toString());
                    this.trace("{}, generateAnnotates; Class={}, Annotation={}, {}='{}'", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name(), targetClass.name(), name, obj});
                    continue;
                }
                if (valueSize == 1) {
                    obj = this.parse(elements.getValue().get(0), elements.getType());
                    this.useParameter(use, name, obj);
                    this.trace("{}, generateAnnotates; Class={}, Annotation={}, {}='{}'", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name(), targetClass.name(), name, obj});
                    continue;
                }
                if (valueSize <= 1) continue;
                JAnnotationArrayMember values = use.paramArray(name);
                for (String value : elements.getValue()) {
                    obj = this.parse(value, elements.getType());
                    this.addParameterValue(values, obj);
                    this.trace("{}, generateAnnotates; Class={}, Annotation={}, {}='{}'", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name(), targetClass.name(), name, obj});
                }
            }
            this.debug("{}, generateAnnotates; Class={}, Annotation={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name(), targetClass.name()});
            return targetClass;
        }
        return null;
    }

    private void useParameter(JAnnotationUse use, String name, Object value) {
        if (value instanceof String) {
            use.param(name, (String)value);
        } else if (value instanceof Boolean) {
            use.param(name, ((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            use.param(name, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            use.param(name, ((Long)value).longValue());
        } else if (value instanceof Short) {
            use.param(name, ((Short)value).shortValue());
        } else if (value instanceof Double) {
            use.param(name, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            use.param(name, ((Float)value).floatValue());
        } else if (value instanceof Byte) {
            use.param(name, ((Byte)value).byteValue());
        } else if (value instanceof Character) {
            use.param(name, ((Character)value).charValue());
        } else if (value instanceof Enum) {
            use.param(name, (Enum)value);
        } else if (value instanceof Class) {
            use.param(name, (Class)value);
        }
    }

    private void addParameterValue(JAnnotationArrayMember values, Object value) {
        if (value instanceof String) {
            values.param((String)value);
        } else if (value instanceof Boolean) {
            values.param(((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            values.param(((Integer)value).intValue());
        } else if (value instanceof Long) {
            values.param(((Long)value).longValue());
        } else if (value instanceof Short) {
            values.param(((Short)value).shortValue());
        } else if (value instanceof Double) {
            values.param(((Double)value).doubleValue());
        } else if (value instanceof Float) {
            values.param(((Float)value).floatValue());
        } else if (value instanceof Byte) {
            values.param(((Byte)value).byteValue());
        } else if (value instanceof Character) {
            values.param(((Character)value).charValue());
        } else if (value instanceof Enum) {
            values.param((Enum)value);
        } else if (value instanceof Class) {
            values.param((Class)value);
        }
    }

    private Object parse(String value, String type) {
        Object obj = value;
        if (value != null) {
            if (String.class.getName().equals(type)) {
                obj = value;
            } else if (Boolean.class.getName().equals(type)) {
                obj = Boolean.valueOf(value);
            } else if (Integer.class.getName().equals(type)) {
                obj = Integer.valueOf(value);
            } else if (Long.class.getName().equals(type)) {
                obj = Long.valueOf(value);
            } else if (Short.class.getName().equals(type)) {
                obj = Short.valueOf(value);
            } else if (Double.class.getName().equals(type)) {
                obj = Double.valueOf(value);
            } else if (Float.class.getName().equals(type)) {
                obj = Float.valueOf(value);
            } else if (Byte.class.getName().equals(type)) {
                obj = Byte.valueOf(value);
            } else if (Character.class.getName().equals(type)) {
                obj = Character.valueOf(value.charAt(0));
            } else {
                try {
                    if (Class.class.getName().equals(type)) {
                        obj = Class.forName(value);
                    } else if (Enum.class.getName().equals(type)) {
                        int nameIndex = value.lastIndexOf(46);
                        String className = value.substring(0, nameIndex);
                        String enumName = value.substring(nameIndex + 1);
                        Class<?> enumClass = Class.forName(className);
                        obj = Enum.valueOf(enumClass, enumName);
                    }
                }
                catch (ClassNotFoundException | IllegalArgumentException ex) {
                    String msg = ex.getClass().getSimpleName() + ": " + ex.getMessage();
                    this.getLogger().error(msg + " for " + value, (Throwable)ex);
                    obj = "UNKNOWN";
                }
            }
        }
        return obj;
    }

    private JClass generateExtends(ClassOutline classOutline, Map<String, JClass> knownClasses, Map<JClass, CClassInfo> knownClassInfos) {
        JDefinedClass theClass = classOutline.implClass;
        CPluginCustomization extendsClassCustomization = CustomizationUtils.findCustomization((ClassOutline)classOutline, (QName)Customizations.EXTENDS_ELEMENT_NAME);
        JClass targetClass = this.generateExtends(theClass, extendsClassCustomization, knownClasses);
        CClassInfo classInfo = classOutline.target;
        if (targetClass != null && classInfo.getBaseClass() == null && classInfo.getRefBaseClass() == null) {
            CClassInfo targetClassInfo = knownClassInfos.get(targetClass);
            if (targetClassInfo == null && classInfo.getRefBaseClass() == null) {
                Model model = classInfo.model;
                BIEnum decl = new BIEnum();
                decl.ref = targetClass.fullName();
                CClassRef baseClass = new CClassRef(model, classInfo.getSchemaComponent(), decl, new CCustomizations());
                classInfo.setBaseClass((CClass)baseClass);
            } else if (targetClassInfo != null && classInfo.getBaseClass() == null) {
                classInfo.setBaseClass((CClass)targetClassInfo);
            }
        }
        return targetClass;
    }

    private JClass generateExtends(EnumOutline enumOutline, Map<String, JClass> knownClasses) {
        JDefinedClass theClass = enumOutline.clazz;
        CPluginCustomization extendsClassCustomization = CustomizationUtils.findCustomization((EnumOutline)enumOutline, (QName)Customizations.EXTENDS_ELEMENT_NAME);
        return this.generateExtends(theClass, extendsClassCustomization, knownClasses);
    }

    private JClass generateExtends(ElementOutline elementOutline, Map<String, JClass> knownClasses) {
        JDefinedClass theClass = elementOutline.implClass;
        CPluginCustomization extendsClassCustomization = CustomizationUtils.findCustomization((ElementOutline)elementOutline, (QName)Customizations.EXTENDS_ELEMENT_NAME);
        return this.generateExtends(theClass, extendsClassCustomization, knownClasses);
    }

    private JClass generateExtends(JDefinedClass theClass, CPluginCustomization extendsClassCustomization, Map<String, JClass> knownClasses) throws AssertionError {
        if (extendsClassCustomization != null) {
            ExtendsClass extendsClass = (ExtendsClass)CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)extendsClassCustomization);
            return this.generateExtends(theClass, extendsClass, knownClasses);
        }
        return null;
    }

    private JClass generateExtends(JDefinedClass theClass, ExtendsClass extendsClass, Map<String, JClass> knownClasses) {
        if (extendsClass.getValue() != null) {
            String _class = extendsClass.getValue();
            JClass targetClass = this.parseClass(_class, theClass.owner(), knownClasses);
            theClass._extends(targetClass);
            this.debug("{}, generateExtends; Class={}, Extends={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name(), targetClass.name()});
            return targetClass;
        }
        return null;
    }

    private List<JClass> generateImplements(ClassOutline classOutline, Map<String, JClass> knownClasses) {
        JDefinedClass theClass = classOutline.implClass;
        List implementsInterfaceCustomizations = CustomizationUtils.findCustomizations((ClassOutline)classOutline, (QName)Customizations.IMPLEMENTS_ELEMENT_NAME);
        return this.generateImplements(theClass, implementsInterfaceCustomizations, knownClasses);
    }

    private List<JClass> generateImplements(EnumOutline enumOutline, Map<String, JClass> knownClasses) {
        JDefinedClass theClass = enumOutline.clazz;
        List implementsInterfaceCustomizations = CustomizationUtils.findCustomizations((EnumOutline)enumOutline, (QName)Customizations.IMPLEMENTS_ELEMENT_NAME);
        return this.generateImplements(theClass, implementsInterfaceCustomizations, knownClasses);
    }

    private List<JClass> generateImplements(ElementOutline elementOutline, Map<String, JClass> knownClasses) {
        JDefinedClass theClass = elementOutline.implClass;
        List implementsInterfaceCustomizations = CustomizationUtils.findCustomizations((ElementOutline)elementOutline, (QName)Customizations.IMPLEMENTS_ELEMENT_NAME);
        return this.generateImplements(theClass, implementsInterfaceCustomizations, knownClasses);
    }

    private List<JClass> generateImplements(JDefinedClass theClass, List<CPluginCustomization> implementsInterfaceCustomizations, Map<String, JClass> knownClasses) throws AssertionError {
        ArrayList<JClass> implementedInterfaces = new ArrayList<JClass>(implementsInterfaceCustomizations.size());
        for (CPluginCustomization implementsInterfaceCustomization : implementsInterfaceCustomizations) {
            ImplementsInterface implementsInterface;
            JClass implementedInterface;
            if (implementsInterfaceCustomization == null || (implementedInterface = this.generateImplements(theClass, implementsInterface = (ImplementsInterface)CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)implementsInterfaceCustomization), knownClasses)) == null) continue;
            implementedInterfaces.add(implementedInterface);
        }
        return implementedInterfaces;
    }

    private JClass generateImplements(JDefinedClass theClass, ImplementsInterface implementsInterface, Map<String, JClass> knownClasses) {
        String _interface = implementsInterface.getValue();
        if (_interface != null) {
            JClass targetClass = this.parseClass(_interface, theClass.owner(), knownClasses);
            theClass._implements(targetClass);
            this.debug("{}, generateImplements; Class={}, Implements={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name(), targetClass.name()});
            return targetClass;
        }
        return null;
    }

    private JClass parseClass(String _class, JCodeModel codeModel, Map<String, JClass> knownClasses) {
        return new JavaTypeParser(knownClasses).parseClass(_class, codeModel);
    }
}

