/*
 * Decompiled with CFR 0.152.
 */
package org.parceler;

import org.parceler.ParcelerRuntimeException;

public final class MapsUtil {
    public static final String INITIAL_HASH_MAP_CAPACITY_METHOD = "initialHashMapCapacity";
    private static final int MAX_POWER_OF_TWO = 0x40000000;

    private MapsUtil() {
    }

    static int initialHashMapCapacity(int expectedSize) {
        if (expectedSize < 0) {
            throw new ParcelerRuntimeException("Expected size must be non-negative");
        }
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }
}

