/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.Types;

class FlagMarkingGenerator
implements RuleMethodProcessor {
    FlagMarkingGenerator() {
    }

    @Override
    public boolean appliesTo(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        Preconditions.checkArgNotNull((Object)((Object)parserClassNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)ruleMethod), (String)"method");
        return ruleMethod.hasSuppressNodeAnnotation() || ruleMethod.hasSuppressSubnodesAnnotation() || ruleMethod.hasSkipNodeAnnotation() || ruleMethod.hasMemoMismatchesAnnotation();
    }

    @Override
    public void process(ParserClassNode parserClassNode, RuleMethod ruleMethod) throws Exception {
        Preconditions.checkArgNotNull((Object)((Object)parserClassNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)ruleMethod), (String)"method");
        Preconditions.checkState((!ruleMethod.isSuperMethod() ? 1 : 0) != 0);
        InsnList insnList = ruleMethod.instructions;
        AbstractInsnNode abstractInsnNode = insnList.getLast();
        while (abstractInsnNode.getOpcode() != 176) {
            abstractInsnNode = abstractInsnNode.getPrevious();
        }
        insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new InsnNode(89));
        LabelNode labelNode = new LabelNode();
        insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new JumpInsnNode(198, labelNode));
        if (ruleMethod.hasSuppressNodeAnnotation()) {
            this.generateMarkerCall(insnList, abstractInsnNode, "suppressNode");
        }
        if (ruleMethod.hasSuppressSubnodesAnnotation()) {
            this.generateMarkerCall(insnList, abstractInsnNode, "suppressSubnodes");
        }
        if (ruleMethod.hasSkipNodeAnnotation()) {
            this.generateMarkerCall(insnList, abstractInsnNode, "skipNode");
        }
        if (ruleMethod.hasMemoMismatchesAnnotation()) {
            this.generateMarkerCall(insnList, abstractInsnNode, "memoMismatches");
        }
        insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)labelNode);
    }

    private void generateMarkerCall(InsnList insnList, AbstractInsnNode abstractInsnNode, String string) {
        insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new MethodInsnNode(185, Types.RULE.getInternalName(), string, "()" + Types.RULE.getDescriptor(), true));
    }
}

