/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.test;

import org.parboiled.Node;
import org.parboiled.Rule;
import org.parboiled.common.Predicate;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.parserunners.RecoveringParseRunner;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParseTreeUtils;
import org.parboiled.support.ParsingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParboiledTest<V> {
    public TestResult<V> test(Rule rule, String input) {
        return new TestResult(ReportingParseRunner.run((Rule)rule, (String)input));
    }

    public TestResult<V> testWithRecovery(Rule rule, String input) {
        return new TestResult(RecoveringParseRunner.run((Rule)rule, (String)input));
    }

    protected abstract void fail(String var1);

    protected abstract void assertEquals(Object var1, Object var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestResult<V> {
        public final ParsingResult<V> result;

        public TestResult(ParsingResult<V> result) {
            this.result = result;
        }

        public TestResult<V> hasNoErrors() {
            if (this.result.hasErrors()) {
                ParboiledTest.this.fail("\n--- ParseErrors ---\n" + ErrorUtils.printParseErrors(this.result) + "\n--- ParseTree ---\n" + ParseTreeUtils.printNodeTree(this.result));
            }
            return this;
        }

        public TestResult<V> hasErrors(String expectedErrors) {
            ParboiledTest.this.assertEquals(ErrorUtils.printParseErrors(this.result), expectedErrors);
            return this;
        }

        public TestResult<V> hasParseTree(String expectedTree) {
            ParboiledTest.this.assertEquals(ParseTreeUtils.printNodeTree(this.result), expectedTree);
            return this;
        }

        public TestResult<V> hasParseTree(Predicate<Node<V>> nodeFilter, Predicate<Node<V>> subTreeFilter, String expectedTree) {
            ParboiledTest.this.assertEquals(ParseTreeUtils.printNodeTree(this.result, nodeFilter, subTreeFilter), expectedTree);
            return this;
        }

        public TestResult<V> hasResultValue(V expectedResultValue) {
            ParboiledTest.this.assertEquals(this.result.resultValue, expectedResultValue);
            return this;
        }
    }
}

