/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.connectors.resteasy;

import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.openstack4j.connectors.resteasy.ResteasyClientFactory;
import org.openstack4j.connectors.resteasy.executors.ApacheHttpClientEngine;
import org.openstack4j.core.transport.HttpRequest;
import org.openstack4j.core.transport.functions.EndpointURIFromRequestFunction;

public final class HttpCommand<R> {
    private HttpRequest<R> request;
    private ResteasyWebTarget resteasyWebTarget;
    private int retries;
    private Invocation.Builder resteasyRequest;

    private HttpCommand(HttpRequest<R> request) {
        this.request = request;
    }

    public static <R> HttpCommand<R> create(HttpRequest<R> request) {
        HttpCommand<R> command = new HttpCommand<R>(request);
        super.initialize();
        return command;
    }

    private void initialize() {
        this.resteasyWebTarget = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)ApacheHttpClientEngine.create(this.request.getConfig())).providerFactory((ResteasyProviderFactory)ResteasyClientFactory.getInstance()).build().target(UriBuilder.fromUri((String)new EndpointURIFromRequestFunction().apply(this.request)));
        this.populateQueryParams(this.request);
        this.resteasyRequest = this.resteasyWebTarget.request();
        this.populateHeaders(this.request);
    }

    public Response execute() {
        Invocation webRequest = this.request.getEntity() != null ? this.resteasyRequest.build(this.request.getMethod().name(), Entity.entity((Object)this.request.getEntity(), (String)this.request.getContentType())) : (this.request.hasJson() ? this.resteasyRequest.build(this.request.getMethod().name(), Entity.entity((Object)this.request.getJson(), (String)"application/json")) : this.resteasyRequest.build(this.request.getMethod().name()));
        return webRequest.invoke();
    }

    public boolean hasEntity() {
        return this.request.getEntity() != null;
    }

    public int getRetries() {
        return this.retries;
    }

    public HttpCommand<R> incrementRetriesAndReturn() {
        this.initialize();
        ++this.retries;
        return this;
    }

    public HttpRequest<R> getRequest() {
        return this.request;
    }

    private void populateQueryParams(HttpRequest<R> request) {
        if (!request.hasQueryParams()) {
            return;
        }
        for (Map.Entry entry : request.getQueryParams().entrySet()) {
            for (Object o : (List)entry.getValue()) {
                this.resteasyWebTarget = this.resteasyWebTarget.queryParam((String)entry.getKey(), new Object[]{o});
            }
        }
    }

    private void populateHeaders(HttpRequest<R> request) {
        if (!request.hasHeaders()) {
            return;
        }
        for (Map.Entry h : request.getHeaders().entrySet()) {
            this.resteasyRequest.header((String)h.getKey(), h.getValue());
        }
    }
}

