/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.identity;

import org.openstack4j.api.types.Facing;
import org.openstack4j.api.types.ServiceType;
import org.openstack4j.model.common.resolvers.LatestServiceVersionResolver;
import org.openstack4j.model.common.resolvers.ServiceVersionResolver;
import org.openstack4j.model.common.resolvers.StableServiceVersionResolver;
import org.openstack4j.model.identity.v2.Access;
import org.openstack4j.model.identity.v3.Token;

public class URLResolverParams {
    public Token token;
    public ServiceType type;
    public String region;
    public Facing perspective;
    private ServiceVersionResolver resolver;
    public Access access;

    private URLResolverParams(Token token, ServiceType type) {
        this.token = token;
        this.type = type == null ? ServiceType.IDENTITY : type;
    }

    public static URLResolverParams create(Token token, ServiceType type) {
        return new URLResolverParams(token, type);
    }

    public static URLResolverParams create(Access access, ServiceType type) {
        return new URLResolverParams(access, type);
    }

    private URLResolverParams(Access access, ServiceType type) {
        this.access = access;
        this.type = type == null ? ServiceType.IDENTITY : type;
    }

    public URLResolverParams region(String region) {
        this.region = region;
        return this;
    }

    public URLResolverParams perspective(Facing perspective) {
        this.perspective = perspective;
        return this;
    }

    public URLResolverParams resolver(ServiceVersionResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public ServiceVersionResolver getResolver() {
        return this.resolver != null ? this.resolver : LatestServiceVersionResolver.INSTANCE;
    }

    public ServiceVersionResolver getV2Resolver() {
        return this.resolver != null ? this.resolver : StableServiceVersionResolver.INSTANCE;
    }
}

