/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.security.logging.layout.rich;

import ch.qos.logback.classic.spi.LoggingEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class RichContext {
    private long pid = RichContext.getPID();
    private long clientTime;
    private String applicationName;
    private String inetAddress;

    public RichContext(LoggingEvent event) {
        this.clientTime = event.getTimeStamp();
        this.applicationName = this.getApplicationName();
        this.inetAddress = RichContext.getLocalHostLANAddress();
    }

    public static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getApplicationName() {
        try (InputStream manifestStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");){
            Manifest manifest = new Manifest(manifestStream);
            Attributes attrs = manifest.getMainAttributes();
            String appName = attrs.getValue("Implementation-Title");
            if (appName == null) {
                appName = "UNKNOWN";
            }
            String string = appName;
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getHMAC(String msg) {
        String macKey = System.getProperty("hmac.key", "HMAC KEY");
        char[] checksum = "<unknown HMAC>".toCharArray();
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            byte[] secretByte = macKey.getBytes("UTF-8");
            byte[] dataBytes = msg.getBytes("UTF-8");
            SecretKeySpec secret = new SecretKeySpec(secretByte, "HMACSHA256");
            mac.init(secret);
            byte[] doFinal = mac.doFinal(dataBytes);
            checksum = Hex.encodeHex((byte[])doFinal);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return String.copyValueOf(checksum);
    }

    private static String getLocalHostLANAddress() {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr.toString();
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress.toString();
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress.toString();
        }
        catch (Exception e) {
            return "<unknown ip>";
        }
    }

    public String toString() {
        String message = "[pid=" + this.pid + ", applicationName=" + this.applicationName + ", clientTime=" + this.clientTime + ", clientIp=" + this.inetAddress + "]";
        String signedMessage = message + RichContext.getHMAC(message);
        return signedMessage;
    }
}

