/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.graph.utils;

import java.io.File;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.graph.FileSystemTreeNode;
import org.owasp.jbrofuzz.graph.GraphingPanel;
import org.owasp.jbrofuzz.graph.utils.Walker;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class JohnyWalker
implements Walker {
    private FileSystemTreeNode master;
    private final File directory;
    private final GraphingPanel gPanel;
    private int fileCount;
    private int dirCount;

    public JohnyWalker(GraphingPanel gPanel) {
        boolean saveElsewhere = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.DIRS[1].getId(), true);
        String dirString = saveElsewhere ? JBroFuzz.PREFS.get(JBroFuzzPrefs.DIRS[0].getId(), System.getProperty("user.dir")) : System.getProperty("user.dir");
        this.directory = new File(dirString + File.separator + "jbrofuzz" + File.separator + "fuzz");
        this.gPanel = gPanel;
        if (this.directory.canRead()) {
            this.master = new FileSystemTreeNode(this.directory.getName());
            this.master.setAsDirectory();
        } else {
            this.gPanel.toConsole("Cannot read: " + this.directory.getPath());
        }
        this.fileCount = 0;
        this.dirCount = 0;
    }

    @Override
    public FileSystemTreeNode getFileSystemTreeNode() {
        return this.master;
    }

    @Override
    public int getMaximum() {
        return this.directory.listFiles().length;
    }

    private void listAllFiles(File directory, FileSystemTreeNode parent) {
        File[] children;
        if (!directory.canRead()) {
            this.gPanel.toConsole("Could not read: " + directory.getPath());
            return;
        }
        if (this.gPanel.isStoppedEnabled()) {
            return;
        }
        ++this.dirCount;
        for (File f : children = directory.listFiles()) {
            FileSystemTreeNode node = new FileSystemTreeNode(f.getName());
            if (f.isDirectory()) {
                node.setAsDirectory();
                parent.add(node);
                ++this.dirCount;
                this.listAllFiles(f, node);
                continue;
            }
            if (f.isDirectory()) continue;
            parent.add(node);
            ++this.fileCount;
        }
    }

    @Override
    public void run() {
        this.listAllFiles(this.directory, this.master);
        this.gPanel.toConsole("Total Files: " + this.fileCount);
        this.gPanel.toConsole("Total Directories: " + this.dirCount);
    }
}

