/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.graph;

import java.awt.Component;
import java.io.File;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import org.owasp.jbrofuzz.graph.GraphingPanel;
import org.owasp.jbrofuzz.graph.canvas.HammingDistanceChart;
import org.owasp.jbrofuzz.graph.canvas.JaccardIndexChart;
import org.owasp.jbrofuzz.graph.canvas.ResponseHeaderSizeChart;
import org.owasp.jbrofuzz.graph.canvas.ResponseSizeChart;
import org.owasp.jbrofuzz.graph.canvas.ResponseTimeChart;
import org.owasp.jbrofuzz.graph.canvas.StatusCodeChart;
import org.owasp.jbrofuzz.help.HelpChart;

class TabbedPlotter
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private final GraphingPanel gPanel;
    private StatusCodeChart statusChart;
    private ResponseTimeChart rTimeChart;
    private ResponseSizeChart rSizeChart;
    private JaccardIndexChart jIndexChart;
    private HammingDistanceChart hDistChart;
    private ResponseHeaderSizeChart rHeadChart;

    public TabbedPlotter(GraphingPanel gPanel) {
        super(3);
        this.gPanel = gPanel;
        this.statusChart = new StatusCodeChart();
        this.jIndexChart = new JaccardIndexChart();
        this.rSizeChart = new ResponseSizeChart();
        this.rTimeChart = new ResponseTimeChart();
        this.hDistChart = new HammingDistanceChart();
        this.rHeadChart = new ResponseHeaderSizeChart();
        this.add(" Status Code ", (Component)this.statusChart.getPlotCanvas());
        this.add(" Response Time ", (Component)this.rTimeChart.getPlotCanvas());
        this.add(" Response Size ", (Component)this.rSizeChart.getPlotCanvas());
        this.add(" Jaccard Index ", (Component)this.jIndexChart.getPlotCanvas());
        this.add(" Hamming Distance ", (Component)this.hDistChart.getPlotCanvas());
        this.add(" Response Header ", (Component)this.rHeadChart.getPlotCanvas());
        this.add(" Help ", new HelpChart());
    }

    protected void plot(File directory) {
        this.gPanel.setProgressBarStart();
        final File[] folderFiles = directory.listFiles();
        if (folderFiles == null) {
            return;
        }
        this.statusChart = new StatusCodeChart(folderFiles.length);
        this.rTimeChart = new ResponseTimeChart(folderFiles.length);
        this.rSizeChart = new ResponseSizeChart(folderFiles.length);
        this.jIndexChart = new JaccardIndexChart(folderFiles.length);
        this.hDistChart = new HammingDistanceChart(folderFiles.length);
        this.rHeadChart = new ResponseHeaderSizeChart(folderFiles.length);
        class Grapher
        extends SwingWorker<String, Object> {
            Grapher() {
            }

            @Override
            public String doInBackground() {
                for (int a = 0; a < folderFiles.length; ++a) {
                    TabbedPlotter.this.statusChart.setValueAt(a, folderFiles[a]);
                    TabbedPlotter.this.rTimeChart.setValueAt(a, folderFiles[a]);
                    TabbedPlotter.this.rSizeChart.setValueAt(a, folderFiles[a]);
                    TabbedPlotter.this.jIndexChart.setValueAt(a, folderFiles[a]);
                    TabbedPlotter.this.hDistChart.setValueAt(a, folderFiles[a]);
                    TabbedPlotter.this.rHeadChart.setValueAt(a, folderFiles[a]);
                }
                return "done";
            }

            @Override
            protected void done() {
                TabbedPlotter.this.statusChart.createFinalPlotCanvas();
                TabbedPlotter.this.rTimeChart.createFinalPlotCanvas();
                TabbedPlotter.this.rSizeChart.createFinalPlotCanvas();
                TabbedPlotter.this.jIndexChart.createFinalPlotCanvas();
                TabbedPlotter.this.hDistChart.createFinalPlotCanvas();
                TabbedPlotter.this.rHeadChart.createFinalPlotCanvas();
                TabbedPlotter.this.setComponentAt(0, (Component)TabbedPlotter.this.statusChart.getPlotCanvas());
                TabbedPlotter.this.setComponentAt(1, (Component)TabbedPlotter.this.rTimeChart.getPlotCanvas());
                TabbedPlotter.this.setComponentAt(2, (Component)TabbedPlotter.this.rSizeChart.getPlotCanvas());
                TabbedPlotter.this.setComponentAt(3, (Component)TabbedPlotter.this.jIndexChart.getPlotCanvas());
                TabbedPlotter.this.setComponentAt(4, (Component)TabbedPlotter.this.hDistChart.getPlotCanvas());
                TabbedPlotter.this.setComponentAt(5, (Component)TabbedPlotter.this.rHeadChart.getPlotCanvas());
                TabbedPlotter.this.gPanel.setProgressBarStop();
            }
        }
        new Grapher().execute();
    }
}

