/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.table.TableModel;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.fuzz.ui.FuzzersTableModel;
import org.owasp.jbrofuzz.fuzz.ui.TransformsTableModel;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.util.JBroFuzzFileFilter;
import org.owasp.jbrofuzz.version.JBroFuzzFormat;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class Save {
    private Save() {
    }

    public static File showSaveDialog(JBroFuzzWindow mWindow) {
        JFileChooser fChooser;
        String dirString = JBroFuzz.PREFS.get(JBroFuzzPrefs.DIRS[2].getId(), System.getProperty("user.dir"));
        File dirLocation = new File(dirString);
        try {
            fChooser = dirLocation.exists() && dirLocation.isDirectory() ? new JFileChooser(dirString) : new JFileChooser();
        }
        catch (SecurityException sException) {
            fChooser = new JFileChooser();
            Logger.log("A security exception occured, while attempting to save as to a directory", 4);
        }
        fChooser.setFileFilter(new JBroFuzzFileFilter());
        int retValue = fChooser.showSaveDialog(mWindow);
        if (retValue == 0) {
            int overwrite;
            File returnFile = fChooser.getSelectedFile();
            Logger.log("Saving: " + returnFile.getName(), 1);
            String filePath = returnFile.getAbsolutePath().toLowerCase();
            if (!filePath.endsWith(".jbrofuzz")) {
                returnFile = new File(filePath + ".jbrofuzz");
            }
            if (returnFile.exists() && (overwrite = JOptionPane.showConfirmDialog(fChooser, "File already exists. Do you \nwant to replace it?", " JBroFuzz - Save ", 0)) == 1) {
                return null;
            }
            String parentDir = returnFile.getParent();
            if (parentDir != null) {
                JBroFuzz.PREFS.put(JBroFuzzPrefs.DIRS[2].getId(), parentDir);
            }
            return returnFile;
        }
        return null;
    }

    public static void writeFile(File outputFile, String url, String request, String fuzzers, String transforms) {
        try {
            PrintWriter out = new PrintWriter(outputFile);
            out.println("[JBroFuzz]");
            out.println("2.5");
            out.println("[Fuzzing]");
            out.println(JBroFuzzFormat.DATE);
            out.println("[Comment]");
            out.println("_");
            out.println("[URL]");
            out.println(url);
            out.println("[Request]");
            out.println(request);
            out.println("[Fuzzers]");
            out.println(fuzzers);
            out.println("[Transforms]");
            out.println(transforms);
            out.println("[End]");
            if (out.checkError()) {
                Logger.log("Errors occured while saving", 4);
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            Logger.log("File Could Not Be Found To Save", 4);
        }
        catch (SecurityException e) {
            Logger.log("A Security Exception Occured While Saving", 4);
        }
    }

    public static void writeFile(File outputFile, JBroFuzzWindow mWindow) {
        String url = mWindow.getPanelFuzzing().getTextURL();
        String request = mWindow.getPanelFuzzing().getTextRequest();
        String fuzzers = Save.getTableDataInCSVFormat(mWindow.getPanelFuzzing().getFuzzersPanel().getFuzzersTableModel());
        String transforms = Save.getTableOfTransformsInCSVFormat(mWindow);
        Save.writeFile(outputFile, url, request, fuzzers, transforms);
    }

    public static String getTableDataInCSVFormat(TableModel inputTableModel) {
        StringBuffer output = new StringBuffer();
        int totalRows = inputTableModel.getRowCount();
        int totalColumns = inputTableModel.getColumnCount();
        if (totalRows < 1) {
            return "";
        }
        for (int currentRow = 0; currentRow < totalRows; ++currentRow) {
            for (int currentColumn = 0; currentColumn < totalColumns; ++currentColumn) {
                output.append(inputTableModel.getValueAt(currentRow, currentColumn));
                if (currentColumn == totalColumns - 1) continue;
                output.append(',');
            }
            if (currentRow == totalRows - 1) continue;
            output.append('\n');
        }
        return output.toString();
    }

    public static JSONArray getTableDataInJSON(TableModel inputTableModel) {
        JSONArray tableData = new JSONArray();
        int totalRows = inputTableModel.getRowCount() - 1;
        int totalColumns = inputTableModel.getColumnCount() - 1;
        if (totalRows < 1) {
            return new JSONArray();
        }
        for (int currentRow = 0; currentRow < totalRows; ++currentRow) {
            for (int currentColumn = 0; currentColumn < totalColumns - 1; ++currentColumn) {
                String name = inputTableModel.getColumnName(currentColumn);
                String value = inputTableModel.getValueAt(currentColumn, currentRow).toString();
                String cellString = "{\"" + name + "\":\"" + value + "\"}";
                try {
                    JSONObject cell = new JSONObject(cellString);
                    tableData.put(cell);
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return tableData;
    }

    public static String getTableOfTransformsInCSVFormat(JBroFuzzWindow mWindow) {
        FuzzersTableModel inputTableModel = mWindow.getPanelFuzzing().getFuzzersPanel().getFuzzersTableModel();
        StringBuffer output = new StringBuffer();
        int totalFuzzerRows = inputTableModel.getRowCount();
        if (totalFuzzerRows < 1) {
            return "";
        }
        for (int fuzzerRow = 0; fuzzerRow < totalFuzzerRows; ++fuzzerRow) {
            TransformsTableModel encoderRows = mWindow.getPanelFuzzing().getTransformsPanel().getTransforms(fuzzerRow);
            int totalEncoderRows = encoderRows.getRowCount();
            for (int transformRow = 0; transformRow < totalEncoderRows; ++transformRow) {
                String suffix;
                String prefix;
                output.append(fuzzerRow + 1);
                output.append(',');
                output.append(encoderRows.getRow(transformRow).getEncoder());
                output.append(',');
                try {
                    prefix = Base64.encodeBase64String((byte[])encoderRows.getRow(transformRow).getPrefixOrMatch().getBytes("UTF-8"));
                    prefix = StringUtils.chomp((String)prefix);
                }
                catch (UnsupportedEncodingException e) {
                    prefix = "";
                }
                output.append(prefix);
                output.append(',');
                try {
                    suffix = Base64.encodeBase64String((byte[])encoderRows.getRow(transformRow).getSuffixOrReplace().getBytes("UTF-8"));
                    suffix = StringUtils.chomp((String)suffix);
                }
                catch (UnsupportedEncodingException e) {
                    suffix = "";
                }
                output.append(suffix);
                if (fuzzerRow == totalFuzzerRows - 1 && transformRow == totalEncoderRows - 1) continue;
                output.append('\n');
            }
        }
        return output.toString();
    }
}

