/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.encode;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.owasp.jbrofuzz.encode.EncoderHashCore;
import org.owasp.jbrofuzz.encode.EncoderHashMenuBar;
import org.owasp.jbrofuzz.encode.HashPanel;
import org.owasp.jbrofuzz.encode.HashPanelRightClick;
import org.owasp.jbrofuzz.version.ImageCreator;
import org.owasp.jbrofuzz.version.JBroFuzzFormat;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class EncoderHashFrame
extends JFrame
implements KeyListener {
    private static final long serialVersionUID = 4722716158445936723L;
    private static final int SIZE_X = 650;
    private static final int SIZE_Y = 400;
    private static final Preferences PREFS = Preferences.userRoot().node("owasp/jbrofuzz");
    private JSplitPane horizontalSplitPane;
    private JSplitPane verticalSplitPaneLeft;
    private JSplitPane verticalSplitPaneRight;
    private JSplitPane commentSplitPane;
    private JTextPane enTextPane;
    private JTextPane deTextPane;
    private int listCounter = 0;
    private JTree tree;
    private JButton swap;
    private JButton encode;
    private JButton decode;
    private JButton clear;
    private JButton close;
    private HashPanel commentPanel;
    private JPanel recordingPanel;
    private String[][] recordingPanelData;
    private String[] columnNames;
    private JTable recordingTable;

    public EncoderHashFrame() {
        this.setTitle(" JBroFuzz - Encoder/Hash ");
        this.setJMenuBar(new EncoderHashMenuBar(this));
        this.setIconImage(ImageCreator.IMG_FRAME.getImage());
        this.setLayout(new BorderLayout());
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Codes/Hashes");
        this.setFont(new Font("SansSerif", 0, 12));
        this.tree = new JTree(top);
        this.tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tree.getSelectionModel().setSelectionMode(1);
        JScrollPane leftScrollPane = new JScrollPane(this.tree);
        for (int i = 0; i < EncoderHashCore.CODES.length; ++i) {
            top.add(new DefaultMutableTreeNode(EncoderHashCore.CODES[i]));
        }
        JPanel encoderPanel = new JPanel(new BorderLayout());
        JPanel decoderPanel = new JPanel(new BorderLayout());
        encoderPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Enter the plain text below to be encoded / hashed "), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        decoderPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Enter the text below to be decoded "), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.enTextPane = new JTextPane();
        this.enTextPane.putClientProperty("charset", "UTF-8");
        this.enTextPane.setEditable(true);
        this.enTextPane.setVisible(true);
        this.enTextPane.setFont(new Font("Verdana", 0, 12));
        this.enTextPane.setMargin(new Insets(1, 1, 1, 1));
        this.enTextPane.setBackground(Color.WHITE);
        this.enTextPane.setForeground(new Color(51, 102, 102));
        HashPanelRightClick.popupText(this.enTextPane);
        JScrollPane encodeScrollPane = new JScrollPane(this.enTextPane, 20, 30);
        encoderPanel.add((Component)encodeScrollPane, "Center");
        this.deTextPane = new JTextPane();
        this.deTextPane.putClientProperty("charset", "UTF-8");
        this.deTextPane.setEditable(true);
        this.deTextPane.setVisible(true);
        this.deTextPane.setFont(new Font("Verdana", 0, 12));
        this.deTextPane.setMargin(new Insets(1, 1, 1, 1));
        this.deTextPane.setBackground(Color.WHITE);
        this.deTextPane.setForeground(new Color(204, 51, 0));
        HashPanelRightClick.popupText(this.deTextPane);
        JScrollPane decodeScrollPane = new JScrollPane(this.deTextPane, 20, 30);
        decoderPanel.add((Component)decodeScrollPane, "Center");
        this.commentPanel = new HashPanel("");
        this.recordingPanel = new JPanel(new BorderLayout());
        this.recordingPanelData = this.refreshRecordingPane();
        this.columnNames = new String[]{"Nr", "Encoded", "Decoded", "Codes/Hashes"};
        this.recordingTable = new JTable(this.recordingPanelData, this.columnNames);
        this.recordingTable.setEnabled(true);
        JScrollPane recordingScrollPane = new JScrollPane(this.recordingTable, 20, 30);
        this.recordingPanel.add((Component)recordingScrollPane, "Center");
        this.enTextPane.setForeground(new Color(51, 102, 102));
        this.horizontalSplitPane = new JSplitPane(1);
        this.verticalSplitPaneLeft = new JSplitPane(0);
        this.verticalSplitPaneRight = new JSplitPane(0);
        this.commentSplitPane = new JSplitPane(1);
        this.commentSplitPane.setLeftComponent(this.verticalSplitPaneLeft);
        this.commentSplitPane.setRightComponent(this.verticalSplitPaneRight);
        this.verticalSplitPaneLeft.setTopComponent(encoderPanel);
        this.verticalSplitPaneLeft.setBottomComponent(decoderPanel);
        this.verticalSplitPaneRight.setTopComponent(this.commentPanel);
        this.verticalSplitPaneRight.setBottomComponent(this.recordingPanel);
        this.horizontalSplitPane.setLeftComponent(leftScrollPane);
        this.horizontalSplitPane.setRightComponent(this.commentSplitPane);
        leftScrollPane.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.verticalSplitPaneLeft.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.commentSplitPane.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        encoderPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        decoderPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.commentPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.horizontalSplitPane.setDividerLocation(180);
        this.verticalSplitPaneLeft.setDividerLocation(200);
        this.verticalSplitPaneRight.setDividerLocation(200);
        this.commentSplitPane.setDividerLocation(280);
        TreeNode root = (TreeNode)this.tree.getModel().getRoot();
        this.expandAll(this.tree, new TreePath(root), true);
        this.swap = new JButton(" Swap ");
        this.encode = new JButton(" Encode/Hash ");
        this.decode = new JButton(" Decode ");
        this.clear = new JButton(" Clear ");
        this.close = new JButton(" Close ");
        this.swap.setToolTipText(" Swap the contents of encoded text with the decoded text ");
        String desc = "Select an encoding or hashing scheme from the left hard side";
        this.encode.setToolTipText("Select an encoding or hashing scheme from the left hard side");
        this.decode.setToolTipText("Select an encoding or hashing scheme from the left hard side");
        this.clear.setToolTipText(" Clear content");
        this.close.setToolTipText(" Close this window ");
        this.recordingTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                EncoderHashFrame.this.listCounter = EncoderHashFrame.this.recordingTable.getSelectedRow();
                String clear = (String)EncoderHashFrame.this.recordingTable.getValueAt(EncoderHashFrame.this.recordingTable.getSelectedRow(), 1);
                String enc = (String)EncoderHashFrame.this.recordingTable.getValueAt(EncoderHashFrame.this.recordingTable.getSelectedRow(), 2);
                EncoderHashFrame.this.enTextPane.setText(clear);
                EncoderHashFrame.this.deTextPane.setText(enc);
            }
        });
        this.swap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EncoderHashFrame.this.swapTexts();
                    }
                });
            }
        });
        this.encode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EncoderHashFrame.this.calculate(true);
                        EncoderHashFrame.this.saveValues();
                    }
                });
            }
        });
        this.decode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EncoderHashFrame.this.calculate(false);
                        EncoderHashFrame.this.saveValues();
                    }
                });
            }
        });
        this.clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int numRows = EncoderHashFrame.this.recordingTable.getRowCount();
                int numCols = EncoderHashFrame.this.recordingTable.getColumnCount();
                for (int i = 0; i < numRows; ++i) {
                    for (int j = 0; j < numCols; ++j) {
                        EncoderHashFrame.this.recordingTable.setValueAt("", i, j);
                    }
                    PREFS.remove(JBroFuzzPrefs.ENCODER[0] + "." + i);
                    PREFS.remove(JBroFuzzPrefs.ENCODER[1] + "." + i);
                    PREFS.remove(JBroFuzzPrefs.ENCODER[2] + "." + i);
                    try {
                        PREFS.sync();
                        continue;
                    }
                    catch (BackingStoreException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EncoderHashFrame.this.saveValues();
                        EncoderHashFrame.this.dispose();
                    }
                });
            }
        });
        this.tree.addKeyListener(this);
        this.deTextPane.addKeyListener(this);
        this.enTextPane.addKeyListener(this);
        this.recordingTable.addKeyListener(this);
        this.encode.addKeyListener(this);
        this.decode.addKeyListener(this);
        this.clear.addKeyListener(this);
        this.close.addKeyListener(this);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)EncoderHashFrame.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                String coderName = node.toString();
                EncoderHashFrame.this.decode.setEnabled(EncoderHashCore.isDecoded(coderName));
                EncoderHashFrame.this.commentPanel.setText(EncoderHashCore.getComment(coderName));
            }
        });
        AbstractAction doEncode = new AbstractAction(){
            private static final long serialVersionUID = -7686474340015136816L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EncoderHashFrame.this.calculate(true);
            }
        };
        this.enTextPane.getInputMap(2).put(KeyStroke.getKeyStroke(10, 8), "doEncode");
        this.enTextPane.getActionMap().put("doEncode", doEncode);
        AbstractAction doDecode = new AbstractAction(){
            private static final long serialVersionUID = 3083350774016663021L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EncoderHashFrame.this.calculate(false);
            }
        };
        this.enTextPane.getInputMap(2).put(KeyStroke.getKeyStroke(8, 8), "doDecode");
        this.enTextPane.getActionMap().put("doDecode", doDecode);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 15, 15));
        buttonPanel.add(this.swap);
        buttonPanel.add(this.encode);
        buttonPanel.add(this.decode);
        buttonPanel.add(this.clear);
        buttonPanel.add(this.close);
        this.getContentPane().add((Component)this.horizontalSplitPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setLocation(111, 111);
        this.setSize(650, 400);
        this.setMinimumSize(new Dimension(325, 200));
        this.setResizable(true);
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EncoderHashFrame.this.closeFrame();
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent kEvent) {
    }

    @Override
    public void keyPressed(KeyEvent kEvent) {
        if (kEvent.getKeyCode() == 27) {
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent kEvent) {
    }

    public void closeFrame() {
        this.saveValues();
        this.dispose();
    }

    private void calculate(boolean isToEncode) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        String s = node.toString();
        if (isToEncode) {
            String encodeText = this.enTextPane.getText();
            this.deTextPane.setText(EncoderHashCore.encode(encodeText, s));
        } else {
            String decodeText = this.deTextPane.getText();
            this.enTextPane.setText(EncoderHashCore.decode(decodeText, s));
        }
    }

    private String[][] refreshRecordingPane() {
        String[][] returnObject = new String[50][4];
        int loose = 0;
        for (int i = 0; i < 50; ++i) {
            String encValue = PREFS.get(JBroFuzzPrefs.ENCODER[0] + "." + i, "");
            String decValue = PREFS.get(JBroFuzzPrefs.ENCODER[1] + "." + i, "");
            String engineValue = PREFS.get(JBroFuzzPrefs.ENCODER[2] + "." + i, "");
            if (encValue.length() > 0) {
                returnObject[i][0] = String.valueOf(i);
                returnObject[i][1] = encValue;
                returnObject[i][2] = decValue;
                returnObject[i][3] = engineValue;
                continue;
            }
            ++loose;
            returnObject[i][0] = String.valueOf(i);
            returnObject[i][1] = "";
            returnObject[i][2] = "";
            returnObject[i][3] = "";
        }
        return returnObject;
    }

    private void saveValues() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        PREFS.put(JBroFuzzPrefs.ENCODER[0] + "." + this.listCounter, this.enTextPane.getText());
        PREFS.put(JBroFuzzPrefs.ENCODER[1] + "." + this.listCounter, this.deTextPane.getText());
        if (node != null) {
            PREFS.put(JBroFuzzPrefs.ENCODER[2] + "." + this.listCounter, node.toString());
        }
        try {
            PREFS.sync();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        if (this.listCounter >= 50) {
            this.listCounter -= 50;
        }
        this.recordingTable.setValueAt(this.enTextPane.getText(), this.listCounter, 1);
        this.recordingTable.setValueAt(this.deTextPane.getText(), this.listCounter, 2);
        if (node != null) {
            this.recordingTable.setValueAt(node.toString(), this.listCounter, 3);
        } else {
            this.recordingTable.setValueAt("", this.listCounter, 3);
        }
        this.recordingTable.getSelectionModel().setSelectionInterval(this.listCounter, this.listCounter);
    }

    private void swapTexts() {
        String enText = this.enTextPane.getText();
        String deText = this.deTextPane.getText();
        this.enTextPane.setText(deText);
        this.deTextPane.setText(enText);
    }

    public void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }
}

