/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.core;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.owasp.jbrofuzz.core.CrossProductFuzzer;
import org.owasp.jbrofuzz.core.DoubleFuzzer;
import org.owasp.jbrofuzz.core.Fuzzer;
import org.owasp.jbrofuzz.core.FuzzerBigInteger;
import org.owasp.jbrofuzz.core.NoSuchFuzzerException;
import org.owasp.jbrofuzz.core.PowerFuzzer;
import org.owasp.jbrofuzz.core.Prototype;
import org.owasp.jbrofuzz.core.Verifier;
import org.owasp.jbrofuzz.system.Logger;

public class Database {
    private final Map<String, Prototype> prototypes;
    private static final String ZERO_FUZZER_CATEGORY = "Zero Fuzzers";

    public Database() {
        this.prototypes = Verifier.loadFile("fuzzers.jbrf");
        this.addZeroFuzzers();
        Logger.log("Database loaded with " + this.prototypes.size() + " fuzzers", 0);
    }

    public Database(String fuzzersFilePath) {
        this.prototypes = Verifier.loadAnyFile(fuzzersFilePath);
        this.addZeroFuzzers();
        Logger.log("Database loaded with " + this.prototypes.size() + " fuzzers", 0);
    }

    private void addZeroFuzzers() {
        Logger.log("Adding 5 Zero Fuzzers to the fuzzing Database", 0);
        Prototype pt0 = new Prototype('Z', "000-ZER-10K", "10000 Plain Requests");
        Prototype pt1 = new Prototype('Z', "000-ZER-1KI", "1000 Plain Requests");
        Prototype pt2 = new Prototype('Z', "000-ZER-100", "100 Plain Requests");
        Prototype pt3 = new Prototype('Z', "000-ZER-TEN", "10 Plain Requests");
        Prototype pt4 = new Prototype('Z', "000-ZER-ONE", "1 Plain Request");
        pt0.addCategory(ZERO_FUZZER_CATEGORY);
        pt1.addCategory(ZERO_FUZZER_CATEGORY);
        pt2.addCategory(ZERO_FUZZER_CATEGORY);
        pt3.addCategory(ZERO_FUZZER_CATEGORY);
        pt4.addCategory(ZERO_FUZZER_CATEGORY);
        for (int i = 0; i < 10000; ++i) {
            pt0.addPayload("");
            if (i < 1000) {
                pt1.addPayload("");
            }
            if (i < 100) {
                pt2.addPayload("");
            }
            if (i < 10) {
                pt3.addPayload("");
            }
            if (i >= 1) continue;
            pt4.addPayload("");
        }
        this.prototypes.put("000-ZER-10K", pt0);
        this.prototypes.put("000-ZER-1KI", pt1);
        this.prototypes.put("000-ZER-100", pt2);
        this.prototypes.put("000-ZER-TEN", pt3);
        this.prototypes.put("000-ZER-ONE", pt4);
    }

    public boolean containsPrototype(String prototypeId) {
        return this.prototypes.containsKey(prototypeId);
    }

    public Fuzzer createFuzzer(String prototypeId, int len) throws NoSuchFuzzerException {
        if (!this.containsPrototype(prototypeId)) {
            throw new NoSuchFuzzerException(StringUtils.abbreviate((String)prototypeId, (int)10) + " : No Such Fuzzer Found in the Database ");
        }
        return new Fuzzer(this.getPrototype(prototypeId), len);
    }

    public PowerFuzzer createPowerFuzzer(String prototypeId, int len, int power) throws NoSuchFuzzerException {
        if (!this.containsPrototype(prototypeId)) {
            throw new NoSuchFuzzerException(StringUtils.abbreviate((String)prototypeId, (int)10) + "No Such Fuzzer Found in the Database ");
        }
        return new PowerFuzzer(this.getPrototype(prototypeId), len, power);
    }

    public DoubleFuzzer createDoubleFuzzer(String id1, int length1, String id2, int length2) throws NoSuchFuzzerException {
        if (this.containsPrototype(id1) && this.containsPrototype(id2)) {
            return new DoubleFuzzer(this.getPrototype(id1), length1, this.getPrototype(id2), length2);
        }
        throw new NoSuchFuzzerException(StringUtils.abbreviate((String)id1, (int)10) + " or " + StringUtils.abbreviate((String)id2, (int)10) + " Not Found in the Database ");
    }

    public CrossProductFuzzer createCrossFuzzer(String id1, int length1, String id2, int length2) throws NoSuchFuzzerException {
        if (this.containsPrototype(id1) && this.containsPrototype(id2)) {
            return new CrossProductFuzzer(this.getPrototype(id1), length1, this.getPrototype(id2), length2);
        }
        throw new NoSuchFuzzerException(StringUtils.abbreviate((String)id1, (int)10) + " or " + StringUtils.abbreviate((String)id2, (int)10) + " Not Found in the Database ");
    }

    public FuzzerBigInteger createFuzzerBigInteger(String prototypeId, int len) throws NoSuchFuzzerException {
        if (!this.containsPrototype(prototypeId)) {
            throw new NoSuchFuzzerException(StringUtils.abbreviate((String)prototypeId, (int)10) + " : No Such Fuzzer Found in the Database ");
        }
        return new FuzzerBigInteger(this.getPrototype(prototypeId), len);
    }

    public String[] getAllCategories() {
        String[] ids;
        HashSet<String> o = new HashSet<String>();
        for (String id : ids = this.getAllPrototypeIDs()) {
            List<String> catArrayList = this.prototypes.get(id).getCategories();
            String[] categoriesArray = new String[catArrayList.size()];
            catArrayList.toArray(categoriesArray);
            for (String cCategory : categoriesArray) {
                o.add(cCategory);
            }
        }
        String[] uCategoriesArray = new String[o.size()];
        o.toArray(uCategoriesArray);
        return uCategoriesArray;
    }

    public String[] getAllPrototypeIDs() {
        Set<String> set = this.prototypes.keySet();
        String[] output = new String[set.size()];
        return set.toArray(output);
    }

    public String[] getAllFuzzerIDs() {
        return this.getAllPrototypeIDs();
    }

    public String[] getAllPrototypeNames() {
        StringBuffer output = new StringBuffer();
        Set<String> set = this.prototypes.keySet();
        String[] input = new String[set.size()];
        set.toArray(input);
        for (String key : input) {
            output.append(this.prototypes.get(key).getName());
            output.append('\n');
        }
        return output.toString().split("\n");
    }

    public String getIdFromName(String name) {
        String[] ids;
        for (String id : ids = this.getAllPrototypeIDs()) {
            Prototype cPrototype = this.prototypes.get(id);
            if (!name.equalsIgnoreCase(cPrototype.getName())) continue;
            return id;
        }
        return "";
    }

    public String getName(String uniqId) {
        return this.prototypes.get(uniqId).getName();
    }

    public String[] getPayloads(String uniqId) {
        if (this.containsPrototype(uniqId)) {
            Prototype cPrototype = this.prototypes.get(uniqId);
            String[] output = new String[cPrototype.size()];
            return cPrototype.getPayloads().toArray(output);
        }
        return new String[0];
    }

    public Prototype getPrototype(String prototypeId) {
        return this.prototypes.get(prototypeId);
    }

    public String[] getPrototypeNamesInCategory(String category) {
        String[] ids;
        HashSet<String> o = new HashSet<String>();
        for (String id : ids = this.getAllPrototypeIDs()) {
            Prototype g = this.prototypes.get(id);
            if (!g.isAMemberOfCategory(category)) continue;
            o.add(g.getName());
        }
        String[] uCategotiesArray = new String[o.size()];
        o.toArray(uCategotiesArray);
        return uCategotiesArray;
    }

    public int getSize(String fuzzerId) {
        int returnSize = 0;
        if (this.containsPrototype(fuzzerId)) {
            Prototype g = this.prototypes.get(fuzzerId);
            returnSize = g.size();
        }
        return returnSize;
    }

    public int size() {
        return this.prototypes.size();
    }

    public String getTypeFromName(String name) {
        return this.prototypes.get(this.getIdFromName(name)).getType();
    }

    public String getType(String fuzzerId) {
        return this.prototypes.get(fuzzerId).getType();
    }
}

