/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Checksum {
    private static final String HEXES = "0123456789abcdef";
    private static final Logger LOGGER = LoggerFactory.getLogger(Checksum.class);
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA1";
    private static final String SHA256 = "SHA-256";
    private static final Map<String, Map<File, String>> CHECKSUM_CACHES = new HashMap<String, Map<File, String>>(3);

    private Checksum() {
    }

    public static String getChecksum(String algorithm, File file) throws NoSuchAlgorithmException, IOException {
        Map<File, String> checksumCache = CHECKSUM_CACHES.get(algorithm.toUpperCase());
        if (checksumCache == null) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        String checksum = checksumCache.get(file);
        try (FileInputStream stream = new FileInputStream(file);){
            if (checksum == null) {
                switch (algorithm.toUpperCase()) {
                    case "MD5": {
                        checksum = DigestUtils.md5Hex((InputStream)stream);
                        break;
                    }
                    case "SHA1": {
                        checksum = DigestUtils.sha1Hex((InputStream)stream);
                        break;
                    }
                    case "SHA-256": {
                        checksum = DigestUtils.sha256Hex((InputStream)stream);
                        break;
                    }
                    default: {
                        throw new NoSuchAlgorithmException(algorithm);
                    }
                }
                checksumCache.put(file, checksum);
            }
        }
        return checksum;
    }

    public static String getMD5Checksum(File file) throws IOException, NoSuchAlgorithmException {
        return Checksum.getChecksum(MD5, file);
    }

    public static String getSHA1Checksum(File file) throws IOException, NoSuchAlgorithmException {
        return Checksum.getChecksum(SHA1, file);
    }

    public static String getSHA256Checksum(File file) throws IOException, NoSuchAlgorithmException {
        return Checksum.getChecksum(SHA256, file);
    }

    public static String getChecksum(String algorithm, byte[] bytes) {
        switch (algorithm.toUpperCase()) {
            case "MD5": {
                return DigestUtils.md5Hex((byte[])bytes);
            }
            case "SHA1": {
                return DigestUtils.sha1Hex((byte[])bytes);
            }
            case "SHA-256": {
                return DigestUtils.sha256Hex((byte[])bytes);
            }
        }
        return null;
    }

    public static String getMD5Checksum(String text) {
        return DigestUtils.md5Hex((String)text);
    }

    public static String getSHA1Checksum(String text) {
        return DigestUtils.sha1Hex((String)text);
    }

    public static String getSHA256Checksum(String text) {
        return DigestUtils.sha256Hex((String)text);
    }

    private static byte[] stringToBytes(String text) {
        byte[] data;
        try {
            data = text.getBytes(Charset.forName(StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedCharsetException ex) {
            data = text.getBytes(Charset.defaultCharset());
        }
        return data;
    }

    public static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    private static MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            String msg = String.format("Failed to obtain the %s message digest.", algorithm);
            throw new IllegalStateException(msg, e);
        }
    }

    static {
        CHECKSUM_CACHES.put(MD5, new ConcurrentHashMap());
        CHECKSUM_CACHES.put(SHA256, new ConcurrentHashMap());
        CHECKSUM_CACHES.put(SHA1, new ConcurrentHashMap());
    }
}

