/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.HttpResourceConnection;
import org.owasp.dependencycheck.utils.Settings;

public final class Downloader {
    private final Settings settings;

    public Downloader(Settings settings) {
        this.settings = settings;
    }

    public void fetchFile(URL url, File outputPath) throws DownloadFailedException {
        this.fetchFile(url, outputPath, true);
    }

    public void fetchFile(URL url, File outputPath, boolean useProxy) throws DownloadFailedException {
        try (HttpResourceConnection conn = new HttpResourceConnection(this.settings, useProxy);
             FileOutputStream out = new FileOutputStream(outputPath);){
            InputStream in = conn.fetch(url);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException ex) {
            String msg = String.format("Download failed, unable to copy '%s' to '%s'", url.toString(), outputPath.getAbsolutePath());
            throw new DownloadFailedException(msg, ex);
        }
    }
}

