/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);
    private static final String BIT_BUCKET_UNIX = "/dev/null";
    private static final String BIT_BUCKET_WIN = "NUL";

    private FileUtils() {
    }

    public static String getFileExtension(String fileName) {
        String fileExt = FilenameUtils.getExtension((String)fileName);
        return null == fileExt || fileExt.isEmpty() ? null : fileExt.toLowerCase();
    }

    public static boolean delete(File file) {
        boolean success = org.apache.commons.io.FileUtils.deleteQuietly((File)file);
        if (!success) {
            LOGGER.debug("Failed to delete file: {}; attempting to delete on exit.", (Object)file.getPath());
            file.deleteOnExit();
        }
        return success;
    }

    public static File createTempDirectory(File base) throws IOException {
        File tempDir = new File(base, "dctemp" + UUID.randomUUID().toString());
        if (tempDir.exists()) {
            return FileUtils.createTempDirectory(base);
        }
        if (!tempDir.mkdirs()) {
            throw new IOException("Could not create temp directory `" + tempDir.getAbsolutePath() + "`");
        }
        return tempDir;
    }

    public static File getTempFile(String prefix, String extension) throws IOException {
        File dir = Settings.getTempDirectory();
        String tempFileName = String.format("%s%s.%s", prefix, UUID.randomUUID().toString(), extension);
        File tempFile = new File(dir, tempFileName);
        if (tempFile.exists()) {
            return FileUtils.getTempFile(prefix, extension);
        }
        return tempFile;
    }

    public static String getBitBucket() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return BIT_BUCKET_WIN;
        }
        return BIT_BUCKET_UNIX;
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                LOGGER.trace("", (Throwable)ex);
            }
        }
    }
}

