/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.utils.SSLSocketFactoryEx;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URLConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLConnectionFactory.class);

    private URLConnectionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"}, justification="Just being extra safe")
    public static HttpURLConnection createHttpURLConnection(URL url) throws URLConnectionFailureException {
        HttpURLConnection conn = null;
        String proxyUrl = Settings.getString("proxy.server");
        try {
            if (proxyUrl != null && !URLConnectionFactory.matchNonProxy(url)) {
                int proxyPort = Settings.getInt("proxy.port");
                InetSocketAddress address = new InetSocketAddress(proxyUrl, proxyPort);
                final String username = Settings.getString("proxy.username");
                final String password = Settings.getString("proxy.password");
                if (username != null && password != null) {
                    Authenticator auth = new Authenticator(){

                        @Override
                        public PasswordAuthentication getPasswordAuthentication() {
                            if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                                return new PasswordAuthentication(username, password.toCharArray());
                            }
                            return super.getPasswordAuthentication();
                        }
                    };
                    Authenticator.setDefault(auth);
                }
                Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                conn = (HttpURLConnection)url.openConnection(proxy);
            } else {
                conn = (HttpURLConnection)url.openConnection();
            }
            int timeout = Settings.getInt("connection.timeout", 10000);
            conn.setConnectTimeout(timeout);
            conn.setInstanceFollowRedirects(true);
        }
        catch (IOException ex) {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                finally {
                    conn = null;
                }
            }
            throw new URLConnectionFailureException("Error getting connection.", ex);
        }
        URLConnectionFactory.configureTLS(url, conn);
        return conn;
    }

    private static boolean matchNonProxy(URL url) {
        String host = url.getHost();
        String nonProxyHosts = Settings.getString("proxy.nonproxyhosts");
        if (null != nonProxyHosts) {
            String[] nonProxies;
            for (String nonProxyHost : nonProxies = nonProxyHosts.split("(,)|(;)|(\\|)")) {
                if (null != nonProxyHost && nonProxyHost.contains("*")) {
                    int pos = nonProxyHost.indexOf(42);
                    String nonProxyHostPrefix = nonProxyHost.substring(0, pos);
                    String nonProxyHostSuffix = nonProxyHost.substring(pos + 1);
                    if (!StringUtils.isEmpty((CharSequence)nonProxyHostPrefix) && host.startsWith(nonProxyHostPrefix) && StringUtils.isEmpty((CharSequence)nonProxyHostSuffix)) {
                        return true;
                    }
                    if (StringUtils.isEmpty((CharSequence)nonProxyHostPrefix) && !StringUtils.isEmpty((CharSequence)nonProxyHostSuffix) && host.endsWith(nonProxyHostSuffix)) {
                        return true;
                    }
                    if (StringUtils.isEmpty((CharSequence)nonProxyHostPrefix) || !host.startsWith(nonProxyHostPrefix) || StringUtils.isEmpty((CharSequence)nonProxyHostSuffix) || !host.endsWith(nonProxyHostSuffix)) continue;
                    return true;
                }
                if (!host.equals(nonProxyHost)) continue;
                return true;
            }
        }
        return false;
    }

    public static HttpURLConnection createHttpURLConnection(URL url, boolean proxy) throws URLConnectionFailureException {
        if (proxy) {
            return URLConnectionFactory.createHttpURLConnection(url);
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            int timeout = Settings.getInt("connection.timeout", 10000);
            conn.setConnectTimeout(timeout);
            conn.setInstanceFollowRedirects(true);
        }
        catch (IOException ioe) {
            throw new URLConnectionFailureException("Error getting connection.", ioe);
        }
        URLConnectionFactory.configureTLS(url, conn);
        return conn;
    }

    private static void configureTLS(URL url, URLConnection conn) {
        if ("https".equals(url.getProtocol())) {
            try {
                HttpsURLConnection secCon = (HttpsURLConnection)conn;
                SSLSocketFactoryEx factory = new SSLSocketFactoryEx();
                secCon.setSSLSocketFactory(factory);
            }
            catch (NoSuchAlgorithmException ex) {
                LOGGER.debug("Unsupported algorithm in SSLSocketFactoryEx", (Throwable)ex);
            }
            catch (KeyManagementException ex) {
                LOGGER.debug("Key mnagement eception in SSLSocketFactoryEx", (Throwable)ex);
            }
        }
    }
}

