/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLSocketFactoryEx
extends SSLSocketFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLSocketFactoryEx.class);
    private SSLContext sslCtxt;
    private String[] ciphers;
    private String[] protocols;

    public SSLSocketFactoryEx() throws NoSuchAlgorithmException, KeyManagementException {
        this.initSSLSocketFactoryEx(null, null, null);
    }

    public SSLSocketFactoryEx(KeyManager[] km, TrustManager[] tm, SecureRandom random) throws NoSuchAlgorithmException, KeyManagementException {
        this.initSSLSocketFactoryEx(km, tm, random);
    }

    public SSLSocketFactoryEx(SSLContext ctx) throws NoSuchAlgorithmException, KeyManagementException {
        this.initSSLSocketFactoryEx(ctx);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return Arrays.copyOf(this.ciphers, this.ciphers.length);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return Arrays.copyOf(this.ciphers, this.ciphers.length);
    }

    public String[] getDefaultProtocols() {
        return Arrays.copyOf(this.protocols, this.protocols.length);
    }

    public String[] getSupportedProtocols() {
        return Arrays.copyOf(this.protocols, this.protocols.length);
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(s, host, port, autoClose);
        ss.setEnabledProtocols(this.protocols);
        ss.setEnabledCipherSuites(this.ciphers);
        return ss;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(address, port, localAddress, localPort);
        ss.setEnabledProtocols(this.protocols);
        ss.setEnabledCipherSuites(this.ciphers);
        return ss;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port, localHost, localPort);
        ss.setEnabledProtocols(this.protocols);
        ss.setEnabledCipherSuites(this.ciphers);
        return ss;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port);
        ss.setEnabledProtocols(this.protocols);
        ss.setEnabledCipherSuites(this.ciphers);
        return ss;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port);
        ss.setEnabledProtocols(this.protocols);
        ss.setEnabledCipherSuites(this.ciphers);
        return ss;
    }

    private void initSSLSocketFactoryEx(KeyManager[] km, TrustManager[] tm, SecureRandom random) throws NoSuchAlgorithmException, KeyManagementException {
        this.sslCtxt = SSLContext.getInstance("TLS");
        this.sslCtxt.init(km, tm, random);
        this.protocols = this.getProtocolList();
        this.ciphers = this.getCipherList();
    }

    private void initSSLSocketFactoryEx(SSLContext ctx) throws NoSuchAlgorithmException, KeyManagementException {
        this.sslCtxt = ctx;
        this.protocols = this.getProtocolList();
        this.ciphers = this.getCipherList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getProtocolList() {
        String[] preferredProtocols = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};
        Object[] availableProtocols = null;
        Socket socket = null;
        try {
            SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
            socket = (SSLSocket)factory.createSocket();
            availableProtocols = ((SSLSocket)socket).getSupportedProtocols();
            Arrays.sort(availableProtocols);
        }
        catch (Exception ex) {
            LOGGER.debug("Error getting protocol list, using TLSv1", (Throwable)ex);
            String[] stringArray = new String[]{"TLSv1"};
            return stringArray;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("Error closing socket", (Throwable)ex);
                }
            }
        }
        ArrayList<String> aa = new ArrayList<String>();
        for (String preferredProtocol : preferredProtocols) {
            int idx = Arrays.binarySearch(availableProtocols, preferredProtocol);
            if (idx < 0) continue;
            aa.add(preferredProtocol);
        }
        return aa.toArray(new String[0]);
    }

    protected String[] getCipherList() {
        Object[] availableCiphers;
        String[] preferredCiphers = new String[]{"TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305", "TLS_ECDHE_ECDSA_WITH_CHACHA20_SHA", "TLS_ECDHE_RSA_WITH_CHACHA20_SHA", "TLS_DHE_RSA_WITH_CHACHA20_POLY1305", "TLS_RSA_WITH_CHACHA20_POLY1305", "TLS_DHE_RSA_WITH_CHACHA20_SHA", "TLS_RSA_WITH_CHACHA20_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA"};
        try {
            SSLSocketFactory factory = this.sslCtxt.getSocketFactory();
            availableCiphers = factory.getSupportedCipherSuites();
            Arrays.sort(availableCiphers);
        }
        catch (Exception e) {
            LOGGER.debug("Error retrieving ciphers", (Throwable)e);
            return new String[]{"TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_EMPTY_RENEGOTIATION_INFO_SCSV"};
        }
        ArrayList<String> aa = new ArrayList<String>();
        for (String preferredCipher : preferredCiphers) {
            int idx = Arrays.binarySearch(availableCiphers, preferredCipher);
            if (idx < 0) continue;
            aa.add(preferredCipher);
        }
        aa.add("TLS_EMPTY_RENEGOTIATION_INFO_SCSV");
        return aa.toArray(new String[0]);
    }
}

