/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Properties;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Settings {
    private static final Logger LOGGER = LoggerFactory.getLogger(Settings.class);
    private static final String PROPERTIES_FILE = "dependencycheck.properties";
    private static ThreadLocal<Settings> localSettings = new ThreadLocal();
    private Properties props = null;
    private static File tempDirectory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Settings(String propertiesFilePath) {
        InputStream in = null;
        this.props = new Properties();
        try {
            in = this.getClass().getClassLoader().getResourceAsStream(propertiesFilePath);
            this.props.load(in);
        }
        catch (IOException ex) {
            LOGGER.error("Unable to load default settings.");
            LOGGER.debug("", (Throwable)ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("", (Throwable)ex);
                }
            }
        }
        Settings.logProperties("Properties loaded", this.props);
    }

    public static void initialize() {
        localSettings.set(new Settings(PROPERTIES_FILE));
    }

    public static void initialize(String propertiesFilePath) {
        localSettings.set(new Settings(propertiesFilePath));
    }

    public static void cleanup() {
        Settings.cleanup(true);
    }

    public static void cleanup(boolean deleteTemporary) {
        if (deleteTemporary && tempDirectory != null && tempDirectory.exists()) {
            FileUtils.delete(tempDirectory);
            if (tempDirectory.exists()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.trace("ignore", (Throwable)ex);
                }
                FileUtils.delete(tempDirectory);
            }
        }
        try {
            localSettings.remove();
        }
        catch (Throwable ex) {
            LOGGER.debug("Error cleaning up Settings", ex);
        }
    }

    public static Settings getInstance() {
        return localSettings.get();
    }

    public static void setInstance(Settings instance) {
        localSettings.set(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logProperties(String header, Properties properties) {
        if (LOGGER.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(sw);
                pw.format("%s:%n%n", header);
                Enumeration<?> e = properties.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (key.contains("password")) {
                        pw.format("%s='*****'%n", key);
                        continue;
                    }
                    String value = properties.getProperty(key);
                    if (value == null) continue;
                    pw.format("%s='%s'%n", key, value);
                }
                pw.flush();
                LOGGER.debug(sw.toString());
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }

    public static void setString(String key, String value) {
        Settings.localSettings.get().props.setProperty(key, value);
        LOGGER.debug("Setting: {}='{}'", (Object)key, (Object)value);
    }

    public static void setStringIfNotNull(String key, String value) {
        if (null != value) {
            Settings.setString(key, value);
        }
    }

    public static void setStringIfNotEmpty(String key, String value) {
        if (null != value && !value.isEmpty()) {
            Settings.setString(key, value);
        }
    }

    public static void setBoolean(String key, boolean value) {
        Settings.setString(key, Boolean.toString(value));
    }

    public static void setBooleanIfNotNull(String key, Boolean value) {
        if (null != value) {
            Settings.setBoolean(key, value);
        }
    }

    public static void setInt(String key, int value) {
        Settings.localSettings.get().props.setProperty(key, String.valueOf(value));
        LOGGER.debug("Setting: {}='{}'", (Object)key, (Object)value);
    }

    public static void setIntIfNotNull(String key, Integer value) {
        if (null != value) {
            Settings.setInt(key, value);
        }
    }

    public static void mergeProperties(File filePath) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            Settings.mergeProperties(fis);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("close error", (Throwable)ex);
                }
            }
        }
    }

    public static void mergeProperties(String filePath) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            Settings.mergeProperties(fis);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("close error", (Throwable)ex);
                }
            }
        }
    }

    public static void mergeProperties(InputStream stream) throws IOException {
        Settings.localSettings.get().props.load(stream);
        Settings.logProperties("Properties updated via merge", Settings.localSettings.get().props);
    }

    public static File getFile(String key) {
        String file = Settings.getString(key);
        if (file == null) {
            return null;
        }
        return new File(file);
    }

    protected static File getDataFile(String key) {
        String file = Settings.getString(key);
        LOGGER.debug("Settings.getDataFile() - file: '{}'", (Object)file);
        if (file == null) {
            return null;
        }
        if (file.startsWith("[JAR]")) {
            LOGGER.debug("Settings.getDataFile() - transforming filename");
            File jarPath = Settings.getJarPath();
            LOGGER.debug("Settings.getDataFile() - jar file: '{}'", (Object)jarPath.toString());
            File retVal = new File(jarPath, file.substring(6));
            LOGGER.debug("Settings.getDataFile() - returning: '{}'", (Object)retVal.toString());
            return retVal;
        }
        return new File(file);
    }

    private static File getJarPath() {
        String jarPath = Settings.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = ".";
        try {
            decodedPath = URLDecoder.decode(jarPath, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.trace("", (Throwable)ex);
        }
        File path = new File(decodedPath);
        if (path.getName().toLowerCase().endsWith(".jar")) {
            return path.getParentFile();
        }
        return new File(".");
    }

    public static String getString(String key, String defaultValue) {
        String str = System.getProperty(key, Settings.localSettings.get().props.getProperty(key, defaultValue));
        return str;
    }

    public static File getTempDirectory() throws IOException {
        File tmpDir = new File(Settings.getString("temp.directory", System.getProperty("java.io.tmpdir")), "dctemp");
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            String msg = String.format("Unable to make a temporary folder '%s'", tmpDir.getPath());
            throw new IOException(msg);
        }
        tempDirectory = tmpDir;
        return tmpDir;
    }

    public static String getString(String key) {
        return System.getProperty(key, Settings.localSettings.get().props.getProperty(key));
    }

    public static void removeProperty(String key) {
        Settings.localSettings.get().props.remove(key);
    }

    public static int getInt(String key) throws InvalidSettingException {
        try {
            return Integer.parseInt(Settings.getString(key));
        }
        catch (NumberFormatException ex) {
            throw new InvalidSettingException("Could not convert property '" + key + "' to an int.", ex);
        }
    }

    public static int getInt(String key, int defaultValue) {
        int value;
        try {
            value = Integer.parseInt(Settings.getString(key));
        }
        catch (NumberFormatException ex) {
            LOGGER.trace("Could not convert property '{}' to an int.", (Object)key, (Object)ex);
            value = defaultValue;
        }
        return value;
    }

    public static long getLong(String key) throws InvalidSettingException {
        try {
            return Long.parseLong(Settings.getString(key));
        }
        catch (NumberFormatException ex) {
            throw new InvalidSettingException("Could not convert property '" + key + "' to a long.", ex);
        }
    }

    public static boolean getBoolean(String key) throws InvalidSettingException {
        return Boolean.parseBoolean(Settings.getString(key));
    }

    public static boolean getBoolean(String key, boolean defaultValue) throws InvalidSettingException {
        return Boolean.parseBoolean(Settings.getString(key, Boolean.toString(defaultValue)));
    }

    public static String getConnectionString(String connectionStringKey, String dbFileNameKey) throws IOException, InvalidSettingException {
        String connStr = Settings.getString(connectionStringKey);
        if (connStr == null) {
            String msg = String.format("Invalid properties file; %s is missing.", connectionStringKey);
            throw new InvalidSettingException(msg);
        }
        if (connStr.contains("%s")) {
            File directory = Settings.getDataDirectory();
            String fileName = null;
            if (dbFileNameKey != null) {
                fileName = Settings.getString(dbFileNameKey);
            }
            if (fileName == null) {
                String msg = String.format("Invalid properties file to get a file based connection string; '%s' must be defined.", dbFileNameKey);
                throw new InvalidSettingException(msg);
            }
            if (connStr.startsWith("jdbc:h2:file:") && fileName.endsWith(".h2.db")) {
                fileName = fileName.substring(0, fileName.length() - 6);
            }
            File dbFile = new File(directory, fileName);
            String cString = String.format(connStr, dbFile.getCanonicalPath());
            LOGGER.debug("Connection String: '{}'", (Object)cString);
            return cString;
        }
        return connStr;
    }

    public static File getDataDirectory() throws IOException {
        File path = Settings.getDataFile("data.directory");
        if (path.exists() || path.mkdirs()) {
            return path;
        }
        throw new IOException(String.format("Unable to create the data directory '%s'", path.getAbsolutePath()));
    }

    public static final class KEYS {
        public static final String APPLICATION_VAME = "application.name";
        public static final String APPLICATION_VERSION = "application.version";
        public static final String ENGINE_VERSION_CHECK_URL = "engine.version.url";
        public static final String AUTO_UPDATE = "autoupdate";
        public static final String DB_DRIVER_NAME = "data.driver_name";
        public static final String DB_DRIVER_PATH = "data.driver_path";
        public static final String DB_CONNECTION_STRING = "data.connection_string";
        public static final String DB_USER = "data.user";
        public static final String DB_PASSWORD = "data.password";
        public static final String DATA_DIRECTORY = "data.directory";
        public static final String DB_FILE_NAME = "data.file_name";
        public static final String DB_VERSION = "data.version";
        public static final String CVE_META_URL = "cve.url.meta";
        public static final String CVE_MODIFIED_20_URL = "cve.url-2.0.modified";
        public static final String CVE_MODIFIED_12_URL = "cve.url-1.2.modified";
        public static final String CVE_MODIFIED_VALID_FOR_DAYS = "cve.url.modified.validfordays";
        public static final String CVE_CHECK_VALID_FOR_HOURS = "cve.check.validforhours";
        public static final String CVE_START_YEAR = "cve.startyear";
        public static final String CVE_SCHEMA_1_2 = "cve.url-1.2.base";
        public static final String CVE_SCHEMA_2_0 = "cve.url-2.0.base";
        public static final String CPE_MODIFIED_VALID_FOR_DAYS = "cpe.validfordays";
        public static final String CPE_URL = "cpe.url";
        @Deprecated
        public static final String PROXY_URL = "proxy.server";
        public static final String PROXY_SERVER = "proxy.server";
        public static final String PROXY_PORT = "proxy.port";
        public static final String PROXY_USERNAME = "proxy.username";
        public static final String PROXY_PASSWORD = "proxy.password";
        public static final String PROXY_NON_PROXY_HOSTS = "proxy.nonproxyhosts";
        public static final String CONNECTION_TIMEOUT = "connection.timeout";
        public static final String TEMP_DIRECTORY = "temp.directory";
        public static final String MAX_DOWNLOAD_THREAD_POOL_SIZE = "max.download.threads";
        public static final String SUPPRESSION_FILE = "suppression.file";
        public static final String ANALYZER_JAR_ENABLED = "analyzer.jar.enabled";
        public static final String ANALYZER_ARCHIVE_ENABLED = "analyzer.archive.enabled";
        public static final String ANALYZER_NODE_PACKAGE_ENABLED = "analyzer.node.package.enabled";
        public static final String ANALYZER_COMPOSER_LOCK_ENABLED = "analyzer.composer.lock.enabled";
        public static final String ANALYZER_PYTHON_DISTRIBUTION_ENABLED = "analyzer.python.distribution.enabled";
        public static final String ANALYZER_PYTHON_PACKAGE_ENABLED = "analyzer.python.package.enabled";
        public static final String ANALYZER_RUBY_GEMSPEC_ENABLED = "analyzer.ruby.gemspec.enabled";
        public static final String ANALYZER_AUTOCONF_ENABLED = "analyzer.autoconf.enabled";
        public static final String ANALYZER_CMAKE_ENABLED = "analyzer.cmake.enabled";
        public static final String ANALYZER_BUNDLE_AUDIT_ENABLED = "analyzer.bundle.audit.enabled";
        public static final String ANALYZER_ASSEMBLY_ENABLED = "analyzer.assembly.enabled";
        public static final String ANALYZER_NUSPEC_ENABLED = "analyzer.nuspec.enabled";
        public static final String ANALYZER_NEXUS_ENABLED = "analyzer.nexus.enabled";
        public static final String ANALYZER_NEXUS_URL = "analyzer.nexus.url";
        public static final String ANALYZER_NEXUS_USES_PROXY = "analyzer.nexus.proxy";
        public static final String ANALYZER_CENTRAL_ENABLED = "analyzer.central.enabled";
        public static final String ANALYZER_OPENSSL_ENABLED = "analyzer.openssl.enabled";
        public static final String ANALYZER_CENTRAL_URL = "analyzer.central.url";
        public static final String ANALYZER_ASSEMBLY_MONO_PATH = "analyzer.assembly.mono.path";
        public static final String ANALYZER_BUNDLE_AUDIT_PATH = "analyzer.bundle.audit.path";
        public static final String ADDITIONAL_ZIP_EXTENSIONS = "extensions.zip";
        public static final String VFEED_DATA_FILE = "vfeed.data_file";
        public static final String VFEED_CONNECTION_STRING = "vfeed.connection_string";
        public static final String VFEED_DOWNLOAD_URL = "vfeed.download_url";
        public static final String VFEED_DOWNLOAD_FILE = "vfeed.download_file";
        public static final String VFEED_UPDATE_STATUS = "vfeed.update_status";
        public static final String DOWNLOADER_QUICK_QUERY_TIMESTAMP = "downloader.quick.query.timestamp";

        private KEYS() {
        }
    }
}

