/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;

public final class URLConnectionFactory {
    private URLConnectionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"}, justification="Just being extra safe")
    public static HttpURLConnection createHttpURLConnection(URL url) throws URLConnectionFailureException {
        HttpURLConnection conn = null;
        String proxyUrl = Settings.getString("proxy.server");
        try {
            if (proxyUrl != null) {
                int proxyPort = Settings.getInt("proxy.port");
                InetSocketAddress address = new InetSocketAddress(proxyUrl, proxyPort);
                final String username = Settings.getString("proxy.username");
                final String password = Settings.getString("proxy.password");
                if (username != null && password != null) {
                    Authenticator auth = new Authenticator(){

                        @Override
                        public PasswordAuthentication getPasswordAuthentication() {
                            if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                                return new PasswordAuthentication(username, password.toCharArray());
                            }
                            return super.getPasswordAuthentication();
                        }
                    };
                    Authenticator.setDefault(auth);
                }
                Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                conn = (HttpURLConnection)url.openConnection(proxy);
            } else {
                conn = (HttpURLConnection)url.openConnection();
            }
            int timeout = Settings.getInt("connection.timeout", 10000);
            conn.setConnectTimeout(timeout);
            conn.setInstanceFollowRedirects(true);
        }
        catch (IOException ex) {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                finally {
                    conn = null;
                }
            }
            throw new URLConnectionFailureException("Error getting connection.", ex);
        }
        return conn;
    }

    public static HttpURLConnection createHttpURLConnection(URL url, boolean proxy) throws URLConnectionFailureException {
        if (proxy) {
            return URLConnectionFactory.createHttpURLConnection(url);
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            int timeout = Settings.getInt("connection.timeout", 10000);
            conn.setConnectTimeout(timeout);
            conn.setInstanceFollowRedirects(true);
        }
        catch (IOException ioe) {
            throw new URLConnectionFailureException("Error getting connection.", ioe);
        }
        return conn;
    }
}

