/*
 * Decompiled with CFR 0.152.
 */
package org.xlcloud.openstack.client;

import com.sun.jersey.api.client.ClientHandlerException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.bind.MarshalException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xlcloud.openstack.client.OpenStackKeystoneClient;
import org.xlcloud.openstack.model.exceptions.OpenStackAuthenticationException;

public class RefreshAuthenticationHandler
implements InvocationHandler {
    private static final Logger LOG = Logger.getLogger(RefreshAuthenticationHandler.class);
    public OpenStackKeystoneClient client;
    private String password;
    private String username;
    private String tenantName;

    RefreshAuthenticationHandler(OpenStackKeystoneClient client, String username, String password, String tenantName) {
        this.client = client;
        this.username = username;
        this.password = password;
        this.tenantName = tenantName;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (StringUtils.isBlank((String)this.client.getToken())) {
                LOG.info((Object)"Token is empty. Authenticating by Keystone.");
                this.client.reauthenticate(this.username, this.password, this.tenantName);
                return this.doInvoke(this.client, method, args);
            }
            try {
                return this.doInvoke(this.client, method, args);
            }
            catch (OpenStackAuthenticationException e) {
                LOG.info((Object)"Got 401 response. Authenticating by Keystone.");
                this.client.reauthenticate(this.username, this.password, this.tenantName);
                return this.doInvoke(this.client, method, args);
            }
        }
        catch (ClientHandlerException e) {
            throw this.unwrapNoRouteToHostException(e);
        }
    }

    private Throwable unwrapNoRouteToHostException(ClientHandlerException e) {
        if (e.getCause() != null && e.getCause().getCause() instanceof MarshalException) {
            Throwable linkedException = ((MarshalException)e.getCause().getCause()).getLinkedException();
            LOG.warn((Object)("Got marshal exception linked with " + linkedException.getClass() + " that will be rethrown."));
            return linkedException;
        }
        return e;
    }

    private Object doInvoke(Object target, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

