/**
 * Copyright 2007-2012 Bull S.A.S.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.util.ant.archive.file;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.War;
import org.apache.tools.ant.types.FileSet;
import org.ow2.util.ant.archive.api.IWar;
import org.ow2.util.ant.archive.info.ArchiveInfo;
import org.ow2.util.ant.archive.info.WarInfo;

/**
 * Creates a WAR file.
 * @author Florent Benoit
 */
public class WarFile extends War implements IWar {

    /**
     * Reference to the archive info object.
     */
    private ArchiveInfo archiveInfo = null;

    /**
     * Creates an archive for the given project.
     * @param p the given project
     */
    public WarFile(final Project p) {
        super();
        setProject(p);
    }

    /**
     * Sets the information about an archive.
     * @param archiveInfo the object that holds data information.
     */
    public void setArchiveInfo(final ArchiveInfo archiveInfo) {
        this.archiveInfo = archiveInfo;
    }

    /**
     * Sets the information about a war archive.
     * @param warInfo the object that holds data information.
     */
    public void setWarInfo(final WarInfo warInfo) {
        setArchiveInfo(warInfo);
    }

    /**
     * Execute the task.
     */
    @Override
    public void execute() {

        // Deployment descriptor
        if (this.archiveInfo.getDD() != null) {
            setWebxml(this.archiveInfo.getDD());
        }

        // Manifest
        if (this.archiveInfo.getManifest() != null) {
            setManifest(this.archiveInfo.getManifest());
        }

        // dest file
        setDestFile(this.archiveInfo.getDest());

        // fileset
        for (FileSet fileSet : this.archiveInfo.getFileSetList()) {
            addFileset(fileSet);
        }


        super.execute();
    }


}
