/**
 * Copyright 2007-2012 Bull S.A.S.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.util.ant.archive.exploded;

import org.apache.tools.ant.Project;
import org.ow2.util.ant.archive.api.IWar;
import org.ow2.util.ant.archive.info.WarInfo;

/**
 * Build a War archive in exploded mode.
 * @author Florent Benoit
 */
public class WarExploded extends AbsExplodedArchive implements IWar {

    /**
     * Path to the Standard deployment descriptor.
     */
    private static final String DEPLOYMENT_DESCRIPTOR = "WEB-INF/web.xml";

    /**
     * Path to the Specific deployment descriptor.
     */
    private static final String SPECIFIC_DEPLOYMENT_DESCRIPTOR = "WEB-INF/easybeans.xml";


    /**
     * Creates an archive for the given project.
     * @param p the given project
     */
    public WarExploded(final Project p) {
        super(p);
    }

    /**
     * Sets the information about a war archive.
     * @param warInfo the object that holds data information.
     */
    public void setWarInfo(final WarInfo warInfo) {
        setArchiveInfo(warInfo);
    }

    /**
     * Gets the path to the standard deployment descriptor.
     * @return the path to the standard deployment descriptor.
     */
    @Override
    public String getDDStandardName() {
        return DEPLOYMENT_DESCRIPTOR;
    }

    /**
     * Gets the path to the specific deployment descriptor.
     * @return the path to the specific deployment descriptor.
     */
    @Override
    public String getDDSpecificame() {
        return SPECIFIC_DEPLOYMENT_DESCRIPTOR;
    }

}
