/**
 * Copyright 2007-2012 Bull S.A.S.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.util.ant.archive.api;

import org.ow2.util.ant.archive.info.ArchiveInfo;

/**
 * Interface for archives.
 * @author Florent Benoit
 */
public interface IArchive {

    /**
     * Sets the information about an archive.
     * @param archiveInfo the object that holds data information.
     */
    void setArchiveInfo(final ArchiveInfo archiveInfo);

    /**
     * Execute the task by using either exploded or file mode.
     */
    void execute();

}
