/*
 * Kerneos
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine AT ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id$
 */

/**
 * @author Loic Albertin
 */
package org.ow2.kerneos.examples.extensions.common.event {
import com.adobe.cairngorm.control.CairngormEvent;

public class InsuranceEvent extends CairngormEvent{

    public static const INSURANCE_APPROVED:String = "InsuranceEvent_Approved";
    public static const INSURANCE_REJECTED:String = "InsuranceEvent_Rejected";
    public static const INSURANCE_INIT:String = "InsuranceEvent_Init";

    private var _payment:Number;
    private var _reason:String;

    public function InsuranceEvent(type:String, payment:Number = NaN, reason:String=null) {
        super(type);
        _payment = payment;
        _reason = reason;
    }


    public function get payment():Number {
        return _payment;
    }

    public function get reason():String {
        return _reason;
    }
}
}
