/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import org.osmdroid.util.MapTileArea;
import org.osmdroid.util.MapTileAreaComputer;
import org.osmdroid.util.MapTileIndex;

public class MapTileAreaZoomComputer
implements MapTileAreaComputer {
    private final int mZoomDelta;

    public MapTileAreaZoomComputer(int pZoomDelta) {
        this.mZoomDelta = pZoomDelta;
    }

    @Override
    public MapTileArea computeFromSource(MapTileArea pSource, MapTileArea pReuse) {
        MapTileArea out;
        MapTileArea mapTileArea = out = pReuse != null ? pReuse : new MapTileArea();
        if (pSource.size() == 0) {
            out.reset();
            return out;
        }
        int sourceZoom = pSource.getZoom();
        int destZoom = sourceZoom + this.mZoomDelta;
        if (destZoom < 0 || destZoom > MapTileIndex.mMaxZoomLevel) {
            out.reset();
            return out;
        }
        if (this.mZoomDelta <= 0) {
            out.set(destZoom, pSource.getLeft() >> -this.mZoomDelta, pSource.getTop() >> -this.mZoomDelta, pSource.getRight() >> -this.mZoomDelta, pSource.getBottom() >> -this.mZoomDelta);
            return out;
        }
        out.set(destZoom, pSource.getLeft() << this.mZoomDelta, pSource.getTop() << this.mZoomDelta, (1 + pSource.getRight() << this.mZoomDelta) - 1, (1 + pSource.getBottom() << this.mZoomDelta) - 1);
        return out;
    }
}

