/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.milestones;

import android.graphics.Canvas;
import org.osmdroid.views.overlay.milestones.MilestoneStep;

public abstract class MilestoneDisplayer {
    private final double mInitialOrientation;
    private final boolean mFollowTrajectory;

    public MilestoneDisplayer(double pInitialOrientation, boolean pFollowTrajectory) {
        this.mInitialOrientation = pInitialOrientation;
        this.mFollowTrajectory = pFollowTrajectory;
    }

    public void draw(Canvas pCanvas, MilestoneStep pStep) {
        double orientation = this.mInitialOrientation + (this.mFollowTrajectory ? pStep.getOrientation() : 0.0);
        pCanvas.save();
        pCanvas.rotate((float)orientation, (float)pStep.getX(), (float)pStep.getY());
        pCanvas.translate((float)pStep.getX(), (float)pStep.getY());
        this.draw(pCanvas, pStep.getObject());
        pCanvas.restore();
    }

    protected abstract void draw(Canvas var1, Object var2);

    public void drawBegin(Canvas pCanvas) {
    }

    public void drawEnd(Canvas pCanvas) {
    }
}

