/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.util.RectL;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.OverlayItem;

public abstract class ItemizedOverlay<Item extends OverlayItem>
extends Overlay
implements Overlay.Snappable {
    protected int mDrawnItemsLimit = Integer.MAX_VALUE;
    protected final Drawable mDefaultMarker;
    private final ArrayList<Item> mInternalItemList;
    private boolean[] mInternalItemDisplayedList;
    private final Rect mRect = new Rect();
    private final Rect mOrientedMarkerRect = new Rect();
    private final Point mCurScreenCoords = new Point();
    protected boolean mDrawFocusedItem = true;
    private Item mFocusedItem;
    private boolean mPendingFocusChangedEvent = false;
    private OnFocusChangeListener mOnFocusChangeListener;
    private Rect itemRect = new Rect();
    private Rect screenRect = new Rect();

    protected abstract Item createItem(int var1);

    public abstract int size();

    @Deprecated
    public ItemizedOverlay(Context ctx, Drawable pDefaultMarker) {
        this(pDefaultMarker);
    }

    public ItemizedOverlay(Drawable pDefaultMarker) {
        if (pDefaultMarker == null) {
            throw new IllegalArgumentException("You must pass a default marker to ItemizedOverlay.");
        }
        this.mDefaultMarker = pDefaultMarker;
        this.mInternalItemList = new ArrayList();
    }

    public int getDrawnItemsLimit() {
        return this.mDrawnItemsLimit;
    }

    public void setDrawnItemsLimit(int aLimit) {
        this.mDrawnItemsLimit = aLimit;
    }

    @Override
    public void onDetach(MapView mapView) {
        if (this.mDefaultMarker != null) {
            // empty if block
        }
    }

    @Override
    public void draw(Canvas canvas, Projection pj) {
        if (this.mPendingFocusChangedEvent && this.mOnFocusChangeListener != null) {
            this.mOnFocusChangeListener.onFocusChanged(this, (OverlayItem)this.mFocusedItem);
        }
        this.mPendingFocusChangedEvent = false;
        int size = Math.min(this.mInternalItemList.size(), this.mDrawnItemsLimit);
        if (this.mInternalItemDisplayedList == null || this.mInternalItemDisplayedList.length != size) {
            this.mInternalItemDisplayedList = new boolean[size];
        }
        for (int i = size - 1; i >= 0; --i) {
            Item item = this.getItem(i);
            if (item == null) continue;
            pj.toPixels(((OverlayItem)item).getPoint(), this.mCurScreenCoords);
            this.calculateItemRect(item, this.mCurScreenCoords, this.itemRect);
            this.mInternalItemDisplayedList[i] = this.onDrawItem(canvas, item, this.mCurScreenCoords, pj);
        }
    }

    protected final void populate() {
        int size = this.size();
        this.mInternalItemList.clear();
        this.mInternalItemList.ensureCapacity(size);
        for (int a = 0; a < size; ++a) {
            this.mInternalItemList.add(this.createItem(a));
        }
        this.mInternalItemDisplayedList = null;
    }

    public final Item getItem(int position) {
        try {
            return (Item)((OverlayItem)this.mInternalItemList.get(position));
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    protected boolean onDrawItem(Canvas canvas, Item item, Point curScreenCoords, Projection pProjection) {
        int state = this.mDrawFocusedItem && this.mFocusedItem == item ? 4 : 0;
        Drawable marker = ((OverlayItem)item).getMarker(state) == null ? this.getDefaultMarker(state) : ((OverlayItem)item).getMarker(state);
        OverlayItem.HotspotPlace hotspot = ((OverlayItem)item).getMarkerHotspot();
        this.boundToHotspot(marker, hotspot);
        int x = this.mCurScreenCoords.x;
        int y = this.mCurScreenCoords.y;
        marker.copyBounds(this.mRect);
        this.mRect.offset(x, y);
        RectL.getBounds(this.mRect, x, y, (double)pProjection.getOrientation(), this.mOrientedMarkerRect);
        boolean displayed = Rect.intersects((Rect)this.mOrientedMarkerRect, (Rect)canvas.getClipBounds());
        if (displayed) {
            if (pProjection.getOrientation() != 0.0f) {
                canvas.save();
                canvas.rotate(-pProjection.getOrientation(), (float)x, (float)y);
            }
            marker.setBounds(this.mRect);
            marker.draw(canvas);
            if (pProjection.getOrientation() != 0.0f) {
                canvas.restore();
            }
        }
        return displayed;
    }

    public List<Item> getDisplayedItems() {
        ArrayList<Item> result = new ArrayList<Item>();
        if (this.mInternalItemDisplayedList == null) {
            return result;
        }
        for (int i = 0; i < this.mInternalItemDisplayedList.length; ++i) {
            if (!this.mInternalItemDisplayedList[i]) continue;
            result.add(this.getItem(i));
        }
        return result;
    }

    protected Drawable getDefaultMarker(int state) {
        OverlayItem.setState(this.mDefaultMarker, state);
        return this.mDefaultMarker;
    }

    protected boolean hitTest(Item item, Drawable marker, int hitX, int hitY) {
        return marker.getBounds().contains(hitX, hitY);
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent e, MapView mapView) {
        int size = this.size();
        int eventX = Math.round(e.getX());
        int eventY = Math.round(e.getY());
        for (int i = 0; i < size; ++i) {
            if (!this.isEventOnItem(this.getItem(i), eventX, eventY, mapView) || !this.onTap(i)) continue;
            return true;
        }
        return super.onSingleTapConfirmed(e, mapView);
    }

    protected boolean onTap(int index) {
        return false;
    }

    public void setDrawFocusedItem(boolean drawFocusedItem) {
        this.mDrawFocusedItem = drawFocusedItem;
    }

    public void setFocus(Item item) {
        this.mPendingFocusChangedEvent = item != this.mFocusedItem;
        this.mFocusedItem = item;
    }

    public Item getFocus() {
        return this.mFocusedItem;
    }

    protected Drawable boundToHotspot(Drawable marker, OverlayItem.HotspotPlace hotspot) {
        int offsetY;
        int offsetX;
        if (hotspot == null) {
            hotspot = OverlayItem.HotspotPlace.BOTTOM_CENTER;
        }
        int markerWidth = marker.getIntrinsicWidth();
        int markerHeight = marker.getIntrinsicHeight();
        switch (hotspot) {
            default: {
                offsetX = 0;
                break;
            }
            case CENTER: 
            case BOTTOM_CENTER: 
            case TOP_CENTER: {
                offsetX = -markerWidth / 2;
                break;
            }
            case RIGHT_CENTER: 
            case UPPER_RIGHT_CORNER: 
            case LOWER_RIGHT_CORNER: {
                offsetX = -markerWidth;
            }
        }
        switch (hotspot) {
            default: {
                offsetY = 0;
                break;
            }
            case LEFT_CENTER: 
            case CENTER: 
            case RIGHT_CENTER: {
                offsetY = -markerHeight / 2;
                break;
            }
            case LOWER_LEFT_CORNER: 
            case BOTTOM_CENTER: 
            case LOWER_RIGHT_CORNER: {
                offsetY = -markerHeight;
            }
        }
        marker.setBounds(offsetX, offsetY, offsetX + markerWidth, offsetY + markerHeight);
        return marker;
    }

    protected Rect calculateItemRect(Item item, Point coords, Rect reuse) {
        Rect out = reuse != null ? reuse : new Rect();
        OverlayItem.HotspotPlace hotspot = ((OverlayItem)item).getMarkerHotspot();
        if (hotspot == null) {
            hotspot = OverlayItem.HotspotPlace.BOTTOM_CENTER;
        }
        int state = this.mDrawFocusedItem && this.mFocusedItem == item ? 4 : 0;
        Drawable marker = ((OverlayItem)item).getMarker(state) == null ? this.getDefaultMarker(state) : ((OverlayItem)item).getMarker(state);
        int itemWidth = marker.getIntrinsicWidth();
        int itemHeight = marker.getIntrinsicHeight();
        switch (hotspot) {
            case NONE: {
                out.set(coords.x - itemWidth / 2, coords.y - itemHeight / 2, coords.x + itemWidth / 2, coords.y + itemHeight / 2);
                break;
            }
            case CENTER: {
                out.set(coords.x - itemWidth / 2, coords.y - itemHeight / 2, coords.x + itemWidth / 2, coords.y + itemHeight / 2);
                break;
            }
            case BOTTOM_CENTER: {
                out.set(coords.x - itemWidth / 2, coords.y - itemHeight, coords.x + itemWidth / 2, coords.y);
                break;
            }
            case TOP_CENTER: {
                out.set(coords.x - itemWidth / 2, coords.y, coords.x + itemWidth / 2, coords.y + itemHeight);
                break;
            }
            case RIGHT_CENTER: {
                out.set(coords.x - itemWidth, coords.y - itemHeight / 2, coords.x, coords.y + itemHeight / 2);
                break;
            }
            case LEFT_CENTER: {
                out.set(coords.x, coords.y - itemHeight / 2, coords.x + itemWidth, coords.y + itemHeight / 2);
                break;
            }
            case UPPER_RIGHT_CORNER: {
                out.set(coords.x - itemWidth, coords.y, coords.x, coords.y + itemHeight);
                break;
            }
            case LOWER_RIGHT_CORNER: {
                out.set(coords.x - itemWidth, coords.y - itemHeight, coords.x, coords.y);
                break;
            }
            case UPPER_LEFT_CORNER: {
                out.set(coords.x, coords.y, coords.x + itemWidth, coords.y + itemHeight);
                break;
            }
            case LOWER_LEFT_CORNER: {
                out.set(coords.x, coords.y - itemHeight, coords.x + itemWidth, coords.y);
            }
        }
        return out;
    }

    public void setOnFocusChangeListener(OnFocusChangeListener l) {
        this.mOnFocusChangeListener = l;
    }

    protected boolean isEventOnItem(Item pItem, int pEventX, int pEventY, MapView pMapView) {
        if (pItem == null) {
            return false;
        }
        pMapView.getProjection().toPixels(((OverlayItem)pItem).getPoint(), this.mCurScreenCoords);
        int state = this.mDrawFocusedItem && this.mFocusedItem == pItem ? 4 : 0;
        Drawable marker = ((OverlayItem)pItem).getMarker(state);
        if (marker == null) {
            marker = this.getDefaultMarker(state);
        }
        this.boundToHotspot(marker, ((OverlayItem)pItem).getMarkerHotspot());
        marker.copyBounds(this.mRect);
        this.mRect.offset(this.mCurScreenCoords.x, this.mCurScreenCoords.y);
        RectL.getBounds(this.mRect, this.mCurScreenCoords.x, this.mCurScreenCoords.y, (double)(-pMapView.getMapOrientation()), this.mOrientedMarkerRect);
        return this.mOrientedMarkerRect.contains(pEventX, pEventY);
    }

    public static interface OnFocusChangeListener {
        public void onFocusChanged(ItemizedOverlay<?> var1, OverlayItem var2);
    }
}

