/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;

public class StorageUtils {
    public static final String SD_CARD = "sdCard";
    public static final String EXTERNAL_SD_CARD = "externalSdCard";
    private static final String TAG = "StorageUtils";

    public static List<StorageInfo> getStorageList() {
        return StorageUtils.getStorageList(null);
    }

    public static List<StorageInfo> getStorageList(Context context) {
        List<StorageInfo> storageInfos;
        if (Build.VERSION.SDK_INT >= 29) {
            storageInfos = context != null ? StorageUtils.getStorageListApi19(context) : StorageUtils.getStorageListPreApi19();
        } else if (Build.VERSION.SDK_INT >= 19) {
            storageInfos = StorageUtils.getStorageListPreApi19();
            if (context != null) {
                List<StorageInfo> storageInfosApi19 = StorageUtils.getStorageListApi19(context);
                storageInfosApi19.removeAll(storageInfos);
                storageInfos.addAll(storageInfosApi19);
            }
        } else {
            String dbPath;
            storageInfos = StorageUtils.getStorageListPreApi19();
            if (storageInfos.size() == 0 && context != null && StorageUtils.isWritable(new File(dbPath = context.getDatabasePath("temp.sqlite").getAbsolutePath().replace("temp.sqlite", "")))) {
                storageInfos.add(new StorageInfo(dbPath, true, false, -1));
            }
        }
        return storageInfos;
    }

    private static List<StorageInfo> getStorageListPreApi19() {
        ArrayList<StorageInfo> storageInfos = new ArrayList<StorageInfo>();
        StorageInfo primarySharedStorageInfo = StorageUtils.getPrimarySharedStorage();
        if (primarySharedStorageInfo != null) {
            storageInfos.add(primarySharedStorageInfo);
        }
        storageInfos.addAll(StorageUtils.tryToFindOtherVoIdManagedStorages(primarySharedStorageInfo != null ? primarySharedStorageInfo.path : ""));
        Set<File> allStorageLocationsRevised = StorageUtils.getAllWritableStorageLocations();
        for (File storageLocation : allStorageLocationsRevised) {
            boolean found = false;
            for (StorageInfo storageInfo : storageInfos) {
                if (!storageInfo.path.equals(storageLocation.getAbsolutePath())) continue;
                found = true;
                break;
            }
            if (found) continue;
            storageInfos.add(new StorageInfo(storageLocation.getAbsolutePath(), false, false, -1));
        }
        return storageInfos;
    }

    @SuppressLint(value={"NewApi"})
    private static List<StorageInfo> getStorageListApi19(Context context) {
        ArrayList<StorageInfo> storageInfos = new ArrayList<StorageInfo>();
        storageInfos.add(new StorageInfo(context.getFilesDir().getAbsolutePath(), true, false, -1));
        ArrayList<File> storageDirs = new ArrayList<File>();
        File[] externalDirs = context.getExternalFilesDirs(null);
        for (File externalDir : externalDirs) {
            String state;
            if (externalDir == null || !"mounted".equals(state = Environment.getStorageState((File)externalDir))) continue;
            storageDirs.add(externalDir);
        }
        for (File storageDir : storageDirs) {
            storageInfos.add(new StorageInfo(storageDir.getAbsolutePath(), false, false, -1));
        }
        return storageInfos;
    }

    @Deprecated
    public static File getStorage() {
        return StorageUtils.getStorage(null);
    }

    public static StorageInfo getBestWritableStorage() {
        return StorageUtils.getBestWritableStorage(null);
    }

    @Deprecated
    public static File getStorage(Context context) {
        StorageInfo bestStorage = StorageUtils.getBestWritableStorage(context);
        if (bestStorage != null) {
            return new File(bestStorage.path);
        }
        return null;
    }

    public static StorageInfo getBestWritableStorage(Context context) {
        StorageInfo bestStorage = null;
        List<StorageInfo> storageList = StorageUtils.getStorageList(context);
        for (int i = 0; i < storageList.size(); ++i) {
            StorageInfo currentStorage = storageList.get(i);
            if (currentStorage.readonly || !StorageUtils.isWritable(new File(currentStorage.path))) continue;
            if (bestStorage != null) {
                if (bestStorage.freeSpace >= currentStorage.freeSpace) continue;
                bestStorage = currentStorage;
                continue;
            }
            bestStorage = currentStorage;
        }
        return bestStorage;
    }

    @Deprecated
    public static boolean isAvailable() {
        return StorageUtils.isPrimarySharedStorageAvailable();
    }

    private static boolean isPrimarySharedStorageAvailable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state) || "mounted_ro".equals(state);
    }

    @Deprecated
    public static String getSdCardPath() {
        return Environment.getExternalStorageDirectory().getPath() + "/";
    }

    @Deprecated
    public static boolean isWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isWritable(File path) {
        boolean bl;
        FileOutputStream fos = null;
        try {
            File tmp = new File(path.getAbsolutePath() + File.separator + UUID.randomUUID().toString());
            fos = new FileOutputStream(tmp);
            fos.write("hi".getBytes());
            tmp.delete();
            Log.i((String)TAG, (String)(path.getAbsolutePath() + " is writable"));
            bl = true;
            if (fos == null) return bl;
        }
        catch (Throwable ex) {
            try {
                Log.i((String)TAG, (String)(path.getAbsolutePath() + " is NOT writable"));
                boolean bl2 = false;
                return bl2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            fos.close();
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public static Map<String, File> getAllStorageLocations() {
        HashMap<String, File> map = new HashMap<String, File>(10);
        map.putAll(StorageUtils.tryToGetMountedStoragesFromFilesystem());
        if (!map.containsValue(Environment.getExternalStorageDirectory())) {
            map.put(SD_CARD, Environment.getExternalStorageDirectory());
        }
        Set<File> fromSystemEnv = StorageUtils.tryToGetStorageFromSystemEnv();
        for (File file : fromSystemEnv) {
            if (!file.exists() || map.containsValue(file)) continue;
            map.put(SD_CARD, file);
        }
        return map;
    }

    private static Set<File> getAllWritableStorageLocations() {
        File t;
        HashSet<File> map = new HashSet<File>();
        Set<File> fromSystemEnv = StorageUtils.tryToGetStorageFromSystemEnv();
        for (File file : fromSystemEnv) {
            if (!StorageUtils.isWritable(file)) continue;
            map.add(file);
        }
        if (Environment.getExternalStorageDirectory() != null && StorageUtils.isWritable(t = Environment.getExternalStorageDirectory())) {
            map.add(t);
        }
        Map<String, File> mounts = StorageUtils.tryToGetMountedStoragesFromFilesystem();
        for (File file : mounts.values()) {
            if (!StorageUtils.isWritable(file)) continue;
            map.add(file);
        }
        return map;
    }

    private static StorageInfo getPrimarySharedStorage() {
        String primarySharedStoragePath = "";
        boolean isPrimarySharedStorageNotRemovable = false;
        boolean isPrimarySharedStorageReadonly = true;
        boolean isPrimarySharedStorageAvailable = false;
        try {
            if (Environment.getExternalStorageDirectory() != null) {
                primarySharedStoragePath = Environment.getExternalStorageDirectory().getPath();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            if (Build.VERSION.SDK_INT >= 9) {
                isPrimarySharedStorageNotRemovable = !Environment.isExternalStorageRemovable();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            isPrimarySharedStorageAvailable = StorageUtils.isPrimarySharedStorageAvailable();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            isPrimarySharedStorageReadonly = Environment.getExternalStorageState().equals("mounted_ro");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        StorageInfo primarySharedStorageInfo = null;
        if (isPrimarySharedStorageAvailable) {
            primarySharedStorageInfo = new StorageInfo(primarySharedStoragePath, isPrimarySharedStorageNotRemovable, isPrimarySharedStorageReadonly, -1);
        }
        return primarySharedStorageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<StorageInfo> tryToFindOtherVoIdManagedStorages(String storagePathToIgnore) {
        ArrayList<StorageInfo> storageInfos = new ArrayList<StorageInfo>();
        BufferedReader bufferedReader = null;
        try {
            String line;
            HashSet<String> paths = new HashSet<String>();
            bufferedReader = new BufferedReader(new FileReader("/proc/mounts"));
            int currentDisplayNumber = 1;
            Log.d((String)TAG, (String)"/proc/mounts");
            while ((line = bufferedReader.readLine()) != null) {
                Log.d((String)TAG, (String)line);
                if (!line.contains("vfat") && !line.contains("/mnt")) continue;
                StringTokenizer tokens = new StringTokenizer(line, " ");
                String unused = tokens.nextToken();
                String mountPoint = tokens.nextToken();
                if (paths.contains(mountPoint)) continue;
                unused = tokens.nextToken();
                List<String> flags = Arrays.asList(tokens.nextToken().split(","));
                boolean readonly = flags.contains("ro");
                if (mountPoint.equals(storagePathToIgnore)) {
                    paths.add(storagePathToIgnore);
                    continue;
                }
                if (!line.contains("/dev/block/vold") || line.contains("/mnt/secure") || line.contains("/mnt/asec") || line.contains("/mnt/obb") || line.contains("/dev/mapper") || line.contains("tmpfs")) continue;
                paths.add(mountPoint);
                if (!new File(mountPoint + File.separator).exists()) continue;
                storageInfos.add(new StorageInfo(mountPoint, false, readonly, currentDisplayNumber++));
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ex) {}
            }
        }
        return storageInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, File> tryToGetMountedStoragesFromFilesystem() {
        String[] lineElements;
        String element;
        String line;
        HashMap<String, File> map = new HashMap<String, File>();
        ArrayList<String> mounts = new ArrayList<String>(10);
        ArrayList<String> vold = new ArrayList<String>(10);
        mounts.add("/mnt/sdcard");
        vold.add("/mnt/sdcard");
        Scanner scanner = null;
        try {
            File mountFile = new File("/proc/mounts");
            if (mountFile.exists()) {
                scanner = new Scanner(mountFile);
                while (scanner.hasNext()) {
                    line = scanner.nextLine();
                    if (!line.startsWith("/dev/block/vold/") || (element = (lineElements = line.split(" "))[1]).equals("/mnt/sdcard")) continue;
                    mounts.add(element);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Exception e) {}
            }
            scanner = null;
        }
        try {
            File voldFile = new File("/system/etc/vold.fstab");
            if (voldFile.exists()) {
                scanner = new Scanner(voldFile);
                while (scanner.hasNext()) {
                    line = scanner.nextLine();
                    if (!line.startsWith("dev_mount")) continue;
                    lineElements = line.split(" ");
                    element = lineElements[2];
                    if (element.contains(":")) {
                        element = element.substring(0, element.indexOf(":"));
                    }
                    if (element.equals("/mnt/sdcard")) continue;
                    vold.add(element);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Exception e) {}
            }
        }
        for (int i = 0; i < mounts.size(); ++i) {
            String mount = (String)mounts.get(i);
            if (vold.contains(mount)) continue;
            mounts.remove(i--);
        }
        vold.clear();
        ArrayList<String> mountHash = new ArrayList<String>(10);
        for (String mount : mounts) {
            File root = new File(mount);
            if (!root.exists() || !root.isDirectory() || !root.canWrite()) continue;
            File[] list = root.listFiles();
            StringBuilder hash = new StringBuilder("[");
            if (list != null) {
                for (File f : list) {
                    hash.append(f.getName().hashCode()).append(":").append(f.length()).append(", ");
                }
            }
            hash.append("]");
            if (mountHash.contains(hash.toString())) continue;
            String key = "sdCard_" + map.size();
            if (map.size() == 0) {
                key = SD_CARD;
            } else if (map.size() == 1) {
                key = EXTERNAL_SD_CARD;
            }
            mountHash.add(hash.toString());
            map.put(key, root);
        }
        return map;
    }

    private static Set<File> tryToGetStorageFromSystemEnv() {
        String secondarySd;
        HashSet<File> storages = new HashSet<File>();
        String primarySd = System.getenv("EXTERNAL_STORAGE");
        if (primarySd != null) {
            File t = new File(primarySd + File.separator);
            storages.add(t);
        }
        if ((secondarySd = System.getenv("SECONDARY_STORAGE")) != null) {
            String[] split;
            for (String s : split = secondarySd.split(File.pathSeparator)) {
                File t = new File(s + File.separator);
                storages.add(t);
            }
        }
        return storages;
    }

    public static class StorageInfo {
        public final String path;
        public final boolean internal;
        public boolean readonly;
        public final int display_number;
        public long freeSpace = 0L;
        public String displayName;

        public StorageInfo(String path, boolean internal, boolean readonly, int display_number) {
            this.path = path;
            this.internal = internal;
            this.display_number = display_number;
            if (Build.VERSION.SDK_INT >= 18) {
                this.freeSpace = new StatFs(path).getAvailableBytes();
            } else if (Build.VERSION.SDK_INT >= 9) {
                this.freeSpace = new File(path).getFreeSpace();
            }
            if (!readonly) {
                this.readonly = !StorageUtils.isWritable(new File(path));
            }
            StringBuilder res = new StringBuilder();
            if (internal) {
                res.append("Internal SD card");
            } else if (display_number > 1) {
                res.append("SD card ").append(display_number);
            } else {
                res.append("SD card");
            }
            if (readonly) {
                res.append(" (Read only)");
            }
            this.displayName = res.toString();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String val) {
            this.displayName = val;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StorageInfo that = (StorageInfo)o;
            if (this.internal != that.internal) {
                return false;
            }
            if (this.readonly != that.readonly) {
                return false;
            }
            if (this.display_number != that.display_number) {
                return false;
            }
            if (this.freeSpace != that.freeSpace) {
                return false;
            }
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
                return false;
            }
            return this.displayName != null ? this.displayName.equals(that.displayName) : that.displayName == null;
        }

        public int hashCode() {
            int result = this.path != null ? this.path.hashCode() : 0;
            result = 31 * result + (this.internal ? 1 : 0);
            result = 31 * result + (this.readonly ? 1 : 0);
            result = 31 * result + this.display_number;
            result = 31 * result + (int)(this.freeSpace ^ this.freeSpace >>> 32);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            return result;
        }
    }
}

