/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.tilesource;

import android.util.Log;
import java.net.HttpURLConnection;
import java.util.Date;
import org.osmdroid.config.Configuration;

public class TileSourcePolicy {
    public static final int FLAG_NO_BULK = 1;
    public static final int FLAG_NO_PREVENTIVE = 2;
    public static final int FLAG_USER_AGENT_MEANINGFUL = 4;
    public static final int FLAG_USER_AGENT_NORMALIZED = 8;
    private final int mMaxConcurrent;
    private final int mFlags;

    public TileSourcePolicy() {
        this(0, 0);
    }

    public TileSourcePolicy(int pMaxConcurrent, int pFlags) {
        this.mMaxConcurrent = pMaxConcurrent;
        this.mFlags = pFlags;
    }

    public int getMaxConcurrent() {
        return this.mMaxConcurrent;
    }

    public boolean acceptsBulkDownload() {
        return (this.mFlags & 1) == 0;
    }

    private boolean acceptsMeaninglessUserAgent() {
        return (this.mFlags & 4) == 0;
    }

    public boolean normalizesUserAgent() {
        return (this.mFlags & 8) != 0;
    }

    public boolean acceptsPreventive() {
        return (this.mFlags & 2) == 0;
    }

    public boolean acceptsUserAgent(String pUserAgent) {
        if (this.acceptsMeaninglessUserAgent()) {
            return true;
        }
        return pUserAgent != null && pUserAgent.trim().length() > 0 && !pUserAgent.equals("osmdroid");
    }

    public Long getHttpExpiresTime(String pHttpExpiresHeader) {
        block3: {
            if (pHttpExpiresHeader != null && pHttpExpiresHeader.length() > 0) {
                try {
                    Date dateExpires = Configuration.getInstance().getHttpHeaderDateTimeFormat().parse(pHttpExpiresHeader);
                    return dateExpires.getTime();
                }
                catch (Exception ex) {
                    if (!Configuration.getInstance().isDebugMapTileDownloader()) break block3;
                    Log.d((String)"OsmDroid", (String)("Unable to parse expiration tag for tile, server returned " + pHttpExpiresHeader), (Throwable)ex);
                }
            }
        }
        return null;
    }

    public Long getHttpCacheControlDuration(String pHttpCacheControlHeader) {
        block4: {
            if (pHttpCacheControlHeader != null && pHttpCacheControlHeader.length() > 0) {
                try {
                    String[] parts = pHttpCacheControlHeader.split(", ");
                    String maxAge = "max-age=";
                    for (String part : parts) {
                        int pos = part.indexOf("max-age=");
                        if (pos != 0) continue;
                        String durationString = part.substring("max-age=".length());
                        return Long.valueOf(durationString);
                    }
                }
                catch (Exception ex) {
                    if (!Configuration.getInstance().isDebugMapTileDownloader()) break block4;
                    Log.d((String)"OsmDroid", (String)("Unable to parse cache control tag for tile, server returned " + pHttpCacheControlHeader), (Throwable)ex);
                }
            }
        }
        return null;
    }

    public long computeExpirationTime(String pHttpExpiresHeader, String pHttpCacheControlHeader, long pNow) {
        Long override = Configuration.getInstance().getExpirationOverrideDuration();
        if (override != null) {
            return pNow + override;
        }
        long extension = Configuration.getInstance().getExpirationExtendedDuration();
        Long cacheControlDuration = this.getHttpCacheControlDuration(pHttpCacheControlHeader);
        if (cacheControlDuration != null) {
            return pNow + cacheControlDuration * 1000L + extension;
        }
        Long httpExpiresTime = this.getHttpExpiresTime(pHttpExpiresHeader);
        if (httpExpiresTime != null) {
            return httpExpiresTime + extension;
        }
        return pNow + 604800000L + extension;
    }

    public long computeExpirationTime(HttpURLConnection pHttpURLConnection, long pNow) {
        String expires = pHttpURLConnection.getHeaderField("Expires");
        String cacheControl = pHttpURLConnection.getHeaderField("Cache-Control");
        long result = this.computeExpirationTime(expires, cacheControl, pNow);
        if (Configuration.getInstance().isDebugMapTileDownloader()) {
            Log.d((String)"OsmDroid", (String)("computeExpirationTime('" + expires + "','" + cacheControl + "'," + pNow + "=" + result));
        }
        return result;
    }
}

