/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.graphics.Point;
import android.os.Build;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import java.util.LinkedList;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.api.IMapController;
import org.osmdroid.config.Configuration;
import org.osmdroid.events.MapListener;
import org.osmdroid.events.ZoomEvent;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.MyMath;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapView;

public class MapController
implements IMapController,
MapView.OnFirstLayoutListener {
    protected final MapView mMapView;
    private ScaleAnimation mZoomInAnimationOld;
    private ScaleAnimation mZoomOutAnimationOld;
    private double mTargetZoomLevel = 0.0;
    private Animator mCurrentAnimator;
    private ReplayController mReplayController;

    public MapController(MapView mapView) {
        this.mMapView = mapView;
        this.mReplayController = new ReplayController();
        if (!this.mMapView.isLayoutOccurred()) {
            this.mMapView.addOnFirstLayoutListener(this);
        }
        if (Build.VERSION.SDK_INT < 11) {
            ZoomAnimationListener zoomAnimationListener = new ZoomAnimationListener(this);
            this.mZoomInAnimationOld = new ScaleAnimation(1.0f, 2.0f, 1.0f, 2.0f, 1, 0.5f, 1, 0.5f);
            this.mZoomOutAnimationOld = new ScaleAnimation(1.0f, 0.5f, 1.0f, 0.5f, 1, 0.5f, 1, 0.5f);
            this.mZoomInAnimationOld.setDuration((long)Configuration.getInstance().getAnimationSpeedShort());
            this.mZoomOutAnimationOld.setDuration((long)Configuration.getInstance().getAnimationSpeedShort());
            this.mZoomInAnimationOld.setAnimationListener((Animation.AnimationListener)zoomAnimationListener);
            this.mZoomOutAnimationOld.setAnimationListener((Animation.AnimationListener)zoomAnimationListener);
        }
    }

    @Override
    public void onFirstLayout(View v, int left, int top, int right, int bottom) {
        this.mReplayController.replayCalls();
    }

    @Override
    public void zoomToSpan(double latSpan, double lonSpan) {
        double curLonSpan;
        double diffNeededLon;
        if (latSpan <= 0.0 || lonSpan <= 0.0) {
            return;
        }
        if (!this.mMapView.isLayoutOccurred()) {
            this.mReplayController.zoomToSpan(latSpan, lonSpan);
            return;
        }
        BoundingBox bb = this.mMapView.getProjection().getBoundingBox();
        double curZoomLevel = this.mMapView.getProjection().getZoomLevel();
        double curLatSpan = bb.getLatitudeSpan();
        double diffNeededLat = latSpan / curLatSpan;
        double diffNeeded = Math.max(diffNeededLat, diffNeededLon = lonSpan / (curLonSpan = bb.getLongitudeSpan()));
        if (diffNeeded > 1.0) {
            this.mMapView.setZoomLevel(curZoomLevel - (double)MyMath.getNextSquareNumberAbove((float)diffNeeded));
        } else if (diffNeeded < 0.5) {
            this.mMapView.setZoomLevel(curZoomLevel + (double)MyMath.getNextSquareNumberAbove(1.0f / (float)diffNeeded) - 1.0);
        }
    }

    @Override
    public void zoomToSpan(int latSpanE6, int lonSpanE6) {
        this.zoomToSpan((double)latSpanE6 * 1.0E-6, (double)lonSpanE6 * 1.0E-6);
    }

    @Override
    public void animateTo(IGeoPoint point) {
        this.animateTo(point, null, null);
    }

    @Override
    public void animateTo(IGeoPoint point, Double pZoom, Long pSpeed, Float pOrientation) {
        this.animateTo(point, pZoom, pSpeed, pOrientation, null);
    }

    @Override
    public void animateTo(IGeoPoint point, Double pZoom, Long pSpeed, Float pOrientation, Boolean pClockwise) {
        if (!this.mMapView.isLayoutOccurred()) {
            this.mReplayController.animateTo(point, pZoom, pSpeed, pOrientation, pClockwise);
            return;
        }
        if (Build.VERSION.SDK_INT >= 11) {
            GeoPoint currentCenter = new GeoPoint(this.mMapView.getProjection().getCurrentCenter());
            MapAnimatorListener mapAnimatorListener = new MapAnimatorListener(this, this.mMapView.getZoomLevelDouble(), pZoom, currentCenter, point, Float.valueOf(this.mMapView.getMapOrientation()), pOrientation, pClockwise);
            ValueAnimator mapAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            mapAnimator.addListener((Animator.AnimatorListener)mapAnimatorListener);
            mapAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)mapAnimatorListener);
            if (pSpeed == null) {
                mapAnimator.setDuration((long)Configuration.getInstance().getAnimationSpeedDefault());
            } else {
                mapAnimator.setDuration(pSpeed.longValue());
            }
            if (this.mCurrentAnimator != null) {
                this.mCurrentAnimator.end();
            }
            this.mCurrentAnimator = mapAnimator;
            mapAnimator.start();
            return;
        }
        Point p = this.mMapView.getProjection().toPixels(point, null);
        this.animateTo(p.x, p.y);
    }

    @Override
    public void animateTo(IGeoPoint pPoint, Double pZoom, Long pSpeed) {
        this.animateTo(pPoint, pZoom, pSpeed, null);
    }

    @Override
    public void animateTo(int x, int y) {
        if (!this.mMapView.isLayoutOccurred()) {
            this.mReplayController.animateTo(x, y);
            return;
        }
        if (!this.mMapView.isAnimating()) {
            this.mMapView.mIsFlinging = false;
            int xStart = (int)this.mMapView.getMapScrollX();
            int yStart = (int)this.mMapView.getMapScrollY();
            int dx = x - this.mMapView.getWidth() / 2;
            int dy = y - this.mMapView.getHeight() / 2;
            if (dx != xStart || dy != yStart) {
                this.mMapView.getScroller().startScroll(xStart, yStart, dx, dy, Configuration.getInstance().getAnimationSpeedDefault());
                this.mMapView.postInvalidate();
            }
        }
    }

    @Override
    public void scrollBy(int x, int y) {
        this.mMapView.scrollBy(x, y);
    }

    @Override
    public void setCenter(IGeoPoint point) {
        if (!this.mMapView.isLayoutOccurred()) {
            this.mReplayController.setCenter(point);
            return;
        }
        this.mMapView.setExpectedCenter(point);
    }

    @Override
    public void stopPanning() {
        this.mMapView.mIsFlinging = false;
        this.mMapView.getScroller().forceFinished(true);
    }

    @Override
    public void stopAnimation(boolean jumpToTarget) {
        if (!this.mMapView.getScroller().isFinished()) {
            if (jumpToTarget) {
                this.mMapView.mIsFlinging = false;
                this.mMapView.getScroller().abortAnimation();
            } else {
                this.stopPanning();
            }
        }
        if (Build.VERSION.SDK_INT >= 11) {
            Animator currentAnimator = this.mCurrentAnimator;
            if (this.mMapView.mIsAnimating.get()) {
                if (jumpToTarget) {
                    currentAnimator.end();
                } else {
                    currentAnimator.cancel();
                }
            }
        } else if (this.mMapView.mIsAnimating.get()) {
            this.mMapView.clearAnimation();
        }
    }

    @Override
    public int setZoom(int zoomlevel) {
        return (int)this.setZoom((double)zoomlevel);
    }

    @Override
    public double setZoom(double pZoomlevel) {
        return this.mMapView.setZoomLevel(pZoomlevel);
    }

    @Override
    public boolean zoomIn() {
        return this.zoomIn(null);
    }

    @Override
    public boolean zoomIn(Long animationSpeed) {
        return this.zoomTo(this.mMapView.getZoomLevelDouble() + 1.0, animationSpeed);
    }

    @Override
    public boolean zoomInFixing(int xPixel, int yPixel, Long zoomAnimation) {
        return this.zoomToFixing(this.mMapView.getZoomLevelDouble() + 1.0, xPixel, yPixel, zoomAnimation);
    }

    @Override
    public boolean zoomInFixing(int xPixel, int yPixel) {
        return this.zoomInFixing(xPixel, yPixel, null);
    }

    @Override
    public boolean zoomOut(Long animationSpeed) {
        return this.zoomTo(this.mMapView.getZoomLevelDouble() - 1.0, animationSpeed);
    }

    @Override
    public boolean zoomOut() {
        return this.zoomOut(null);
    }

    @Override
    @Deprecated
    public boolean zoomOutFixing(int xPixel, int yPixel) {
        return this.zoomToFixing(this.mMapView.getZoomLevelDouble() - 1.0, xPixel, yPixel, null);
    }

    @Override
    public boolean zoomTo(int zoomLevel) {
        return this.zoomTo(zoomLevel, (Long)null);
    }

    @Override
    public boolean zoomTo(int zoomLevel, Long animationSpeed) {
        return this.zoomTo((double)zoomLevel, animationSpeed);
    }

    @Override
    public boolean zoomToFixing(int zoomLevel, int xPixel, int yPixel, Long zoomAnimationSpeed) {
        return this.zoomToFixing((double)zoomLevel, xPixel, yPixel, zoomAnimationSpeed);
    }

    @Override
    public boolean zoomTo(double pZoomLevel, Long animationSpeed) {
        return this.zoomToFixing(pZoomLevel, this.mMapView.getWidth() / 2, this.mMapView.getHeight() / 2, animationSpeed);
    }

    @Override
    public boolean zoomTo(double pZoomLevel) {
        return this.zoomTo(pZoomLevel, null);
    }

    @Override
    public boolean zoomToFixing(double zoomLevel, int xPixel, int yPixel, Long zoomAnimationSpeed) {
        boolean canZoom;
        zoomLevel = zoomLevel > this.mMapView.getMaxZoomLevel() ? this.mMapView.getMaxZoomLevel() : zoomLevel;
        zoomLevel = zoomLevel < this.mMapView.getMinZoomLevel() ? this.mMapView.getMinZoomLevel() : zoomLevel;
        double currentZoomLevel = this.mMapView.getZoomLevelDouble();
        boolean bl = canZoom = zoomLevel < currentZoomLevel && this.mMapView.canZoomOut() || zoomLevel > currentZoomLevel && this.mMapView.canZoomIn();
        if (!canZoom) {
            return false;
        }
        if (this.mMapView.mIsAnimating.getAndSet(true)) {
            return false;
        }
        ZoomEvent event = null;
        for (MapListener mapListener : this.mMapView.mListners) {
            mapListener.onZoom(event != null ? event : new ZoomEvent(this.mMapView, zoomLevel));
        }
        this.mMapView.setMultiTouchScaleInitPoint(xPixel, yPixel);
        this.mMapView.startAnimation();
        float end = (float)Math.pow(2.0, zoomLevel - currentZoomLevel);
        if (Build.VERSION.SDK_INT >= 11) {
            MapAnimatorListener zoomAnimatorListener = new MapAnimatorListener(this, currentZoomLevel, zoomLevel, null, null, null, null, null);
            ValueAnimator zoomToAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            zoomToAnimator.addListener((Animator.AnimatorListener)zoomAnimatorListener);
            zoomToAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)zoomAnimatorListener);
            if (zoomAnimationSpeed == null) {
                zoomToAnimator.setDuration((long)Configuration.getInstance().getAnimationSpeedShort());
            } else {
                zoomToAnimator.setDuration(zoomAnimationSpeed.longValue());
            }
            this.mCurrentAnimator = zoomToAnimator;
            zoomToAnimator.start();
            return true;
        }
        this.mTargetZoomLevel = zoomLevel;
        if (zoomLevel > currentZoomLevel) {
            this.mMapView.startAnimation((Animation)this.mZoomInAnimationOld);
        } else {
            this.mMapView.startAnimation((Animation)this.mZoomOutAnimationOld);
        }
        ScaleAnimation scaleAnimation = new ScaleAnimation(1.0f, end, 1.0f, end, 1, 0.5f, 1, 0.5f);
        if (zoomAnimationSpeed == null) {
            scaleAnimation.setDuration((long)Configuration.getInstance().getAnimationSpeedShort());
        } else {
            scaleAnimation.setDuration(zoomAnimationSpeed.longValue());
        }
        scaleAnimation.setAnimationListener((Animation.AnimationListener)new ZoomAnimationListener(this));
        return true;
    }

    @Override
    public boolean zoomToFixing(double zoomLevel, int xPixel, int yPixel) {
        return this.zoomToFixing(zoomLevel, xPixel, yPixel, null);
    }

    @Override
    public boolean zoomToFixing(int zoomLevel, int xPixel, int yPixel) {
        return this.zoomToFixing(zoomLevel, xPixel, yPixel, (Long)null);
    }

    protected void onAnimationStart() {
        this.mMapView.mIsAnimating.set(true);
    }

    protected void onAnimationEnd() {
        this.mMapView.mIsAnimating.set(false);
        this.mMapView.resetMultiTouchScale();
        if (Build.VERSION.SDK_INT >= 11) {
            this.mCurrentAnimator = null;
        } else {
            this.mMapView.clearAnimation();
            this.mZoomInAnimationOld.reset();
            this.mZoomOutAnimationOld.reset();
            this.setZoom(this.mTargetZoomLevel);
        }
        this.mMapView.invalidate();
    }

    private class ReplayController {
        private LinkedList<ReplayClass> mReplayList = new LinkedList();

        private ReplayController() {
        }

        public void animateTo(IGeoPoint geoPoint, Double pZoom, Long pSpeed, Float pOrientation, Boolean pClockwise) {
            this.mReplayList.add(new ReplayClass(ReplayType.AnimateToGeoPoint, null, geoPoint, pZoom, pSpeed, pOrientation, pClockwise));
        }

        public void animateTo(int x, int y) {
            this.mReplayList.add(new ReplayClass(ReplayType.AnimateToPoint, new Point(x, y), null));
        }

        public void setCenter(IGeoPoint geoPoint) {
            this.mReplayList.add(new ReplayClass(ReplayType.SetCenterPoint, null, geoPoint));
        }

        public void zoomToSpan(int x, int y) {
            this.mReplayList.add(new ReplayClass(ReplayType.ZoomToSpanPoint, new Point(x, y), null));
        }

        public void zoomToSpan(double x, double y) {
            this.mReplayList.add(new ReplayClass(ReplayType.ZoomToSpanPoint, new Point((int)(x * 1000000.0), (int)(y * 1000000.0)), null));
        }

        public void replayCalls() {
            for (ReplayClass replay : this.mReplayList) {
                switch (replay.mReplayType) {
                    case AnimateToGeoPoint: {
                        if (replay.mGeoPoint == null) break;
                        MapController.this.animateTo(replay.mGeoPoint, replay.mZoom, replay.mSpeed, replay.mOrientation, replay.mClockwise);
                        break;
                    }
                    case AnimateToPoint: {
                        if (replay.mPoint == null) break;
                        MapController.this.animateTo(((ReplayClass)replay).mPoint.x, ((ReplayClass)replay).mPoint.y);
                        break;
                    }
                    case SetCenterPoint: {
                        if (replay.mGeoPoint == null) break;
                        MapController.this.setCenter(replay.mGeoPoint);
                        break;
                    }
                    case ZoomToSpanPoint: {
                        if (replay.mPoint == null) break;
                        MapController.this.zoomToSpan(((ReplayClass)replay).mPoint.x, ((ReplayClass)replay).mPoint.y);
                    }
                }
            }
            this.mReplayList.clear();
        }

        private class ReplayClass {
            private ReplayType mReplayType;
            private Point mPoint;
            private IGeoPoint mGeoPoint;
            private final Long mSpeed;
            private final Double mZoom;
            private final Float mOrientation;
            private final Boolean mClockwise;

            public ReplayClass(ReplayType mReplayType, Point mPoint, IGeoPoint mGeoPoint) {
                this(mReplayType, mPoint, mGeoPoint, null, null, null, null);
            }

            public ReplayClass(ReplayType pReplayType, Point pPoint, IGeoPoint pGeoPoint, Double pZoom, Long pSpeed, Float pOrientation, Boolean pClockwise) {
                this.mReplayType = pReplayType;
                this.mPoint = pPoint;
                this.mGeoPoint = pGeoPoint;
                this.mSpeed = pSpeed;
                this.mZoom = pZoom;
                this.mOrientation = pOrientation;
                this.mClockwise = pClockwise;
            }
        }
    }

    private static enum ReplayType {
        ZoomToSpanPoint,
        AnimateToPoint,
        AnimateToGeoPoint,
        SetCenterPoint;

    }

    protected static class ZoomAnimationListener
    implements Animation.AnimationListener {
        private MapController mMapController;

        public ZoomAnimationListener(MapController mapController) {
            this.mMapController = mapController;
        }

        public void onAnimationStart(Animation animation) {
            this.mMapController.onAnimationStart();
        }

        public void onAnimationEnd(Animation animation) {
            this.mMapController.onAnimationEnd();
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }

    @TargetApi(value=11)
    private static class MapAnimatorListener
    implements Animator.AnimatorListener,
    ValueAnimator.AnimatorUpdateListener {
        private final GeoPoint mCenter = new GeoPoint(0.0, 0.0);
        private final MapController mMapController;
        private final Double mZoomStart;
        private final Double mZoomEnd;
        private final IGeoPoint mCenterStart;
        private final IGeoPoint mCenterEnd;
        private final Float mOrientationStart;
        private final Float mOrientationSpan;

        public MapAnimatorListener(MapController pMapController, Double pZoomStart, Double pZoomEnd, IGeoPoint pCenterStart, IGeoPoint pCenterEnd, Float pOrientationStart, Float pOrientationEnd, Boolean pClockwise) {
            this.mMapController = pMapController;
            this.mZoomStart = pZoomStart;
            this.mZoomEnd = pZoomEnd;
            this.mCenterStart = pCenterStart;
            this.mCenterEnd = pCenterEnd;
            if (pOrientationEnd == null) {
                this.mOrientationStart = null;
                this.mOrientationSpan = null;
            } else {
                this.mOrientationStart = pOrientationStart;
                this.mOrientationSpan = Float.valueOf((float)MyMath.getAngleDifference(this.mOrientationStart.floatValue(), pOrientationEnd.floatValue(), pClockwise));
            }
        }

        public void onAnimationStart(Animator animator) {
            this.mMapController.onAnimationStart();
        }

        public void onAnimationEnd(Animator animator) {
            this.mMapController.onAnimationEnd();
        }

        public void onAnimationCancel(Animator animator) {
            this.mMapController.onAnimationEnd();
        }

        public void onAnimationRepeat(Animator animator) {
        }

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            float value = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            if (this.mZoomEnd != null) {
                double zoom = this.mZoomStart + (this.mZoomEnd - this.mZoomStart) * (double)value;
                this.mMapController.mMapView.setZoomLevel(zoom);
            }
            if (this.mOrientationSpan != null) {
                float orientation = this.mOrientationStart.floatValue() + this.mOrientationSpan.floatValue() * value;
                this.mMapController.mMapView.setMapOrientation(orientation);
            }
            if (this.mCenterEnd != null) {
                MapController mapController = this.mMapController;
                TileSystem tileSystem = mapController.mMapView.getTileSystem();
                double longitudeStart = tileSystem.cleanLongitude(this.mCenterStart.getLongitude());
                double longitudeEnd = tileSystem.cleanLongitude(this.mCenterEnd.getLongitude());
                double longitude = tileSystem.cleanLongitude(longitudeStart + (longitudeEnd - longitudeStart) * (double)value);
                double latitudeStart = tileSystem.cleanLatitude(this.mCenterStart.getLatitude());
                double latitudeEnd = tileSystem.cleanLatitude(this.mCenterEnd.getLatitude());
                double latitude = tileSystem.cleanLatitude(latitudeStart + (latitudeEnd - latitudeStart) * (double)value);
                this.mCenter.setCoords(latitude, longitude);
                this.mMapController.mMapView.setExpectedCenter(this.mCenter);
            }
            this.mMapController.mMapView.invalidate();
        }
    }
}

