/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.util;

import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import java.util.List;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.PointL;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;

public class PathProjection {
    public static Path toPixels(Projection projection, List<? extends GeoPoint> in, Path reuse) {
        return PathProjection.toPixels(projection, in, reuse, true);
    }

    public static Path toPixels(Projection projection, List<? extends GeoPoint> in, Path reuse, boolean doGudermann) throws IllegalArgumentException {
        if (in.size() < 2) {
            throw new IllegalArgumentException("List of GeoPoints needs to be at least 2.");
        }
        Path out = reuse != null ? reuse : new Path();
        out.incReserve(in.size());
        TileSystem tileSystem = MapView.getTileSystem();
        boolean first = true;
        for (GeoPoint geoPoint : in) {
            Point underGeopointTileCoords = new Point();
            double mapSize = TileSystem.MapSize(projection.getZoomLevel());
            PointL mercator = tileSystem.getMercatorFromGeo(geoPoint.getLatitude(), geoPoint.getLongitude(), mapSize, null, true);
            underGeopointTileCoords.x = projection.getTileFromMercator(mercator.x);
            underGeopointTileCoords.y = projection.getTileFromMercator(mercator.y);
            PointL upperRight = new PointL(projection.getMercatorFromTile(underGeopointTileCoords.x), projection.getMercatorFromTile(underGeopointTileCoords.y));
            PointL lowerLeft = new PointL(projection.getMercatorFromTile(underGeopointTileCoords.x + TileSystem.getTileSize()), projection.getMercatorFromTile(underGeopointTileCoords.y + TileSystem.getTileSize()));
            GeoPoint neGeoPoint = tileSystem.getGeoFromMercator(upperRight.x, upperRight.y, mapSize, null, true, true);
            GeoPoint swGeoPoint = tileSystem.getGeoFromMercator(lowerLeft.x, lowerLeft.y, mapSize, null, true, true);
            BoundingBox bb = new BoundingBox(neGeoPoint.getLatitude(), neGeoPoint.getLongitude(), swGeoPoint.getLatitude(), swGeoPoint.getLongitude());
            PointF relativePositionInCenterMapTile = doGudermann && projection.getZoomLevel() < 7.0 ? bb.getRelativePositionOfGeoPointInBoundingBoxWithExactGudermannInterpolation(geoPoint.getLatitude(), geoPoint.getLongitude(), null) : bb.getRelativePositionOfGeoPointInBoundingBoxWithLinearInterpolation(geoPoint.getLatitude(), geoPoint.getLongitude(), null);
            Rect screenRect = projection.getScreenRect();
            Point centerMapTileCoords = new Point(projection.getTileFromMercator(screenRect.centerX()), projection.getTileFromMercator(screenRect.centerY()));
            PointL upperLeftCornerOfCenterMapTile = new PointL(projection.getMercatorFromTile(centerMapTileCoords.x), projection.getMercatorFromTile(centerMapTileCoords.y));
            int tileDiffX = centerMapTileCoords.x - underGeopointTileCoords.x;
            int tileDiffY = centerMapTileCoords.y - underGeopointTileCoords.y;
            long underGeopointTileScreenLeft = upperLeftCornerOfCenterMapTile.x - (long)(TileSystem.getTileSize() * tileDiffX);
            long underGeopointTileScreenTop = upperLeftCornerOfCenterMapTile.y - (long)(TileSystem.getTileSize() * tileDiffY);
            long x = underGeopointTileScreenLeft + (long)(relativePositionInCenterMapTile.x * (float)TileSystem.getTileSize());
            long y = underGeopointTileScreenTop + (long)(relativePositionInCenterMapTile.y * (float)TileSystem.getTileSize());
            if (first) {
                out.moveTo((float)x, (float)y);
            } else {
                out.lineTo((float)x, (float)y);
            }
            first = false;
        }
        return out;
    }
}

