/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.os.Build;
import android.view.MotionEvent;
import android.view.animation.LinearInterpolator;
import org.osmdroid.views.CustomZoomButtonsDisplay;
import org.osmdroid.views.MapView;

public class CustomZoomButtonsController {
    private final Object mThreadSync = new Object();
    private final MapView mMapView;
    private final ValueAnimator mFadeOutAnimation;
    private CustomZoomButtonsDisplay mDisplay;
    private OnZoomListener mListener;
    private boolean mZoomInEnabled;
    private boolean mZoomOutEnabled;
    private float mAlpha01;
    private boolean detached;
    private Visibility mVisibility = Visibility.NEVER;
    private int mFadeOutAnimationDurationInMillis = 500;
    private int mShowDelayInMillis = 3500;
    private boolean mJustActivated;
    private long mLatestActivation;
    private Thread mThread;
    private final Runnable mRunnable;

    public CustomZoomButtonsController(MapView pMapView) {
        this.mMapView = pMapView;
        this.mDisplay = new CustomZoomButtonsDisplay(this.mMapView);
        if (Build.VERSION.SDK_INT >= 11) {
            this.mFadeOutAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.mFadeOutAnimation.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mFadeOutAnimation.setDuration((long)this.mFadeOutAnimationDurationInMillis);
            this.mFadeOutAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    if (CustomZoomButtonsController.this.detached) {
                        CustomZoomButtonsController.this.mFadeOutAnimation.cancel();
                        return;
                    }
                    CustomZoomButtonsController.this.mAlpha01 = 1.0f - ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    CustomZoomButtonsController.this.invalidate();
                }
            });
        } else {
            this.mFadeOutAnimation = null;
        }
        this.mRunnable = new Runnable(){

            @Override
            public void run() {
                long pending;
                while ((pending = CustomZoomButtonsController.this.mLatestActivation + (long)CustomZoomButtonsController.this.mShowDelayInMillis - CustomZoomButtonsController.this.nowInMillis()) > 0L) {
                    try {
                        Thread.sleep(pending, 0);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                CustomZoomButtonsController.this.startFadeOut();
            }
        };
    }

    public void setZoomInEnabled(boolean pEnabled) {
        this.mZoomInEnabled = pEnabled;
    }

    public void setZoomOutEnabled(boolean pEnabled) {
        this.mZoomOutEnabled = pEnabled;
    }

    public CustomZoomButtonsDisplay getDisplay() {
        return this.mDisplay;
    }

    public void setOnZoomListener(OnZoomListener pListener) {
        this.mListener = pListener;
    }

    public void setVisibility(Visibility pVisibility) {
        this.mVisibility = pVisibility;
        switch (this.mVisibility) {
            case ALWAYS: {
                this.mAlpha01 = 1.0f;
                break;
            }
            case NEVER: 
            case SHOW_AND_FADEOUT: {
                this.mAlpha01 = 0.0f;
            }
        }
    }

    public void setShowFadeOutDelays(int pShowDelayInMillis, int pFadeOutAnimationDurationInMillis) {
        this.mShowDelayInMillis = pShowDelayInMillis;
        this.mFadeOutAnimationDurationInMillis = pFadeOutAnimationDurationInMillis;
    }

    public void onDetach() {
        this.detached = true;
        this.stopFadeOut();
    }

    private long nowInMillis() {
        return System.currentTimeMillis();
    }

    private void startFadeOut() {
        if (this.detached) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 11) {
            this.mFadeOutAnimation.setStartDelay(0L);
            this.mMapView.post(new Runnable(){

                @Override
                public void run() {
                    CustomZoomButtonsController.this.mFadeOutAnimation.start();
                }
            });
        } else {
            this.mAlpha01 = 0.0f;
            this.invalidate();
        }
    }

    private void stopFadeOut() {
        if (Build.VERSION.SDK_INT >= 11) {
            this.mFadeOutAnimation.cancel();
        }
    }

    private void invalidate() {
        if (this.detached) {
            return;
        }
        this.mMapView.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        if (this.detached) {
            return;
        }
        if (this.mVisibility != Visibility.SHOW_AND_FADEOUT) {
            return;
        }
        float alpha = this.mAlpha01;
        this.mJustActivated = !this.mJustActivated ? alpha == 0.0f : false;
        this.stopFadeOut();
        this.mAlpha01 = 1.0f;
        this.mLatestActivation = this.nowInMillis();
        this.invalidate();
        if (this.mThread == null || this.mThread.getState() == Thread.State.TERMINATED) {
            Object object = this.mThreadSync;
            synchronized (object) {
                if (this.mThread == null || this.mThread.getState() == Thread.State.TERMINATED) {
                    this.mThread = new Thread(this.mRunnable);
                    this.mThread.start();
                }
            }
        }
    }

    private boolean checkJustActivated() {
        if (this.mJustActivated) {
            this.mJustActivated = false;
            return true;
        }
        return false;
    }

    private boolean isTouched(MotionEvent pMotionEvent) {
        if (this.mAlpha01 == 0.0f) {
            return false;
        }
        if (this.checkJustActivated()) {
            return false;
        }
        if (this.mZoomInEnabled && this.mDisplay.isTouchedRotated(pMotionEvent, true)) {
            if (this.mListener != null) {
                this.mListener.onZoom(true);
            }
            return true;
        }
        if (this.mZoomOutEnabled && this.mDisplay.isTouchedRotated(pMotionEvent, false)) {
            if (this.mListener != null) {
                this.mListener.onZoom(false);
            }
            return true;
        }
        return false;
    }

    public boolean onSingleTapConfirmed(MotionEvent pMotionEvent) {
        return this.isTouched(pMotionEvent);
    }

    public boolean onLongPress(MotionEvent pMotionEvent) {
        return this.isTouched(pMotionEvent);
    }

    public void draw(Canvas pCanvas) {
        this.mDisplay.draw(pCanvas, this.mAlpha01, this.mZoomInEnabled, this.mZoomOutEnabled);
    }

    public static interface OnZoomListener {
        public void onVisibilityChanged(boolean var1);

        public void onZoom(boolean var1);
    }

    public static enum Visibility {
        ALWAYS,
        NEVER,
        SHOW_AND_FADEOUT;

    }
}

