/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import android.graphics.Rect;

public class RectL {
    public long left;
    public long top;
    public long right;
    public long bottom;

    public RectL() {
    }

    public RectL(long pLeft, long pTop, long pRight, long pBottom) {
        this.set(pLeft, pTop, pRight, pBottom);
    }

    public RectL(RectL pOther) {
        this.set(pOther);
    }

    public void set(long pLeft, long pTop, long pRight, long pBottom) {
        this.left = pLeft;
        this.top = pTop;
        this.right = pRight;
        this.bottom = pBottom;
    }

    public void set(RectL pOther) {
        this.left = pOther.left;
        this.top = pOther.top;
        this.right = pOther.right;
        this.bottom = pOther.bottom;
    }

    public void union(long x, long y) {
        if (x < this.left) {
            this.left = x;
        } else if (x > this.right) {
            this.right = x;
        }
        if (y < this.top) {
            this.top = y;
        } else if (y > this.bottom) {
            this.bottom = y;
        }
    }

    public static boolean intersects(RectL a, RectL b) {
        return a.left < b.right && b.left < a.right && a.top < b.bottom && b.top < a.bottom;
    }

    public boolean contains(long x, long y) {
        return this.left < this.right && this.top < this.bottom && x >= this.left && x < this.right && y >= this.top && y < this.bottom;
    }

    public void inset(long dx, long dy) {
        this.left += dx;
        this.top += dy;
        this.right -= dx;
        this.bottom -= dy;
    }

    public final long width() {
        return this.right - this.left;
    }

    public final long height() {
        return this.bottom - this.top;
    }

    public String toString() {
        return "RectL(" + this.left + ", " + this.top + " - " + this.right + ", " + this.bottom + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RectL r = (RectL)o;
        return this.left == r.left && this.top == r.top && this.right == r.right && this.bottom == r.bottom;
    }

    public int hashCode() {
        long result = this.left;
        result = 31L * result + this.top;
        result = 31L * result + this.right;
        result = 31L * result + this.bottom;
        return (int)(result % Integer.MAX_VALUE);
    }

    public static RectL getBounds(RectL pIn, long pCenterX, long pCenterY, double pDegrees, RectL pReuse) {
        long outputY;
        RectL out;
        RectL rectL = out = pReuse != null ? pReuse : new RectL();
        if (pDegrees == 0.0) {
            out.top = pIn.top;
            out.left = pIn.left;
            out.bottom = pIn.bottom;
            out.right = pIn.right;
            return out;
        }
        double radians = pDegrees * Math.PI / 180.0;
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        long inputX = pIn.left;
        long inputY = pIn.top;
        long outputX = RectL.getRotatedX(inputX, inputY, pCenterX, pCenterY, cos, sin);
        out.top = out.bottom = (outputY = RectL.getRotatedY(inputX, inputY, pCenterX, pCenterY, cos, sin));
        out.left = out.right = outputX;
        inputX = pIn.right;
        inputY = pIn.top;
        outputX = RectL.getRotatedX(inputX, inputY, pCenterX, pCenterY, cos, sin);
        outputY = RectL.getRotatedY(inputX, inputY, pCenterX, pCenterY, cos, sin);
        if (out.top > outputY) {
            out.top = outputY;
        }
        if (out.bottom < outputY) {
            out.bottom = outputY;
        }
        if (out.left > outputX) {
            out.left = outputX;
        }
        if (out.right < outputX) {
            out.right = outputX;
        }
        inputX = pIn.right;
        inputY = pIn.bottom;
        outputX = RectL.getRotatedX(inputX, inputY, pCenterX, pCenterY, cos, sin);
        outputY = RectL.getRotatedY(inputX, inputY, pCenterX, pCenterY, cos, sin);
        if (out.top > outputY) {
            out.top = outputY;
        }
        if (out.bottom < outputY) {
            out.bottom = outputY;
        }
        if (out.left > outputX) {
            out.left = outputX;
        }
        if (out.right < outputX) {
            out.right = outputX;
        }
        inputX = pIn.left;
        inputY = pIn.bottom;
        outputX = RectL.getRotatedX(inputX, inputY, pCenterX, pCenterY, cos, sin);
        outputY = RectL.getRotatedY(inputX, inputY, pCenterX, pCenterY, cos, sin);
        if (out.top > outputY) {
            out.top = outputY;
        }
        if (out.bottom < outputY) {
            out.bottom = outputY;
        }
        if (out.left > outputX) {
            out.left = outputX;
        }
        if (out.right < outputX) {
            out.right = outputX;
        }
        return out;
    }

    public static Rect getBounds(Rect pIn, int pCenterX, int pCenterY, double pDegrees, Rect pReuse) {
        int outputY;
        Rect out;
        Rect rect = out = pReuse != null ? pReuse : new Rect();
        if (pDegrees == 0.0) {
            out.top = pIn.top;
            out.left = pIn.left;
            out.bottom = pIn.bottom;
            out.right = pIn.right;
            return out;
        }
        double radians = pDegrees * Math.PI / 180.0;
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        int inputX = pIn.left;
        int inputY = pIn.top;
        int outputX = (int)RectL.getRotatedX(inputX, inputY, pCenterX, pCenterY, cos, sin);
        out.top = out.bottom = (outputY = (int)RectL.getRotatedY(inputX, inputY, pCenterX, pCenterY, cos, sin));
        out.left = out.right = outputX;
        inputX = pIn.right;
        inputY = pIn.top;
        outputX = (int)RectL.getRotatedX(inputX, inputY, pCenterX, pCenterY, cos, sin);
        outputY = (int)RectL.getRotatedY(inputX, inputY, pCenterX, pCenterY, cos, sin);
        if (out.top > outputY) {
            out.top = outputY;
        }
        if (out.bottom < outputY) {
            out.bottom = outputY;
        }
        if (out.left > outputX) {
            out.left = outputX;
        }
        if (out.right < outputX) {
            out.right = outputX;
        }
        inputX = pIn.right;
        inputY = pIn.bottom;
        outputX = (int)RectL.getRotatedX(inputX, inputY, pCenterX, pCenterY, cos, sin);
        outputY = (int)RectL.getRotatedY(inputX, inputY, pCenterX, pCenterY, cos, sin);
        if (out.top > outputY) {
            out.top = outputY;
        }
        if (out.bottom < outputY) {
            out.bottom = outputY;
        }
        if (out.left > outputX) {
            out.left = outputX;
        }
        if (out.right < outputX) {
            out.right = outputX;
        }
        inputX = pIn.left;
        inputY = pIn.bottom;
        outputX = (int)RectL.getRotatedX(inputX, inputY, pCenterX, pCenterY, cos, sin);
        outputY = (int)RectL.getRotatedY(inputX, inputY, pCenterX, pCenterY, cos, sin);
        if (out.top > outputY) {
            out.top = outputY;
        }
        if (out.bottom < outputY) {
            out.bottom = outputY;
        }
        if (out.left > outputX) {
            out.left = outputX;
        }
        if (out.right < outputX) {
            out.right = outputX;
        }
        return out;
    }

    public static long getRotatedX(long pX, long pY, double pDegrees, long pCenterX, long pCenterY) {
        if (pDegrees == 0.0) {
            return pX;
        }
        double radians = pDegrees * Math.PI / 180.0;
        return RectL.getRotatedX(pX, pY, pCenterX, pCenterY, Math.cos(radians), Math.sin(radians));
    }

    public static long getRotatedY(long pX, long pY, double pDegrees, long pCenterX, long pCenterY) {
        if (pDegrees == 0.0) {
            return pY;
        }
        double radians = pDegrees * Math.PI / 180.0;
        return RectL.getRotatedY(pX, pY, pCenterX, pCenterY, Math.cos(radians), Math.sin(radians));
    }

    public static long getRotatedX(long pX, long pY, long pCenterX, long pCenterY, double pCos, double pSin) {
        return pCenterX + Math.round((double)(pX - pCenterX) * pCos - (double)(pY - pCenterY) * pSin);
    }

    public static long getRotatedY(long pX, long pY, long pCenterX, long pCenterY, double pCos, double pSin) {
        return pCenterY + Math.round((double)(pX - pCenterX) * pSin + (double)(pY - pCenterY) * pCos);
    }

    public void offset(long pDx, long pDy) {
        this.left += pDx;
        this.top += pDy;
        this.right += pDx;
        this.bottom += pDy;
    }

    public void union(long pLeft, long pTop, long pRight, long pBottom) {
        if (pLeft < pRight && pTop < pBottom) {
            if (this.left < this.right && this.top < this.bottom) {
                if (this.left > pLeft) {
                    this.left = pLeft;
                }
                if (this.top > pTop) {
                    this.top = pTop;
                }
                if (this.right < pRight) {
                    this.right = pRight;
                }
                if (this.bottom < pBottom) {
                    this.bottom = pBottom;
                }
            } else {
                this.left = pLeft;
                this.top = pTop;
                this.right = pRight;
                this.bottom = pBottom;
            }
        }
    }

    public void union(RectL pRect) {
        this.union(pRect.left, pRect.top, pRect.right, pRect.bottom);
    }
}

