/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.drawable.Drawable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;
import org.osmdroid.tileprovider.IMapTileProviderCallback;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.util.MapTileContainer;
import org.osmdroid.util.MapTileIndex;
import org.osmdroid.util.TileSystem;

public class MapTileProviderArray
extends MapTileProviderBase
implements MapTileContainer {
    private final Map<Long, Integer> mWorking = new HashMap<Long, Integer>();
    private IRegisterReceiver mRegisterReceiver = null;
    protected final List<MapTileModuleProviderBase> mTileProviderList;
    private static final int WORKING_STATUS_STARTED = 0;
    private static final int WORKING_STATUS_FOUND = 1;

    protected MapTileProviderArray(ITileSource pTileSource, IRegisterReceiver pRegisterReceiver) {
        this(pTileSource, pRegisterReceiver, new MapTileModuleProviderBase[0]);
    }

    public MapTileProviderArray(ITileSource pTileSource, IRegisterReceiver aRegisterReceiver, MapTileModuleProviderBase[] pTileProviderArray) {
        super(pTileSource);
        this.mRegisterReceiver = aRegisterReceiver;
        this.mTileProviderList = new ArrayList<MapTileModuleProviderBase>();
        Collections.addAll(this.mTileProviderList, pTileProviderArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() {
        Object object = this.mTileProviderList;
        synchronized (object) {
            for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
                tileProvider.detach();
            }
        }
        object = this.mWorking;
        synchronized (object) {
            this.mWorking.clear();
        }
        if (this.mRegisterReceiver != null) {
            this.mRegisterReceiver.destroy();
            this.mRegisterReceiver = null;
        }
        super.detach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(long pTileIndex) {
        Map<Long, Integer> map = this.mWorking;
        synchronized (map) {
            return this.mWorking.containsKey(pTileIndex);
        }
    }

    protected boolean isDowngradedMode() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Drawable getMapTile(long pMapTileIndex) {
        Drawable tile = this.mTileCache.getMapTile(pMapTileIndex);
        if (tile != null) {
            if (ExpirableBitmapDrawable.getState(tile) == -1) {
                return tile;
            }
            if (this.isDowngradedMode()) {
                return tile;
            }
        }
        Map<Long, Integer> map = this.mWorking;
        synchronized (map) {
            if (this.mWorking.containsKey(pMapTileIndex)) {
                return tile;
            }
            this.mWorking.put(pMapTileIndex, 0);
        }
        MapTileRequestState state = new MapTileRequestState(pMapTileIndex, this.mTileProviderList, (IMapTileProviderCallback)this);
        this.runAsyncNextProvider(state);
        return tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(long pMapTileIndex) {
        Map<Long, Integer> map = this.mWorking;
        synchronized (map) {
            this.mWorking.remove(pMapTileIndex);
        }
    }

    @Override
    public void mapTileRequestCompleted(MapTileRequestState aState, Drawable aDrawable) {
        super.mapTileRequestCompleted(aState, aDrawable);
        this.remove(aState.getMapTile());
    }

    @Override
    public void mapTileRequestFailed(MapTileRequestState aState) {
        this.runAsyncNextProvider(aState);
    }

    @Override
    public void mapTileRequestFailedExceedsMaxQueueSize(MapTileRequestState aState) {
        super.mapTileRequestFailed(aState);
        this.remove(aState.getMapTile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapTileRequestExpiredTile(MapTileRequestState aState, Drawable aDrawable) {
        super.mapTileRequestExpiredTile(aState, aDrawable);
        Map<Long, Integer> map = this.mWorking;
        synchronized (map) {
            this.mWorking.put(aState.getMapTile(), 1);
        }
        this.runAsyncNextProvider(aState);
    }

    @Override
    public IFilesystemCache getTileWriter() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getQueueSize() {
        Map<Long, Integer> map = this.mWorking;
        synchronized (map) {
            return this.mWorking.size();
        }
    }

    protected MapTileModuleProviderBase findNextAppropriateProvider(MapTileRequestState aState) {
        MapTileModuleProviderBase provider;
        boolean providerDoesntExist = false;
        boolean providerCantGetDataConnection = false;
        boolean providerCantServiceZoomlevel = false;
        do {
            if ((provider = aState.getNextProvider()) == null) continue;
            providerDoesntExist = !this.getProviderExists(provider);
            providerCantGetDataConnection = !this.useDataConnection() && provider.getUsesDataConnection();
            int zoomLevel = MapTileIndex.getZoom(aState.getMapTile());
            boolean bl = providerCantServiceZoomlevel = zoomLevel > provider.getMaximumZoomLevel() || zoomLevel < provider.getMinimumZoomLevel();
        } while (provider != null && (providerDoesntExist || providerCantGetDataConnection || providerCantServiceZoomlevel));
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAsyncNextProvider(MapTileRequestState pState) {
        Integer status;
        MapTileModuleProviderBase nextProvider = this.findNextAppropriateProvider(pState);
        if (nextProvider != null) {
            nextProvider.loadMapTileAsync(pState);
            return;
        }
        Map<Long, Integer> map = this.mWorking;
        synchronized (map) {
            status = this.mWorking.get(pState.getMapTile());
        }
        if (status != null && status == 0) {
            super.mapTileRequestFailed(pState);
        }
        this.remove(pState.getMapTile());
    }

    public boolean getProviderExists(MapTileModuleProviderBase provider) {
        return this.mTileProviderList.contains(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMinimumZoomLevel() {
        int result = TileSystem.getMaximumZoomLevel();
        List<MapTileModuleProviderBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
                if (tileProvider.getMinimumZoomLevel() >= result) continue;
                result = tileProvider.getMinimumZoomLevel();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaximumZoomLevel() {
        int result = 0;
        List<MapTileModuleProviderBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
                if (tileProvider.getMaximumZoomLevel() <= result) continue;
                result = tileProvider.getMaximumZoomLevel();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTileSource(ITileSource aTileSource) {
        super.setTileSource(aTileSource);
        List<MapTileModuleProviderBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
                tileProvider.setTileSource(aTileSource);
                this.clearTileCache();
            }
        }
    }
}

