/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.drawable.Drawable;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.tileprovider.MapTileCache;
import org.osmdroid.tileprovider.modules.CantContinueException;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.util.GarbageCollector;
import org.osmdroid.util.MapTileList;
import org.osmdroid.util.MapTileListComputer;

public class MapTilePreCache {
    private final List<MapTileModuleProviderBase> mProviders = new ArrayList<MapTileModuleProviderBase>();
    private final MapTileList mTiles = new MapTileList();
    private int mTilesIndex;
    private final MapTileCache mCache;
    private final GarbageCollector mGC = new GarbageCollector(new Runnable(){

        @Override
        public void run() {
            long next;
            while ((next = MapTilePreCache.this.next()) != -1L) {
                MapTilePreCache.this.search(next);
            }
        }
    });

    public MapTilePreCache(MapTileCache pCache) {
        this.mCache = pCache;
    }

    public void addProvider(MapTileModuleProviderBase pProvider) {
        this.mProviders.add(pProvider);
    }

    public void fill() {
        this.refresh();
        this.mGC.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        MapTileList mapTileList = this.mTiles;
        synchronized (mapTileList) {
            this.mTiles.clear();
            this.mTilesIndex = 0;
            for (MapTileListComputer computer : this.mCache.getProtectedTileComputers()) {
                computer.computeFromSource(this.mCache.getMapTileList(), this.mTiles);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long next() {
        long index;
        Drawable drawable;
        do {
            MapTileList mapTileList = this.mTiles;
            synchronized (mapTileList) {
                if (this.mTilesIndex >= this.mTiles.getSize()) {
                    return -1L;
                }
                index = this.mTiles.get(this.mTilesIndex++);
            }
        } while ((drawable = this.mCache.getMapTile(index)) != null);
        return index;
    }

    private void search(long pMapTileIndex) {
        for (MapTileModuleProviderBase provider : this.mProviders) {
            try {
                Drawable drawable = provider.getTileLoader().loadTile(pMapTileIndex);
                if (drawable == null) continue;
                this.mCache.putTile(pMapTileIndex, drawable);
                return;
            }
            catch (CantContinueException cantContinueException) {
            }
        }
    }
}

