/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.Overlay;

public class GroundOverlay2
extends Overlay {
    private float mLonL;
    private float mLatU;
    private float mLonR;
    private float mLatD;
    protected Bitmap mImage;
    protected float mBearing = 0.0f;
    protected float mTransparency = 0.0f;
    private Matrix mStretchToFitTransformationMatrix = new Matrix();

    public void setImage(Bitmap image) {
        this.mImage = image;
    }

    public Bitmap getImage() {
        return this.mImage;
    }

    public void setPosition(GeoPoint UL, GeoPoint RD) {
        this.mLatU = (float)UL.getLatitude();
        this.mLonL = (float)UL.getLongitude();
        this.mLatD = (float)RD.getLatitude();
        this.mLonR = (float)RD.getLongitude();
    }

    public float getBearing() {
        return this.mBearing;
    }

    public void setBearing(float bearing) {
        this.mBearing = bearing;
    }

    public void setTransparency(float transparency) {
        this.mTransparency = transparency;
    }

    public float getTransparency() {
        return this.mTransparency;
    }

    @Override
    public void draw(Canvas canvas, MapView mapView, boolean shadow) {
        if (null == this.mImage || shadow) {
            return;
        }
        Projection pj = mapView.getProjection();
        long x0 = pj.getLongPixelXFromLongitude(this.mLonL);
        long y0 = pj.getLongPixelYFromLatitude(this.mLatU);
        long x1 = pj.getLongPixelXFromLongitude(this.mLonR);
        long y1 = pj.getLongPixelYFromLatitude(this.mLatD);
        float widthOnTheMap = x1 - x0;
        float heightOnTheMap = y1 - y0;
        float scaleX = widthOnTheMap / (float)this.mImage.getWidth();
        float scaleY = heightOnTheMap / (float)this.mImage.getHeight();
        this.setupScalingThenTranslatingMatrix(scaleX, scaleY, x0, y0);
        Paint paint = new Paint();
        paint.setAlpha(255 - (int)(this.mTransparency * 255.0f));
        canvas.drawBitmap(this.mImage, this.mStretchToFitTransformationMatrix, paint);
    }

    private void setupScalingThenTranslatingMatrix(float scaleX, float scaleY, long x0, long y0) {
        this.mStretchToFitTransformationMatrix.setScale(scaleX, scaleY);
        this.mStretchToFitTransformationMatrix.postTranslate((float)x0, (float)y0);
    }
}

