/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.milestones;

import org.osmdroid.util.Distance;
import org.osmdroid.views.overlay.milestones.MilestoneLister;
import org.osmdroid.views.overlay.milestones.MilestoneStep;

public class MilestonePixelDistanceLister
extends MilestoneLister {
    private final double mNbPixelsInit;
    private final double mNbPixelsRecurrence;
    private double mDistance;

    public MilestonePixelDistanceLister(double pNbPixelsInit, double pNbPixelsRecurrence) {
        this.mNbPixelsInit = pNbPixelsInit;
        this.mNbPixelsRecurrence = pNbPixelsRecurrence;
    }

    @Override
    public void init() {
        super.init();
        this.mDistance = this.mNbPixelsRecurrence - this.mNbPixelsInit;
    }

    @Override
    protected void add(long x0, long y0, long x1, long y1) {
        double currentDistance = Math.sqrt(Distance.getSquaredDistanceToPoint(x0, y0, x1, y1));
        if (currentDistance == 0.0) {
            return;
        }
        double orientation = MilestonePixelDistanceLister.getOrientation(x0, y0, x1, y1);
        double x = x0;
        double y = y0;
        while (true) {
            double latestMilestone;
            double neededForNext;
            if (currentDistance < (neededForNext = (latestMilestone = Math.floor(this.mDistance / this.mNbPixelsRecurrence) * this.mNbPixelsRecurrence) + this.mNbPixelsRecurrence - this.mDistance)) {
                this.mDistance += currentDistance;
                return;
            }
            this.mDistance += neededForNext;
            currentDistance -= neededForNext;
            this.add(new MilestoneStep((long)(x += neededForNext * Math.cos(Math.PI / 180 * orientation)), (long)(y += neededForNext * Math.sin(Math.PI / 180 * orientation)), orientation, this.mDistance));
        }
    }
}

