/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.tilesource;

import android.content.Context;
import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.tileprovider.util.ManifestUtil;
import org.osmdroid.util.MapTileIndex;

public class MapQuestTileSource
extends OnlineTileSourceBase {
    private static final String MAPBOX_MAPID = "MAPQUEST_MAPID";
    private static final String ACCESS_TOKEN = "MAPQUEST_ACCESS_TOKEN";
    private static final String[] mapBoxBaseUrl = new String[]{"http://api.tiles.mapbox.com/v4/"};
    private String mapBoxMapId = "mapquest.streets-mb";
    private String accessToken;

    public MapQuestTileSource(Context ctx) {
        super("MapQuest", 1, 19, 256, ".png", mapBoxBaseUrl, "MapQuest");
        this.retrieveAccessToken(ctx);
        this.retrieveMapBoxMapId(ctx);
        this.mName = "MapQuest" + this.mapBoxMapId;
    }

    public MapQuestTileSource(String mapboxid, String accesstoken) {
        super("MapQuest" + mapboxid, 1, 19, 256, ".png", mapBoxBaseUrl, "MapQuest");
        this.accessToken = accesstoken;
        this.mapBoxMapId = mapboxid;
    }

    public MapQuestTileSource(String name, int zoomMinLevel, int zoomMaxLevel, int tileSizePixels, String imageFilenameEnding) {
        super(name, zoomMinLevel, zoomMaxLevel, tileSizePixels, imageFilenameEnding, mapBoxBaseUrl, "MapQuest");
    }

    public MapQuestTileSource(String name, int zoomMinLevel, int zoomMaxLevel, int tileSizePixels, String imageFilenameEnding, String mapBoxMapId, String mapBoxVersionBaseUrl) {
        super(name + mapBoxMapId, zoomMinLevel, zoomMaxLevel, tileSizePixels, imageFilenameEnding, new String[]{mapBoxVersionBaseUrl}, "MapQuest");
        this.mapBoxMapId = mapBoxMapId;
    }

    public final void retrieveMapBoxMapId(Context aContext) {
        String temp = ManifestUtil.retrieveKey(aContext, MAPBOX_MAPID);
        if (temp != null && temp.length() > 0) {
            this.mapBoxMapId = temp;
        }
    }

    public final void retrieveAccessToken(Context aContext) {
        this.accessToken = ManifestUtil.retrieveKey(aContext, ACCESS_TOKEN);
    }

    public void setMapboxMapid(String key) {
        this.mapBoxMapId = key;
    }

    public String getMapBoxMapId() {
        return this.mapBoxMapId;
    }

    @Override
    public String getTileURLString(long pMapTileIndex) {
        StringBuilder url = new StringBuilder(this.getBaseUrl());
        url.append(this.getMapBoxMapId());
        url.append("/");
        url.append(MapTileIndex.getZoom(pMapTileIndex));
        url.append("/");
        url.append(MapTileIndex.getX(pMapTileIndex));
        url.append("/");
        url.append(MapTileIndex.getY(pMapTileIndex));
        url.append(".png");
        url.append("?access_token=").append(this.getAccessToken());
        String res = url.toString();
        return res;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessTokeninput) {
        this.accessToken = accessTokeninput;
    }
}

