/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.DisplayMetrics;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;

public class CopyrightOverlay
extends Overlay {
    private Paint paint;
    int xOffset = 10;
    int yOffset = 10;
    protected boolean alignBottom = true;
    protected boolean alignRight = false;
    final DisplayMetrics dm;

    public CopyrightOverlay(Context context) {
        Resources resources = context.getResources();
        this.dm = resources.getDisplayMetrics();
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setTextSize(this.dm.density * 12.0f);
    }

    public void setTextSize(int fontSize) {
        this.paint.setTextSize(this.dm.density * (float)fontSize);
    }

    public void setTextColor(int color) {
        this.paint.setColor(color);
    }

    public void setAlignBottom(boolean alignBottom) {
        this.alignBottom = alignBottom;
    }

    public void setAlignRight(boolean alignRight) {
        this.alignRight = alignRight;
    }

    public void setOffset(int x, int y) {
        this.xOffset = x;
        this.yOffset = y;
    }

    @Override
    public void draw(Canvas canvas, MapView map, boolean shadow) {
        if (shadow) {
            return;
        }
        if (map.isAnimating()) {
            return;
        }
        if (map.getTileProvider().getTileSource().getCopyrightNotice() == null || map.getTileProvider().getTileSource().getCopyrightNotice().length() == 0) {
            return;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        float x = 0.0f;
        float y = 0.0f;
        if (this.alignRight) {
            x = width - this.xOffset;
            this.paint.setTextAlign(Paint.Align.RIGHT);
        } else {
            x = this.xOffset;
            this.paint.setTextAlign(Paint.Align.LEFT);
        }
        y = this.alignBottom ? (float)(height - this.yOffset) : this.paint.getTextSize() + (float)this.yOffset;
        canvas.save();
        canvas.concat(map.getProjection().getInvertedScaleRotateCanvasMatrix());
        canvas.drawText(map.getTileProvider().getTileSource().getCopyrightNotice(), x, y, this.paint);
        canvas.restore();
    }
}

