/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import java.util.List;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.MyMath;
import org.osmdroid.views.util.constants.MapViewConstants;

public class BoundingBox
implements Parcelable,
Serializable,
MapViewConstants {
    static final long serialVersionUID = 2L;
    protected final double mLatNorth;
    protected final double mLatSouth;
    protected final double mLonEast;
    protected final double mLonWest;
    public static final Parcelable.Creator<BoundingBox> CREATOR = new Parcelable.Creator<BoundingBox>(){

        public BoundingBox createFromParcel(Parcel in) {
            return BoundingBox.readFromParcel(in);
        }

        public BoundingBox[] newArray(int size) {
            return new BoundingBox[size];
        }
    };

    public BoundingBox(double north, double east, double south, double west) {
        this.mLatNorth = north;
        this.mLonEast = east;
        this.mLatSouth = south;
        this.mLonWest = west;
    }

    public BoundingBox clone() {
        return new BoundingBox(this.mLatNorth, this.mLonEast, this.mLatSouth, this.mLonWest);
    }

    public BoundingBox concat(BoundingBox bb2) {
        return new BoundingBox(Math.max(this.mLatNorth, bb2.getLatNorth()), Math.max(this.mLonEast, bb2.getLonEast()), Math.min(this.mLatSouth, bb2.getLatSouth()), Math.min(this.mLonWest, bb2.getLonWest()));
    }

    public GeoPoint getCenter() {
        return new GeoPoint((this.mLatNorth + this.mLatSouth) / 2.0, (this.mLonEast + this.mLonWest) / 2.0);
    }

    public double getDiagonalLengthInMeters() {
        return new GeoPoint(this.mLatNorth, this.mLonWest).distanceTo(new GeoPoint(this.mLatSouth, this.mLonEast));
    }

    public double getLatNorth() {
        return this.mLatNorth;
    }

    public double getLatSouth() {
        return this.mLatSouth;
    }

    public double getLonEast() {
        return this.mLonEast;
    }

    public double getLonWest() {
        return this.mLonWest;
    }

    public double getLatitudeSpan() {
        return Math.abs(this.mLatNorth - this.mLatSouth);
    }

    public double getLongitudeSpan() {
        return Math.abs(this.mLonEast - this.mLonWest);
    }

    public PointF getRelativePositionOfGeoPointInBoundingBoxWithLinearInterpolation(double aLatitude, double aLongitude, PointF reuse) {
        PointF out = reuse != null ? reuse : new PointF();
        float y = (float)((this.mLatNorth - aLatitude) / this.getLatitudeSpan());
        float x = 1.0f - (float)((this.mLonEast - aLongitude) / this.getLongitudeSpan());
        out.set(x, y);
        return out;
    }

    public PointF getRelativePositionOfGeoPointInBoundingBoxWithExactGudermannInterpolation(double aLatitude, double aLongitude, PointF reuse) {
        PointF out = reuse != null ? reuse : new PointF();
        float y = (float)((MyMath.gudermannInverse(this.mLatNorth) - MyMath.gudermannInverse(aLatitude)) / (MyMath.gudermannInverse(this.mLatNorth) - MyMath.gudermannInverse(this.mLatSouth)));
        float x = 1.0f - (float)((this.mLonEast - aLongitude) / this.getLongitudeSpan());
        out.set(x, y);
        return out;
    }

    public GeoPoint getGeoPointOfRelativePositionWithLinearInterpolation(float relX, float relY) {
        double lat;
        double lon = this.mLonWest + this.getLongitudeSpan() * (double)relX;
        for (lat = this.mLatNorth - this.getLatitudeSpan() * (double)relY; lat > 90.5; lat -= 90.5) {
        }
        while (lat < -90.5) {
            lat += 90.5;
        }
        while (lon > 180.0) {
            lon -= 180.0;
        }
        while (lon < -180.0) {
            lon += 180.0;
        }
        return new GeoPoint(lat, lon);
    }

    public GeoPoint getGeoPointOfRelativePositionWithExactGudermannInterpolation(float relX, float relY) {
        double lat;
        double gudNorth = MyMath.gudermannInverse(this.mLatNorth);
        double gudSouth = MyMath.gudermannInverse(this.mLatSouth);
        double lon = this.mLonWest + this.getLongitudeSpan() * (double)relX;
        for (lat = MyMath.gudermann(gudSouth + (double)(1.0f - relY) * (gudNorth - gudSouth)); lat > 90.5; lat -= 90.5) {
        }
        while (lat < -90.5) {
            lat += 90.5;
        }
        while (lon > 180.0) {
            lon -= 180.0;
        }
        while (lon < -180.0) {
            lon += 180.0;
        }
        return new GeoPoint(lat, lon);
    }

    public BoundingBox increaseByScale(float pBoundingboxPaddingRelativeScale) {
        GeoPoint pCenter = this.getCenter();
        double mLatSpanPadded_2 = this.getLatitudeSpan() * (double)pBoundingboxPaddingRelativeScale / 2.0;
        double mLonSpanPadded_2 = this.getLongitudeSpan() * (double)pBoundingboxPaddingRelativeScale / 2.0;
        return new BoundingBox(pCenter.getLatitude() + mLatSpanPadded_2, pCenter.getLongitude() + mLonSpanPadded_2, pCenter.getLatitude() - mLatSpanPadded_2, pCenter.getLongitude() - mLonSpanPadded_2);
    }

    public String toString() {
        return new StringBuffer().append("N:").append(this.mLatNorth).append("; E:").append(this.mLonEast).append("; S:").append(this.mLatSouth).append("; W:").append(this.mLonWest).toString();
    }

    public GeoPoint bringToBoundingBox(double aLatitude, double aLongitude) {
        return new GeoPoint(Math.max(this.mLatSouth, Math.min(this.mLatNorth, aLatitude)), Math.max(this.mLonWest, Math.min(this.mLonEast, aLongitude)));
    }

    public static BoundingBox fromGeoPoints(List<? extends IGeoPoint> partialPolyLine) {
        double minLat = Double.MAX_VALUE;
        double minLon = Double.MAX_VALUE;
        double maxLat = -1.7976931348623157E308;
        double maxLon = -1.7976931348623157E308;
        for (IGeoPoint iGeoPoint : partialPolyLine) {
            double latitude = iGeoPoint.getLatitude();
            double longitude = iGeoPoint.getLongitude();
            minLat = Math.min(minLat, latitude);
            minLon = Math.min(minLon, longitude);
            maxLat = Math.max(maxLat, latitude);
            maxLon = Math.max(maxLon, longitude);
        }
        return new BoundingBox(maxLat, maxLon, minLat, minLon);
    }

    public boolean contains(IGeoPoint pGeoPoint) {
        return this.contains(pGeoPoint.getLatitude(), pGeoPoint.getLongitude());
    }

    public boolean contains(double aLatitude, double aLongitude) {
        return aLatitude < this.mLatNorth && aLatitude > this.mLatSouth && aLongitude < this.mLonEast && aLongitude > this.mLonWest;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int arg1) {
        out.writeDouble(this.mLatNorth);
        out.writeDouble(this.mLonEast);
        out.writeDouble(this.mLatSouth);
        out.writeDouble(this.mLonWest);
    }

    private static BoundingBox readFromParcel(Parcel in) {
        double latNorth = in.readDouble();
        double lonEast = in.readDouble();
        double latSouth = in.readDouble();
        double lonWest = in.readDouble();
        return new BoundingBox(latNorth, lonEast, latSouth, lonWest);
    }

    @Deprecated
    public int getLatitudeSpanE6() {
        return (int)(this.getLatitudeSpan() * 1000000.0);
    }

    @Deprecated
    public int getLongitudeSpanE6() {
        return (int)(this.getLongitudeSpan() * 1000000.0);
    }
}

