/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.cachemanager;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Point;
import android.os.AsyncTask;
import android.util.Log;
import android.widget.Toast;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.MyMath;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapView;

public class CacheManager {
    protected final MapTileProviderBase mTileProvider;
    protected final IFilesystemCache mTileWriter;
    protected final int mMinZoomLevel;
    protected final int mMaxZoomLevel;
    protected Set<CacheManagerTask> mPendingTasks = new HashSet<CacheManagerTask>();

    public CacheManager(MapView mapView) {
        this(mapView, mapView.getTileProvider().getTileWriter());
    }

    public CacheManager(MapView mapView, IFilesystemCache writer) {
        this(mapView.getTileProvider(), writer, mapView.getMinZoomLevel(), mapView.getMaxZoomLevel());
    }

    public CacheManager(MapTileProviderBase pTileProvider, IFilesystemCache pWriter, int pMinZoomLevel, int pMaxZoomLevel) {
        this.mTileProvider = pTileProvider;
        this.mTileWriter = pWriter;
        this.mMinZoomLevel = pMinZoomLevel;
        this.mMaxZoomLevel = pMaxZoomLevel;
    }

    public int getPendingJobs() {
        return this.mPendingTasks.size();
    }

    public static Point getMapTileFromCoordinates(double aLat, double aLon, int zoom) {
        int y = (int)Math.floor((1.0 - Math.log(Math.tan(aLat * Math.PI / 180.0) + 1.0 / Math.cos(aLat * Math.PI / 180.0)) / Math.PI) / 2.0 * (double)(1 << zoom));
        int x = (int)Math.floor((aLon + 180.0) / 360.0 * (double)(1 << zoom));
        return new Point(x, y);
    }

    public static GeoPoint getCoordinatesFromMapTile(int x, int y, int zoom) {
        double n = Math.PI - Math.PI * 2 * (double)y / (double)(1 << zoom);
        double lat = 57.29577951308232 * Math.atan(0.5 * (Math.exp(n) - Math.exp(-n)));
        double lon = 360.0 * (double)x / (double)(1 << zoom) - 180.0;
        return new GeoPoint(lat, lon);
    }

    public static File getFileName(ITileSource tileSource, MapTile tile) {
        File file = new File(Configuration.getInstance().getOsmdroidTileCache(), tileSource.getTileRelativeFilenameString(tile) + ".tile");
        return file;
    }

    /*
     * Exception decompiling
     */
    public boolean loadTile(OnlineTileSourceBase tileSource, MapTile tile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 39[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean deleteTile(MapTile pTile) {
        ITileSource tileSource = this.mTileProvider.getTileSource();
        return this.mTileWriter.exists(tileSource, pTile) && this.mTileWriter.remove(tileSource, pTile);
    }

    public boolean checkTile(MapTile pTile) {
        return this.mTileWriter.exists(this.mTileProvider.getTileSource(), pTile);
    }

    public static List<MapTile> getTilesCoverage(BoundingBox pBB, int pZoomMin, int pZoomMax) {
        ArrayList<MapTile> result = new ArrayList<MapTile>();
        for (int zoomLevel = pZoomMin; zoomLevel <= pZoomMax; ++zoomLevel) {
            Collection<MapTile> resultForZoom = CacheManager.getTilesCoverage(pBB, zoomLevel);
            result.addAll(resultForZoom);
        }
        return result;
    }

    public static Collection<MapTile> getTilesCoverage(BoundingBox pBB, int pZoomLevel) {
        int height;
        HashSet<MapTile> result = new HashSet<MapTile>();
        int mapTileUpperBound = 1 << pZoomLevel;
        Point lowerRight = CacheManager.getMapTileFromCoordinates(pBB.getLatSouth(), pBB.getLonEast(), pZoomLevel);
        Point upperLeft = CacheManager.getMapTileFromCoordinates(pBB.getLatNorth(), pBB.getLonWest(), pZoomLevel);
        int width = lowerRight.x - upperLeft.x + 1;
        if (width <= 0) {
            width += mapTileUpperBound;
        }
        if ((height = lowerRight.y - upperLeft.y + 1) <= 0) {
            height += mapTileUpperBound;
        }
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int x = MyMath.mod(upperLeft.x + i, mapTileUpperBound);
                int y = MyMath.mod(upperLeft.y + j, mapTileUpperBound);
                result.add(new MapTile(pZoomLevel, x, y));
            }
        }
        return result;
    }

    public static List<MapTile> getTilesCoverage(ArrayList<GeoPoint> pGeoPoints, int pZoomMin, int pZoomMax) {
        ArrayList<MapTile> result = new ArrayList<MapTile>();
        for (int zoomLevel = pZoomMin; zoomLevel <= pZoomMax; ++zoomLevel) {
            Collection<MapTile> resultForZoom = CacheManager.getTilesCoverage(pGeoPoints, zoomLevel);
            result.addAll(resultForZoom);
        }
        return result;
    }

    public static Collection<MapTile> getTilesCoverage(ArrayList<GeoPoint> pGeoPoints, int pZoomLevel) {
        HashSet<MapTile> result = new HashSet<MapTile>();
        GeoPoint prevPoint = null;
        Point prevTile = null;
        int mapTileUpperBound = 1 << pZoomLevel;
        for (GeoPoint geoPoint : pGeoPoints) {
            Point tile;
            double d = TileSystem.GroundResolution(geoPoint.getLatitude(), pZoomLevel);
            if (result.size() != 0) {
                if (prevPoint != null) {
                    double leadCoef = (geoPoint.getLatitude() - prevPoint.getLatitude()) / (geoPoint.getLongitude() - prevPoint.getLongitude());
                    double brng = geoPoint.getLongitude() > prevPoint.getLongitude() ? 1.5707963267948966 - Math.atan(leadCoef) : 4.71238898038469 - Math.atan(leadCoef);
                    GeoPoint wayPoint = new GeoPoint(prevPoint.getLatitude(), prevPoint.getLongitude());
                    while ((geoPoint.getLatitude() > prevPoint.getLatitude() && wayPoint.getLatitude() < geoPoint.getLatitude() || geoPoint.getLatitude() < prevPoint.getLatitude() && wayPoint.getLatitude() > geoPoint.getLatitude()) && (geoPoint.getLongitude() > prevPoint.getLongitude() && wayPoint.getLongitude() < geoPoint.getLongitude() || geoPoint.getLongitude() < prevPoint.getLongitude() && wayPoint.getLongitude() > geoPoint.getLongitude())) {
                        Point lastPoint = new Point();
                        TileSystem.LatLongToPixelXY(geoPoint.getLatitude(), geoPoint.getLongitude(), pZoomLevel, lastPoint);
                        double prevLatRad = wayPoint.getLatitude() * Math.PI / 180.0;
                        double prevLonRad = wayPoint.getLongitude() * Math.PI / 180.0;
                        double latRad = Math.asin(Math.sin(prevLatRad) * Math.cos(d / 6378137.0) + Math.cos(prevLatRad) * Math.sin(d / 6378137.0) * Math.cos(brng));
                        double lonRad = prevLonRad + Math.atan2(Math.sin(brng) * Math.sin(d / 6378137.0) * Math.cos(prevLatRad), Math.cos(d / 6378137.0) - Math.sin(prevLatRad) * Math.sin(latRad));
                        wayPoint.setLatitude(latRad * 180.0 / Math.PI);
                        wayPoint.setLongitude(lonRad * 180.0 / Math.PI);
                        tile = CacheManager.getMapTileFromCoordinates(wayPoint.getLatitude(), wayPoint.getLongitude(), pZoomLevel);
                        if (tile.equals((Object)prevTile)) continue;
                        int ofsx = tile.x >= 0 ? 0 : -tile.x;
                        int ofsy = tile.y >= 0 ? 0 : -tile.y;
                        for (int xAround = tile.x + ofsx; xAround <= tile.x + 1 + ofsx; ++xAround) {
                            for (int yAround = tile.y + ofsy; yAround <= tile.y + 1 + ofsy; ++yAround) {
                                int tileY = MyMath.mod(yAround, mapTileUpperBound);
                                int tileX = MyMath.mod(xAround, mapTileUpperBound);
                                result.add(new MapTile(pZoomLevel, tileX, tileY));
                            }
                        }
                        prevTile = tile;
                    }
                }
            } else {
                prevTile = tile = CacheManager.getMapTileFromCoordinates(geoPoint.getLatitude(), geoPoint.getLongitude(), pZoomLevel);
                int ofsx = tile.x >= 0 ? 0 : -tile.x;
                int ofsy = tile.y >= 0 ? 0 : -tile.y;
                for (int xAround = tile.x + ofsx; xAround <= tile.x + 1 + ofsx; ++xAround) {
                    for (int yAround = tile.y + ofsy; yAround <= tile.y + 1 + ofsy; ++yAround) {
                        int tileY = MyMath.mod(yAround, mapTileUpperBound);
                        int tileX = MyMath.mod(xAround, mapTileUpperBound);
                        result.add(new MapTile(pZoomLevel, tileX, tileY));
                    }
                }
            }
            prevPoint = geoPoint;
        }
        return result;
    }

    public int possibleTilesInArea(BoundingBox pBB, int pZoomMin, int pZoomMax) {
        return CacheManager.getTilesCoverage(pBB, pZoomMin, pZoomMax).size();
    }

    public int possibleTilesCovered(ArrayList<GeoPoint> pGeoPoints, int pZoomMin, int pZoomMax) {
        return CacheManager.getTilesCoverage(pGeoPoints, pZoomMin, pZoomMax).size();
    }

    public CacheManagerTask execute(CacheManagerTask pTask) {
        pTask.execute(new Object[0]);
        this.mPendingTasks.add(pTask);
        return pTask;
    }

    public CacheManagerTask downloadAreaAsync(Context ctx, BoundingBox bb, int zoomMin, int zoomMax) {
        CacheManagerTask task = new CacheManagerTask(this, this.getDownloadingAction(), bb, zoomMin, zoomMax);
        task.addCallback(this.getDownloadingDialog(ctx, task));
        return this.execute(task);
    }

    public CacheManagerTask downloadAreaAsync(Context ctx, ArrayList<GeoPoint> geoPoints, int zoomMin, int zoomMax) {
        CacheManagerTask task = new CacheManagerTask(this, this.getDownloadingAction(), geoPoints, zoomMin, zoomMax);
        task.addCallback(this.getDownloadingDialog(ctx, task));
        return this.execute(task);
    }

    public CacheManagerTask downloadAreaAsync(Context ctx, BoundingBox bb, int zoomMin, int zoomMax, CacheManagerCallback callback) {
        CacheManagerTask task = new CacheManagerTask(this, this.getDownloadingAction(), bb, zoomMin, zoomMax);
        task.addCallback(callback);
        task.addCallback(this.getDownloadingDialog(ctx, task));
        return this.execute(task);
    }

    public CacheManagerTask downloadAreaAsync(Context ctx, ArrayList<GeoPoint> geoPoints, int zoomMin, int zoomMax, CacheManagerCallback callback) {
        CacheManagerTask task = new CacheManagerTask(this, this.getDownloadingAction(), geoPoints, zoomMin, zoomMax);
        task.addCallback(callback);
        task.addCallback(this.getDownloadingDialog(ctx, task));
        return this.execute(task);
    }

    public CacheManagerTask downloadAreaAsyncNoUI(Context ctx, ArrayList<GeoPoint> geoPoints, int zoomMin, int zoomMax, CacheManagerCallback callback) {
        CacheManagerTask task = new CacheManagerTask(this, this.getDownloadingAction(), geoPoints, zoomMin, zoomMax);
        task.addCallback(callback);
        return this.execute(task);
    }

    public CacheManagerTask downloadAreaAsyncNoUI(Context ctx, BoundingBox bb, int zoomMin, int zoomMax, CacheManagerCallback callback) {
        CacheManagerTask task = new CacheManagerTask(this, this.getDownloadingAction(), bb, zoomMin, zoomMax);
        task.addCallback(callback);
        this.execute(task);
        return task;
    }

    public void cancelAllJobs() {
        for (CacheManagerTask next : this.mPendingTasks) {
            next.cancel(true);
        }
        this.mPendingTasks.clear();
    }

    public CacheManagerTask downloadAreaAsync(Context ctx, List<MapTile> pTiles, int zoomMin, int zoomMax) {
        CacheManagerTask task = new CacheManagerTask(this, this.getDownloadingAction(), pTiles, zoomMin, zoomMax);
        task.addCallback(this.getDownloadingDialog(ctx, task));
        return this.execute(task);
    }

    public CacheManagerDialog getDownloadingDialog(final Context pCtx, CacheManagerTask pTask) {
        return new CacheManagerDialog(pCtx, pTask){

            @Override
            protected String getUITitle() {
                return "Downloading tiles";
            }

            @Override
            public void onTaskFailed(int errors) {
                super.onTaskFailed(errors);
                Toast.makeText((Context)pCtx, (CharSequence)("Loading completed with " + errors + " errors."), (int)0).show();
            }
        };
    }

    public CacheManagerDialog getCleaningDialog(final Context pCtx, CacheManagerTask pTask) {
        return new CacheManagerDialog(pCtx, pTask){

            @Override
            protected String getUITitle() {
                return "Cleaning tiles";
            }

            @Override
            public void onTaskFailed(int deleted) {
                super.onTaskFailed(deleted);
                Toast.makeText((Context)pCtx, (CharSequence)("Cleaning completed, " + deleted + " tiles deleted."), (int)0).show();
            }
        };
    }

    public CacheManagerAction getDownloadingAction() {
        return new CacheManagerAction(){

            @Override
            public boolean preCheck() {
                if (CacheManager.this.mTileProvider.getTileSource() instanceof OnlineTileSourceBase) {
                    return true;
                }
                Log.e((String)"OsmDroid", (String)"TileSource is not an online tile source");
                return false;
            }

            @Override
            public int getProgressModulo() {
                return 10;
            }

            @Override
            public boolean tileAction(MapTile pTile) {
                return !CacheManager.this.loadTile((OnlineTileSourceBase)CacheManager.this.mTileProvider.getTileSource(), pTile);
            }
        };
    }

    public CacheManagerAction getCleaningAction() {
        return new CacheManagerAction(){

            @Override
            public boolean preCheck() {
                return true;
            }

            @Override
            public int getProgressModulo() {
                return 1000;
            }

            @Override
            public boolean tileAction(MapTile pTile) {
                return CacheManager.this.deleteTile(pTile);
            }
        };
    }

    public CacheManagerTask cleanAreaAsync(Context ctx, BoundingBox bb, int zoomMin, int zoomMax) {
        CacheManagerTask task = new CacheManagerTask(this, this.getCleaningAction(), bb, zoomMin, zoomMax);
        task.addCallback(this.getCleaningDialog(ctx, task));
        return this.execute(task);
    }

    public CacheManagerTask cleanAreaAsync(Context ctx, ArrayList<GeoPoint> geoPoints, int zoomMin, int zoomMax) {
        BoundingBox extendedBounds = this.extendedBoundsFromGeoPoints(geoPoints, zoomMin);
        return this.cleanAreaAsync(ctx, extendedBounds, zoomMin, zoomMax);
    }

    public CacheManagerTask cleanAreaAsync(Context ctx, List<MapTile> tiles, int zoomMin, int zoomMax) {
        CacheManagerTask task = new CacheManagerTask(this, this.getCleaningAction(), tiles, zoomMin, zoomMax);
        task.addCallback(this.getCleaningDialog(ctx, task));
        return this.execute(task);
    }

    public BoundingBox extendedBoundsFromGeoPoints(ArrayList<GeoPoint> geoPoints, int minZoomLevel) {
        BoundingBox bb = BoundingBox.fromGeoPoints(geoPoints);
        Point mLowerRight = CacheManager.getMapTileFromCoordinates(bb.getLatSouth(), bb.getLonEast(), minZoomLevel);
        GeoPoint lowerRightPoint = CacheManager.getCoordinatesFromMapTile(mLowerRight.x + 1, mLowerRight.y + 1, minZoomLevel);
        Point mUpperLeft = CacheManager.getMapTileFromCoordinates(bb.getLatNorth(), bb.getLonWest(), minZoomLevel);
        GeoPoint upperLeftPoint = CacheManager.getCoordinatesFromMapTile(mUpperLeft.x - 1, mUpperLeft.y - 1, minZoomLevel);
        BoundingBox extendedBounds = new BoundingBox(upperLeftPoint.getLatitude(), upperLeftPoint.getLongitude(), lowerRightPoint.getLatitude(), lowerRightPoint.getLongitude());
        return extendedBounds;
    }

    public long currentCacheUsage() {
        return this.directorySize(Configuration.getInstance().getOsmdroidTileCache());
    }

    public long cacheCapacity() {
        return Configuration.getInstance().getTileFileSystemCacheMaxBytes();
    }

    public long directorySize(File pDirectory) {
        long usedCacheSpace = 0L;
        File[] z = pDirectory.listFiles();
        if (z != null) {
            for (File file : z) {
                if (file.isFile()) {
                    usedCacheSpace += file.length();
                    continue;
                }
                if (!file.isDirectory()) continue;
                usedCacheSpace += this.directorySize(file);
            }
        }
        return usedCacheSpace;
    }

    public static interface CacheManagerAction {
        public boolean preCheck();

        public int getProgressModulo();

        public boolean tileAction(MapTile var1);
    }

    public static class CacheManagerTask
    extends AsyncTask<Object, Integer, Integer> {
        private final CacheManager mManager;
        private final CacheManagerAction mAction;
        private final List<MapTile> mTiles;
        private final int mZoomMin;
        private final int mZoomMax;
        private final ArrayList<CacheManagerCallback> mCallbacks = new ArrayList();

        public CacheManagerTask(CacheManager pManager, CacheManagerAction pAction, List<MapTile> pTiles, int pZoomMin, int pZoomMax) {
            this.mManager = pManager;
            this.mAction = pAction;
            this.mTiles = pTiles;
            this.mZoomMin = Math.max(pZoomMin, pManager.mMinZoomLevel);
            this.mZoomMax = Math.min(pZoomMax, pManager.mMaxZoomLevel);
        }

        public CacheManagerTask(CacheManager pManager, CacheManagerAction pAction, ArrayList<GeoPoint> pGeoPoints, int pZoomMin, int pZoomMax) {
            this(pManager, pAction, CacheManager.getTilesCoverage(pGeoPoints, pZoomMin, pZoomMax), pZoomMin, pZoomMax);
        }

        public CacheManagerTask(CacheManager pManager, CacheManagerAction pAction, BoundingBox pBB, int pZoomMin, int pZoomMax) {
            this(pManager, pAction, CacheManager.getTilesCoverage(pBB, pZoomMin, pZoomMax), pZoomMin, pZoomMax);
        }

        public void addCallback(CacheManagerCallback pCallback) {
            if (pCallback != null) {
                this.mCallbacks.add(pCallback);
            }
        }

        protected void onPreExecute() {
            int total = this.mTiles.size();
            for (CacheManagerCallback callback : this.mCallbacks) {
                try {
                    callback.setPossibleTilesInArea(total);
                    callback.downloadStarted();
                    callback.updateProgress(0, this.mZoomMin, this.mZoomMin, this.mZoomMax);
                }
                catch (Throwable t) {
                    this.logFaultyCallback(t);
                }
            }
        }

        private void logFaultyCallback(Throwable pThrowable) {
            Log.w((String)"OsmDroid", (String)"Error caught processing cachemanager callback, your implementation is faulty", (Throwable)pThrowable);
        }

        protected void onProgressUpdate(Integer ... count) {
            for (CacheManagerCallback callback : this.mCallbacks) {
                try {
                    callback.updateProgress(count[0], count[1], this.mZoomMin, this.mZoomMax);
                }
                catch (Throwable t) {
                    this.logFaultyCallback(t);
                }
            }
        }

        protected void onCancelled() {
            this.mManager.mPendingTasks.remove((Object)this);
        }

        protected void onPostExecute(Integer specialCount) {
            this.mManager.mPendingTasks.remove((Object)this);
            for (CacheManagerCallback callback : this.mCallbacks) {
                try {
                    if (specialCount == 0) {
                        callback.onTaskComplete();
                        continue;
                    }
                    callback.onTaskFailed(specialCount);
                }
                catch (Throwable t) {
                    this.logFaultyCallback(t);
                }
            }
        }

        protected Integer doInBackground(Object ... params) {
            if (!this.mAction.preCheck()) {
                return 0;
            }
            int tileCounter = 0;
            int errors = 0;
            for (MapTile tile : this.mTiles) {
                int zoom = tile.getZoomLevel();
                if (zoom >= this.mZoomMin && zoom <= this.mZoomMax && this.mAction.tileAction(tile)) {
                    ++errors;
                }
                if (++tileCounter % this.mAction.getProgressModulo() != 0) continue;
                if (this.isCancelled()) {
                    return errors;
                }
                this.publishProgress(new Integer[]{tileCounter, tile.getZoomLevel()});
            }
            return errors;
        }
    }

    public static abstract class CacheManagerDialog
    implements CacheManagerCallback {
        private final CacheManagerTask mTask;
        private final ProgressDialog mProgressDialog;

        public CacheManagerDialog(Context pCtx, CacheManagerTask pTask) {
            this.mTask = pTask;
            this.mProgressDialog = new ProgressDialog(pCtx);
            this.mProgressDialog.setProgressStyle(1);
            this.mProgressDialog.setCancelable(true);
            this.mProgressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    CacheManagerDialog.this.mTask.cancel(true);
                }
            });
        }

        protected String zoomMessage(int zoomLevel, int zoomMin, int zoomMax) {
            return "Handling zoom level: " + zoomLevel + " (from " + zoomMin + " to " + zoomMax + ")";
        }

        protected abstract String getUITitle();

        @Override
        public void updateProgress(int progress, int currentZoomLevel, int zoomMin, int zoomMax) {
            this.mProgressDialog.setProgress(progress);
            this.mProgressDialog.setMessage((CharSequence)this.zoomMessage(currentZoomLevel, zoomMin, zoomMax));
        }

        @Override
        public void downloadStarted() {
            this.mProgressDialog.setTitle((CharSequence)this.getUITitle());
            this.mProgressDialog.show();
        }

        @Override
        public void setPossibleTilesInArea(int total) {
            this.mProgressDialog.setMax(total);
        }

        @Override
        public void onTaskComplete() {
            this.dismiss();
        }

        @Override
        public void onTaskFailed(int errors) {
            this.dismiss();
        }

        private void dismiss() {
            if (this.mProgressDialog.isShowing()) {
                this.mProgressDialog.dismiss();
            }
        }
    }

    public static interface CacheManagerCallback {
        public void onTaskComplete();

        public void updateProgress(int var1, int var2, int var3, int var4);

        public void downloadStarted();

        public void setPossibleTilesInArea(int var1);

        public void onTaskFailed(int var1);
    }
}

