/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.config;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import java.io.File;
import java.net.Proxy;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osmdroid.config.IConfigurationProvider;
import org.osmdroid.tileprovider.util.StorageUtils;

public class DefaultConfigurationProvider
implements IConfigurationProvider {
    protected long gpsWaitTime = 20000L;
    protected boolean debugMode = false;
    protected boolean debugMapView = false;
    protected boolean debugTileProviders = false;
    protected boolean debugMapTileDownloader = false;
    protected boolean isMapViewHardwareAccelerated = false;
    protected String userAgentValue = "osmdroid";
    protected String userAgentHttpHeader = "User-Agent";
    private final Map<String, String> mAdditionalHttpRequestProperties = new HashMap<String, String>();
    protected short cacheMapTileCount = (short)9;
    protected short tileDownloadThreads = (short)2;
    protected short tileFileSystemThreads = (short)8;
    protected short tileDownloadMaxQueueSize = (short)40;
    protected short tileFileSystemMaxQueueSize = (short)40;
    protected long tileFileSystemCacheMaxBytes = 629145600L;
    protected long tileFileSystemCacheTrimBytes = 524288000L;
    protected SimpleDateFormat httpHeaderDateTimeFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    protected File osmdroidBasePath;
    protected File osmdroidTileCache;
    protected long expirationAdder = 0L;
    protected Long expirationOverride = null;
    protected Proxy httpProxy = null;

    public DefaultConfigurationProvider() {
        try {
            this.osmdroidBasePath = new File(StorageUtils.getStorage().getAbsolutePath(), "osmdroid");
            this.osmdroidTileCache = new File(this.getOsmdroidBasePath(), "tiles");
            this.osmdroidBasePath.mkdirs();
            this.osmdroidTileCache.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public long getGpsWaitTime() {
        return this.gpsWaitTime;
    }

    @Override
    public void setGpsWaitTime(long gpsWaitTime) {
        this.gpsWaitTime = gpsWaitTime;
    }

    @Override
    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    @Override
    public boolean isDebugMapView() {
        return this.debugMapView;
    }

    @Override
    public void setDebugMapView(boolean debugMapView) {
        this.debugMapView = debugMapView;
    }

    @Override
    public boolean isDebugTileProviders() {
        return this.debugTileProviders;
    }

    @Override
    public void setDebugTileProviders(boolean debugTileProviders) {
        this.debugTileProviders = debugTileProviders;
    }

    @Override
    public boolean isDebugMapTileDownloader() {
        return this.debugMapTileDownloader;
    }

    @Override
    public void setDebugMapTileDownloader(boolean debugMapTileDownloader) {
        this.debugMapTileDownloader = debugMapTileDownloader;
    }

    @Override
    public boolean isMapViewHardwareAccelerated() {
        return this.isMapViewHardwareAccelerated;
    }

    @Override
    public void setMapViewHardwareAccelerated(boolean mapViewHardwareAccelerated) {
        this.isMapViewHardwareAccelerated = mapViewHardwareAccelerated;
    }

    @Override
    public String getUserAgentValue() {
        return this.userAgentValue;
    }

    @Override
    public void setUserAgentValue(String userAgentValue) {
        this.userAgentValue = userAgentValue;
    }

    @Override
    public Map<String, String> getAdditionalHttpRequestProperties() {
        return this.mAdditionalHttpRequestProperties;
    }

    @Override
    public short getCacheMapTileCount() {
        return this.cacheMapTileCount;
    }

    @Override
    public void setCacheMapTileCount(short cacheMapTileCount) {
        this.cacheMapTileCount = cacheMapTileCount;
    }

    @Override
    public short getTileDownloadThreads() {
        return this.tileDownloadThreads;
    }

    @Override
    public void setTileDownloadThreads(short tileDownloadThreads) {
        this.tileDownloadThreads = tileDownloadThreads;
    }

    @Override
    public short getTileFileSystemThreads() {
        return this.tileFileSystemThreads;
    }

    @Override
    public void setTileFileSystemThreads(short tileFileSystemThreads) {
        this.tileFileSystemThreads = tileFileSystemThreads;
    }

    @Override
    public short getTileDownloadMaxQueueSize() {
        return this.tileDownloadMaxQueueSize;
    }

    @Override
    public void setTileDownloadMaxQueueSize(short tileDownloadMaxQueueSize) {
        this.tileDownloadMaxQueueSize = tileDownloadMaxQueueSize;
    }

    @Override
    public short getTileFileSystemMaxQueueSize() {
        return this.tileFileSystemMaxQueueSize;
    }

    @Override
    public void setTileFileSystemMaxQueueSize(short tileFileSystemMaxQueueSize) {
        this.tileFileSystemMaxQueueSize = tileFileSystemMaxQueueSize;
    }

    @Override
    public long getTileFileSystemCacheMaxBytes() {
        return this.tileFileSystemCacheMaxBytes;
    }

    @Override
    public void setTileFileSystemCacheMaxBytes(long tileFileSystemCacheMaxBytes) {
        this.tileFileSystemCacheMaxBytes = tileFileSystemCacheMaxBytes;
    }

    @Override
    public long getTileFileSystemCacheTrimBytes() {
        return this.tileFileSystemCacheTrimBytes;
    }

    @Override
    public void setTileFileSystemCacheTrimBytes(long tileFileSystemCacheTrimBytes) {
        this.tileFileSystemCacheTrimBytes = tileFileSystemCacheTrimBytes;
    }

    @Override
    public SimpleDateFormat getHttpHeaderDateTimeFormat() {
        return this.httpHeaderDateTimeFormat;
    }

    @Override
    public void setHttpHeaderDateTimeFormat(SimpleDateFormat httpHeaderDateTimeFormat) {
        this.httpHeaderDateTimeFormat = httpHeaderDateTimeFormat;
    }

    @Override
    public Proxy getHttpProxy() {
        return this.httpProxy;
    }

    @Override
    public void setHttpProxy(Proxy httpProxy) {
        this.httpProxy = httpProxy;
    }

    @Override
    public File getOsmdroidBasePath() {
        return this.osmdroidBasePath;
    }

    @Override
    public void setOsmdroidBasePath(File osmdroidBasePath) {
        this.osmdroidBasePath = osmdroidBasePath;
    }

    @Override
    public File getOsmdroidTileCache() {
        return this.osmdroidTileCache;
    }

    @Override
    public void setOsmdroidTileCache(File osmdroidTileCache) {
        this.osmdroidTileCache = osmdroidTileCache;
    }

    @Override
    public String getUserAgentHttpHeader() {
        return this.userAgentHttpHeader;
    }

    @Override
    public void setUserAgentHttpHeader(String userAgentHttpHeader) {
        this.userAgentHttpHeader = userAgentHttpHeader;
    }

    @Override
    public void load(Context ctx, SharedPreferences prefs) {
        if (!prefs.contains("osmdroid.basePath")) {
            File discoveredBestPath = this.getOsmdroidBasePath();
            File discoveredCachPath = this.getOsmdroidTileCache();
            if (!discoveredBestPath.exists() || !StorageUtils.isWritable(discoveredBestPath)) {
                discoveredCachPath = discoveredBestPath = new File("/data/data/" + ctx.getPackageName() + "/osmdroid/");
                discoveredCachPath.mkdirs();
            }
            SharedPreferences.Editor edit = prefs.edit();
            edit.putString("osmdroid.basePath", discoveredBestPath.getAbsolutePath());
            edit.putString("osmdroid.cachePath", discoveredCachPath.getAbsolutePath());
            edit.commit();
            this.setOsmdroidBasePath(discoveredBestPath);
            this.setOsmdroidTileCache(discoveredCachPath);
            this.setUserAgentValue(ctx.getPackageName());
            this.save(ctx, prefs);
        } else {
            this.setOsmdroidBasePath(new File(prefs.getString("osmdroid.basePath", this.getOsmdroidBasePath().getAbsolutePath())));
            this.setOsmdroidTileCache(new File(prefs.getString("osmdroid.cachePath", this.getOsmdroidTileCache().getAbsolutePath())));
            this.setDebugMode(prefs.getBoolean("osmdroid.DebugMode", false));
            this.setDebugMapTileDownloader(prefs.getBoolean("osmdroid.DebugDownloading", false));
            this.setDebugMapView(prefs.getBoolean("osmdroid.DebugMapView", false));
            this.setDebugTileProviders(prefs.getBoolean("osmdroid.DebugTileProvider", false));
            this.setMapViewHardwareAccelerated(prefs.getBoolean("osmdroid.HardwareAcceleration", false));
            this.setUserAgentValue(prefs.getString("osmdroid.userAgentValue", ctx.getPackageName()));
            DefaultConfigurationProvider.load(prefs, this.mAdditionalHttpRequestProperties, "osmdroid.additionalHttpRequestProperty.");
            this.setGpsWaitTime(prefs.getLong("osmdroid.gpsWaitTime", this.gpsWaitTime));
            this.setTileDownloadThreads((short)prefs.getInt("osmdroid.tileDownloadThreads", (int)this.tileDownloadThreads));
            this.setTileFileSystemThreads((short)prefs.getInt("osmdroid.tileFileSystemThreads", (int)this.tileFileSystemThreads));
            this.setTileDownloadMaxQueueSize((short)prefs.getInt("osmdroid.tileDownloadMaxQueueSize", (int)this.tileDownloadMaxQueueSize));
            this.setTileFileSystemMaxQueueSize((short)prefs.getInt("osmdroid.tileFileSystemMaxQueueSize", (int)this.tileFileSystemMaxQueueSize));
            this.setExpirationExtendedDuration(prefs.getLong("osmdroid.ExpirationExtendedDuration", this.expirationAdder));
            if (prefs.contains("osmdroid.ExpirationOverride")) {
                this.expirationOverride = prefs.getLong("osmdroid.ExpirationOverride", -1L);
                if (this.expirationOverride != null && this.expirationOverride == -1L) {
                    this.expirationOverride = null;
                }
            }
        }
        long cacheSize = -1L;
        if (Build.VERSION.SDK_INT >= 9) {
            File dbFile = new File(this.getOsmdroidTileCache().getAbsolutePath() + File.separator + "cache.db");
            if (dbFile.exists()) {
                cacheSize = dbFile.length();
                long freeSpace = this.getOsmdroidTileCache().getFreeSpace();
                if (this.getTileFileSystemCacheMaxBytes() > freeSpace + cacheSize) {
                    this.setTileFileSystemCacheMaxBytes((long)((double)(freeSpace + cacheSize) * 0.95));
                    this.setTileFileSystemCacheTrimBytes((long)((double)(freeSpace + cacheSize) * 0.9));
                }
            } else {
                long freeSpace = this.getOsmdroidTileCache().length();
                if (this.getTileFileSystemCacheMaxBytes() > freeSpace) {
                    this.setTileFileSystemCacheMaxBytes((long)((double)freeSpace * 0.95));
                    this.setTileFileSystemCacheMaxBytes((long)((double)freeSpace * 0.9));
                }
            }
        }
    }

    @Override
    public void save(Context ctx, SharedPreferences prefs) {
        SharedPreferences.Editor edit = prefs.edit();
        edit.putString("osmdroid.basePath", this.getOsmdroidBasePath().getAbsolutePath());
        edit.putString("osmdroid.cachePath", this.getOsmdroidTileCache().getAbsolutePath());
        edit.putBoolean("osmdroid.DebugMode", this.isDebugMode());
        edit.putBoolean("osmdroid.DebugDownloading", this.isDebugMapTileDownloader());
        edit.putBoolean("osmdroid.DebugMapView", this.isDebugMapView());
        edit.putBoolean("osmdroid.DebugTileProvider", this.isDebugTileProviders());
        edit.putBoolean("osmdroid.HardwareAcceleration", this.isMapViewHardwareAccelerated());
        edit.putString("osmdroid.userAgentValue", this.getUserAgentValue());
        DefaultConfigurationProvider.save(prefs, edit, this.mAdditionalHttpRequestProperties, "osmdroid.additionalHttpRequestProperty.");
        edit.putLong("osmdroid.gpsWaitTime", this.gpsWaitTime);
        edit.putInt("osmdroid.cacheMapTileCount", (int)this.cacheMapTileCount);
        edit.putInt("osmdroid.tileDownloadThreads", (int)this.tileDownloadThreads);
        edit.putInt("osmdroid.tileFileSystemThreads", (int)this.tileFileSystemThreads);
        edit.putInt("osmdroid.tileDownloadMaxQueueSize", (int)this.tileDownloadMaxQueueSize);
        edit.putInt("osmdroid.tileFileSystemMaxQueueSize", (int)this.tileFileSystemMaxQueueSize);
        edit.putLong("osmdroid.ExpirationExtendedDuration", this.expirationAdder);
        if (this.expirationOverride != null) {
            edit.putLong("osmdroid.ExpirationOverride", this.expirationOverride.longValue());
        }
        edit.commit();
    }

    private static void load(SharedPreferences pPrefs, Map<String, String> pMap, String pPrefix) {
        pMap.clear();
        for (String key : pPrefs.getAll().keySet()) {
            if (!key.startsWith(pPrefix)) continue;
            pMap.put(key.substring(pPrefix.length()), pPrefs.getString(key, null));
        }
    }

    private static void save(SharedPreferences pPrefs, SharedPreferences.Editor pEdit, Map<String, String> pMap, String pPrefix) {
        for (String string : pPrefs.getAll().keySet()) {
            if (!string.startsWith(pPrefix)) continue;
            pEdit.remove(string);
        }
        for (Map.Entry entry : pMap.entrySet()) {
            String key = pPrefix + (String)entry.getKey();
            pEdit.putString(key, (String)entry.getValue());
        }
    }

    @Override
    public long getExpirationExtendedDuration() {
        return this.expirationAdder;
    }

    @Override
    public void setExpirationExtendedDuration(long period) {
        this.expirationAdder = period < 0L ? 0L : period;
    }

    @Override
    public void setExpirationOverrideDuration(Long period) {
        this.expirationOverride = period;
    }

    @Override
    public Long getExpirationOverrideDuration() {
        return this.expirationOverride;
    }
}

